/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.jms;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.output.adapter.jms.JMSEventAdapter;

public class JMSEventAdapterFactory
extends OutputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.output.adapter.jms.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "jms";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportedMessageFormats = new ArrayList<String>();
        supportedMessageFormats.add("text");
        supportedMessageFormats.add("map");
        supportedMessageFormats.add("xml");
        supportedMessageFormats.add("json");
        return supportedMessageFormats;
    }

    public List<Property> getStaticPropertyList() {
        ArrayList<Property> staticPropertyList = new ArrayList<Property>();
        Property initialContextProperty = new Property("java.naming.factory.initial");
        initialContextProperty.setDisplayName(this.resourceBundle.getString("java.naming.factory.initial"));
        initialContextProperty.setRequired(true);
        initialContextProperty.setHint(this.resourceBundle.getString("java.naming.factory.initial.hint"));
        Property connectionFactoryNameProperty = new Property("transport.jms.ConnectionFactoryJNDIName");
        connectionFactoryNameProperty.setRequired(true);
        connectionFactoryNameProperty.setDisplayName(this.resourceBundle.getString("transport.jms.ConnectionFactoryJNDIName"));
        connectionFactoryNameProperty.setHint(this.resourceBundle.getString("transport.jms.ConnectionFactoryJNDIName.hint"));
        Property javaNamingProviderUrlProperty = new Property("java.naming.provider.url");
        javaNamingProviderUrlProperty.setDisplayName(this.resourceBundle.getString("java.naming.provider.url"));
        javaNamingProviderUrlProperty.setRequired(true);
        javaNamingProviderUrlProperty.setHint(this.resourceBundle.getString("java.naming.provider.url.hint"));
        Property userNameProperty = new Property("transport.jms.UserName");
        userNameProperty.setDisplayName(this.resourceBundle.getString("transport.jms.UserName"));
        Property passwordProperty = new Property("transport.jms.Password");
        passwordProperty.setSecured(true);
        passwordProperty.setEncrypted(true);
        passwordProperty.setDisplayName(this.resourceBundle.getString("transport.jms.Password"));
        Property destinationTypeProperty = new Property("transport.jms.DestinationType");
        destinationTypeProperty.setRequired(true);
        destinationTypeProperty.setDisplayName(this.resourceBundle.getString("transport.jms.DestinationType"));
        destinationTypeProperty.setOptions(new String[]{"queue", "topic"});
        destinationTypeProperty.setDefaultValue("topic");
        destinationTypeProperty.setHint(this.resourceBundle.getString("transport.jms.DestinationType.hint"));
        Property topicProperty = new Property("transport.jms.Destination");
        topicProperty.setDisplayName(this.resourceBundle.getString("transport.jms.Destination"));
        topicProperty.setRequired(true);
        Property concurrentPublishers = new Property("transport.jms.ConcurrentPublishers");
        concurrentPublishers.setDisplayName(this.resourceBundle.getString("transport.jms.ConcurrentPublishers"));
        concurrentPublishers.setOptions(new String[]{"allow", "disallow"});
        concurrentPublishers.setHint(this.resourceBundle.getString("transport.jms.ConcurrentPublishers.hint"));
        Property jmsProperties = new Property("jms.properties");
        jmsProperties.setDisplayName(this.resourceBundle.getString("jms.properties"));
        jmsProperties.setHint(this.resourceBundle.getString("jms.properties.hint"));
        jmsProperties.setRequired(false);
        Property jmsSecuredProperties = new Property("jms.secured.properties");
        jmsSecuredProperties.setDisplayName(this.resourceBundle.getString("jms.secured.properties"));
        jmsSecuredProperties.setHint(this.resourceBundle.getString("jms.secured.properties.hint"));
        jmsSecuredProperties.setRequired(false);
        jmsSecuredProperties.setEncrypted(true);
        jmsSecuredProperties.setSecured(true);
        staticPropertyList.add(initialContextProperty);
        staticPropertyList.add(javaNamingProviderUrlProperty);
        staticPropertyList.add(userNameProperty);
        staticPropertyList.add(passwordProperty);
        staticPropertyList.add(connectionFactoryNameProperty);
        staticPropertyList.add(destinationTypeProperty);
        staticPropertyList.add(topicProperty);
        staticPropertyList.add(concurrentPublishers);
        staticPropertyList.add(jmsProperties);
        staticPropertyList.add(jmsSecuredProperties);
        return staticPropertyList;
    }

    public List<Property> getDynamicPropertyList() {
        ArrayList<Property> dynamicPropertyList = new ArrayList<Property>();
        Property headerProperty = new Property("transport.jms.Header");
        headerProperty.setDisplayName(this.resourceBundle.getString("transport.jms.Header"));
        headerProperty.setHint(this.resourceBundle.getString("transport.jms.Header.Hint"));
        dynamicPropertyList.add(headerProperty);
        return dynamicPropertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new JMSEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

