/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.jms;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.output.adapter.jms.internal.util.JMSConnectionFactory;
import org.wso2.carbon.event.output.adapter.jms.internal.util.JMSMessageSender;

public class JMSEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(JMSEventAdapter.class);
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private PublisherDetails publisherDetails = null;
    private static ExecutorService executorService;
    private int tenantId;

    public JMSEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init() throws OutputEventAdapterException {
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (executorService == null) {
            int minThread = "disallow".equals(this.eventAdapterConfiguration.getStaticProperties().get("transport.jms.ConcurrentPublishers")) ? 1 : (this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8);
            int maxThread = "disallow".equals(this.eventAdapterConfiguration.getStaticProperties().get("transport.jms.ConcurrentPublishers")) ? 1 : (this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100);
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            executorService = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueSize));
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        try {
            Hashtable<String, String> adaptorProperties = new Hashtable<String, String>();
            adaptorProperties.putAll(this.eventAdapterConfiguration.getStaticProperties());
            JMSConnectionFactory jmsConnectionFactory = new JMSConnectionFactory(adaptorProperties, this.eventAdapterConfiguration.getName(), (String)adaptorProperties.get("transport.jms.Destination"), 1);
            Connection connection = jmsConnectionFactory.createConnection();
            connection.createSession(false, 1);
            connection.close();
            jmsConnectionFactory.close();
        }
        catch (Exception e) {
            throw new OutputEventAdapterRuntimeException((Throwable)e);
        }
    }

    public void connect() {
        String topicName = (String)this.eventAdapterConfiguration.getStaticProperties().get("transport.jms.Destination");
        HashMap<String, String> messageConfig = new HashMap<String, String>();
        messageConfig.put("transport.jms.Destination", topicName);
        this.publisherDetails = this.initPublisher(this.eventAdapterConfiguration, messageConfig);
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        try {
            executorService.submit(new JMSSender(message, dynamicProperties));
        }
        catch (RejectedExecutionException e) {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
        if (this.publisherDetails != null) {
            this.publisherDetails.getJmsMessageSender().close();
            this.publisherDetails.getJmsConnectionFactory().close();
        }
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return false;
    }

    private PublisherDetails initPublisher(OutputEventAdapterConfiguration outputEventAdaptorConfiguration, Map<String, String> messageConfig) {
        Hashtable<String, String> adapterProperties = this.convertMapToHashTable(outputEventAdaptorConfiguration.getStaticProperties());
        Map<String, String> jmsProperties = this.extractProperties((String)this.eventAdapterConfiguration.getStaticProperties().get("jms.properties"));
        Map<String, String> jmsSecuredProperties = this.extractProperties((String)this.eventAdapterConfiguration.getStaticProperties().get("jms.secured.properties"));
        if (jmsProperties != null) {
            adapterProperties.remove("jms.properties");
            adapterProperties.putAll(jmsProperties);
        }
        if (jmsSecuredProperties != null) {
            adapterProperties.remove("jms.secured.properties");
            adapterProperties.putAll(jmsSecuredProperties);
        }
        int maxConnections = "disallow".equals(this.eventAdapterConfiguration.getStaticProperties().get("transport.jms.ConcurrentPublishers")) ? 1 : (this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100);
        JMSConnectionFactory jmsConnectionFactory = new JMSConnectionFactory(adapterProperties, outputEventAdaptorConfiguration.getName(), messageConfig.get("transport.jms.Destination"), maxConnections);
        JMSMessageSender jmsMessageSender = new JMSMessageSender(jmsConnectionFactory);
        PublisherDetails publisherDetails = new PublisherDetails(jmsConnectionFactory, jmsMessageSender, messageConfig);
        return publisherDetails;
    }

    private Hashtable<String, String> convertMapToHashTable(Map<String, String> map) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (Map.Entry<String, String> pair : map.entrySet()) {
            if (pair.getValue() == null) continue;
            table.put(pair.getKey().toString(), pair.getValue().toString());
        }
        return table;
    }

    private Map<String, String> extractProperties(String properties) {
        if (properties == null || properties.trim().length() == 0) {
            return null;
        }
        String[] entries = properties.split(",");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String property : entries) {
            try {
                String[] keyValue = property.split(":", 2);
                result.put(keyValue[0].trim(), keyValue[1].trim());
            }
            catch (Exception e) {
                log.warn((Object)("JMS property '" + property + "' is not defined in the correct format."), (Throwable)e);
            }
        }
        return result;
    }

    public class JMSSender
    implements Runnable {
        private Object jmsMessage;
        private Map<String, String> dynamicProperties;

        public JMSSender(Object jmsMessage, Map<String, String> dynamicProperties) {
            this.jmsMessage = jmsMessage;
            this.dynamicProperties = dynamicProperties;
        }

        @Override
        public void run() {
            JMSEventAdapter.this.publisherDetails.getJmsMessageSender().send(this.jmsMessage, JMSEventAdapter.this.publisherDetails, this.dynamicProperties.get("transport.jms.Header"));
        }
    }

    public static class PublisherDetails {
        private final JMSConnectionFactory jmsConnectionFactory;
        private final JMSMessageSender jmsMessageSender;
        private final Map<String, String> messageConfig;

        public PublisherDetails(JMSConnectionFactory jmsConnectionFactory, JMSMessageSender jmsMessageSender, Map<String, String> messageConfig) {
            this.jmsConnectionFactory = jmsConnectionFactory;
            this.jmsMessageSender = jmsMessageSender;
            this.messageConfig = messageConfig;
        }

        public JMSConnectionFactory getJmsConnectionFactory() {
            return this.jmsConnectionFactory;
        }

        public JMSMessageSender getJmsMessageSender() {
            return this.jmsMessageSender;
        }

        public Map<String, String> getMessageConfig() {
            return this.messageConfig;
        }
    }
}

