/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.ui.servlet;

import com.google.gson.Gson;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.user.mgt.stub.types.carbon.ClaimValue;
import org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName;
import org.wso2.carbon.user.mgt.stub.types.carbon.UserRealmInfo;
import org.wso2.carbon.user.mgt.ui.PaginatedNamesBean;
import org.wso2.carbon.user.mgt.ui.RoleBean;
import org.wso2.carbon.user.mgt.ui.UserAdminClient;
import org.wso2.carbon.user.mgt.ui.UserAdminUIConstants;
import org.wso2.carbon.user.mgt.ui.UserBean;
import org.wso2.carbon.user.mgt.ui.Util;
import org.wso2.carbon.user.mgt.ui.bean.RoleSearchResult;
import org.wso2.carbon.user.mgt.ui.bean.UserSearchResult;

public class UserAndRoleManagementServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(UserAndRoleManagementServlet.class);
    private static final String PERMISSION_VIEWTASKS = "/permission/admin/manage/humantask/viewtasks";
    private static final String USERS = "users";
    private static final String CATEGORY = "category";
    private static final String ROLES = "roles";
    private static final String PREVIOUS_ROLE = "previousRole";
    private static final String DOMAIN = "domain";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String category = request.getParameter(CATEGORY);
        HttpSession session = request.getSession();
        if (USERS.equals(category)) {
            PaginatedNamesBean bean;
            String userDomainSelector;
            boolean error = false;
            boolean newFilter = false;
            boolean doUserList = true;
            boolean showFilterMessage = false;
            boolean multipleUserStores = false;
            String forwardTo = "user-mgt.jsp";
            FlaggedName[] datas = null;
            FlaggedName exceededDomains = null;
            String[] claimUris = null;
            FlaggedName[] users = null;
            Object domainNames = null;
            int pageNumber = 0;
            int cachePages = 3;
            int noOfPageLinksToDisplay = 5;
            int numberOfPages = 0;
            HashMap<Integer, PaginatedNamesBean> flaggedNameMap = null;
            String BUNDLE = "org.wso2.carbon.userstore.ui.i18n.Resources";
            ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE, request.getLocale());
            session.removeAttribute("userBean");
            session.removeAttribute("user.display.name");
            session.removeAttribute("user.list.unassigned.role.cache");
            session.removeAttribute("user.list.unassigned.role.cache.exceeded.domains");
            session.removeAttribute("user.list.assigned.role.cache");
            session.removeAttribute("user.list.assigned.role.cache.exceeded.domains");
            session.removeAttribute("user.list.add.user.cache");
            session.removeAttribute("user.list.add.user.cache.exceeded.domains");
            session.removeAttribute("org.wso2.carbon.user.assign.filter");
            session.removeAttribute("org.wso2.carbon.user.unassigned.role.filter");
            session.removeAttribute("org.wso2.carbon.user.view.role.filter");
            session.removeAttribute("user.list.cache");
            UserRealmInfo userRealmInfo = (UserRealmInfo)session.getAttribute("org.wso2.carbon.userstore.info");
            if (userRealmInfo != null) {
                multipleUserStores = userRealmInfo.getMultipleUserStore();
            }
            String errorAttribute = (String)session.getAttribute("org.wso2.carbon.user.list.error");
            String claimUri = request.getParameter("claimUri");
            if (claimUri == null || claimUri.length() == 0) {
                claimUri = (String)session.getAttribute("org.wso2.carbon.user.claim.filter");
            }
            session.setAttribute("org.wso2.carbon.user.claim.filter", (Object)claimUri);
            exceededDomains = (FlaggedName)session.getAttribute("user.list.cache.exceeded.domains");
            String selectedDomain = request.getParameter(DOMAIN);
            if (selectedDomain == null || selectedDomain.trim().length() == 0) {
                selectedDomain = (String)session.getAttribute("org.wso2.carbon.user.domain.filter");
                if (selectedDomain == null || selectedDomain.trim().length() == 0) {
                    selectedDomain = "ALL-USER-STORE-DOMAINS";
                }
            } else {
                newFilter = true;
            }
            session.setAttribute("org.wso2.carbon.user.domain.filter", (Object)selectedDomain.trim());
            String filter = request.getParameter("org.wso2.carbon.user.filter");
            if (filter == null || filter.trim().length() == 0) {
                filter = "*";
            } else {
                if (filter.contains(UserAdminUIConstants.DOMAIN_SEPARATOR)) {
                    selectedDomain = "ALL-USER-STORE-DOMAINS";
                    session.removeAttribute("org.wso2.carbon.user.domain.filter");
                }
                newFilter = true;
            }
            String modifiedFilter = filter.trim();
            if (!"ALL-USER-STORE-DOMAINS".equalsIgnoreCase(selectedDomain)) {
                modifiedFilter = selectedDomain + UserAdminUIConstants.DOMAIN_SEPARATOR + filter;
                modifiedFilter = modifiedFilter.trim();
                userDomainSelector = selectedDomain + UserAdminUIConstants.DOMAIN_SEPARATOR + "*";
            } else {
                userDomainSelector = "*";
            }
            session.setAttribute("org.wso2.carbon.user.filter", (Object)filter.trim());
            String pageNumberStr = request.getParameter("pageNumber");
            if (pageNumberStr == null) {
                pageNumberStr = "0";
            }
            if (userRealmInfo != null) {
                claimUris = userRealmInfo.getRequiredUserClaims();
            }
            try {
                pageNumber = Integer.parseInt(pageNumberStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            flaggedNameMap = (HashMap<Integer, PaginatedNamesBean>)session.getAttribute("user.list.cache");
            if (flaggedNameMap != null && (bean = (PaginatedNamesBean)flaggedNameMap.get(pageNumber)) != null && (users = bean.getNames()) != null && users.length > 0) {
                numberOfPages = bean.getNumberOfPages();
                doUserList = false;
            }
            if (errorAttribute != null) {
                error = true;
                session.removeAttribute("org.wso2.carbon.user.list.error");
            }
            if ((doUserList || newFilter) && !error) {
                String backendServerURL;
                try {
                    String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
                    backendServerURL = CarbonUIUtil.getServerURL((ServletContext)this.getServletConfig().getServletContext(), (HttpSession)session);
                    ConfigurationContext configContext = (ConfigurationContext)this.getServletConfig().getServletContext().getAttribute("ConfigurationContext");
                    UserAdminClient client = new UserAdminClient(cookie, backendServerURL, configContext);
                    if (userRealmInfo == null) {
                        userRealmInfo = client.getUserRealmInfo();
                        session.setAttribute("org.wso2.carbon.userstore.info", (Object)userRealmInfo);
                    }
                    if (userRealmInfo != null) {
                        claimUris = userRealmInfo.getRequiredUserClaims();
                    }
                    if (filter.length() > 0) {
                        if (claimUri != null && !"select".equalsIgnoreCase(claimUri)) {
                            ClaimValue claimValue = new ClaimValue();
                            claimValue.setClaimURI(claimUri);
                            claimValue.setValue(modifiedFilter);
                            datas = client.listUserByClaimWithPermission(claimValue, userDomainSelector, PERMISSION_VIEWTASKS, -1);
                        } else {
                            datas = client.listAllUsersWithPermission(modifiedFilter, PERMISSION_VIEWTASKS, -1);
                        }
                        ArrayList<FlaggedName> dataList = new ArrayList<FlaggedName>(Arrays.asList(datas));
                        exceededDomains = (FlaggedName)dataList.remove(dataList.size() - 1);
                        session.setAttribute("user.list.cache.exceeded.domains", (Object)exceededDomains);
                        if (dataList.size() == 0) {
                            session.removeAttribute("org.wso2.carbon.user.filter");
                            showFilterMessage = true;
                        }
                        flaggedNameMap = new HashMap<Integer, PaginatedNamesBean>();
                        int max = pageNumber + cachePages;
                        for (int i = pageNumber - cachePages; i < max; ++i) {
                            if (i < 0) {
                                ++max;
                                continue;
                            }
                            PaginatedNamesBean bean2 = Util.retrievePaginatedFlaggedName(i, dataList);
                            flaggedNameMap.put(i, bean2);
                            if (bean2.getNumberOfPages() == i + 1) break;
                        }
                        users = ((PaginatedNamesBean)flaggedNameMap.get(pageNumber)).getNames();
                        numberOfPages = ((PaginatedNamesBean)flaggedNameMap.get(pageNumber)).getNumberOfPages();
                        session.setAttribute("user.list.cache", flaggedNameMap);
                    }
                }
                catch (Exception e) {
                    backendServerURL = MessageFormat.format(resourceBundle.getString("error.while.user.filtered"), e.getMessage());
                }
                String resp = "";
                if (users != null) {
                    UserBean[] userList = new UserBean[users.length];
                    for (int i = 0; i < users.length; ++i) {
                        FlaggedName flaggedName = users[i];
                        UserBean user = new UserBean();
                        user.setUsername(flaggedName.getItemName());
                        userList[i] = user;
                    }
                    UserSearchResult userSearchResult = new UserSearchResult();
                    userSearchResult.setPageNumber(pageNumber);
                    userSearchResult.setNumberOfPages(numberOfPages);
                    userSearchResult.setNoOfPageLinksToDisplay(noOfPageLinksToDisplay);
                    userSearchResult.setUserBeans(userList);
                    Gson gson = new Gson();
                    resp = gson.toJson((Object)userSearchResult);
                }
                response.setContentType("application/json");
                response.getWriter().write(resp);
            }
        } else if (ROLES.equals(category)) {
            PaginatedNamesBean bean;
            boolean error = false;
            boolean newFilter = false;
            boolean doRoleList = true;
            boolean showFilterMessage = false;
            boolean multipleUserStores = false;
            ArrayList<FlaggedName> datasList = null;
            FlaggedName[] roles = null;
            FlaggedName exceededDomains = null;
            Object domainNames = null;
            int pageNumber = 0;
            int cachePages = 3;
            int noOfPageLinksToDisplay = 5;
            int numberOfPages = 0;
            HashMap<Integer, PaginatedNamesBean> flaggedNameMap = null;
            UserRealmInfo userRealmInfo = null;
            session.removeAttribute("roleBean");
            session.removeAttribute("org.wso2.carbon.role.read.only");
            session.removeAttribute("role.list.unassigned.user.cache");
            session.removeAttribute("role.list.unassigned.user.cache.exceeded.domains");
            session.removeAttribute("role.list.assigned.user.cache");
            session.removeAttribute("role.list.assigned.user.cache.exceeded.domains");
            session.removeAttribute("role.list.add.role.cache");
            session.removeAttribute("role.list.add.role.cache.exceeded.domains");
            session.removeAttribute("org.wso2.carbon.role.assign.filter");
            session.removeAttribute("org.wso2.carbon.role.unassigned.user.filter");
            session.removeAttribute("org.wso2.carbon.role.view.user.filter");
            session.removeAttribute("role.list.cache");
            session.removeAttribute(PREVIOUS_ROLE);
            String selectedDomain = request.getParameter(DOMAIN);
            if (StringUtils.isBlank((String)selectedDomain)) {
                selectedDomain = (String)session.getAttribute("org.wso2.carbon.role.domain.filter");
                if (selectedDomain == null || selectedDomain.trim().length() == 0) {
                    selectedDomain = "ALL-USER-STORE-DOMAINS";
                }
            } else {
                newFilter = true;
            }
            session.setAttribute("org.wso2.carbon.role.domain.filter", (Object)selectedDomain.trim());
            String filter = request.getParameter("org.wso2.carbon.role.filter");
            if (filter == null || filter.trim().length() == 0) {
                filter = (String)session.getAttribute("org.wso2.carbon.role.filter");
                if (filter == null || filter.trim().length() == 0) {
                    filter = "*";
                }
            } else {
                if (filter.contains(UserAdminUIConstants.DOMAIN_SEPARATOR)) {
                    selectedDomain = "ALL-USER-STORE-DOMAINS";
                    session.removeAttribute("org.wso2.carbon.role.domain.filter");
                }
                newFilter = true;
            }
            String modifiedFilter = filter.trim();
            if (!"ALL-USER-STORE-DOMAINS".equalsIgnoreCase(selectedDomain)) {
                modifiedFilter = selectedDomain + UserAdminUIConstants.DOMAIN_SEPARATOR + filter;
                modifiedFilter = modifiedFilter.trim();
            }
            session.setAttribute("org.wso2.carbon.role.filter", (Object)filter.trim());
            userRealmInfo = (UserRealmInfo)session.getAttribute("org.wso2.carbon.userstore.info");
            if (userRealmInfo != null) {
                multipleUserStores = userRealmInfo.getMultipleUserStore();
            }
            String errorAttribute = (String)session.getAttribute("org.wso2.carbon.role.list.error");
            exceededDomains = (FlaggedName)session.getAttribute("role.list.cache.exceeded.domains");
            String pageNumberStr = request.getParameter("pageNumber");
            if (pageNumberStr == null) {
                pageNumberStr = "0";
            }
            try {
                pageNumber = Integer.parseInt(pageNumberStr);
            }
            catch (NumberFormatException claimUri) {
                // empty catch block
            }
            flaggedNameMap = (HashMap<Integer, PaginatedNamesBean>)session.getAttribute("role.list.cache");
            if (flaggedNameMap != null && (bean = (PaginatedNamesBean)flaggedNameMap.get(pageNumber)) != null && (roles = bean.getNames()) != null && roles.length > 0) {
                numberOfPages = bean.getNumberOfPages();
                doRoleList = false;
            }
            if (errorAttribute != null) {
                error = true;
                session.removeAttribute("org.wso2.carbon.role.list.error");
            }
            if ((doRoleList || newFilter) && !error) {
                try {
                    String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
                    String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)this.getServletConfig().getServletContext(), (HttpSession)session);
                    ConfigurationContext configContext = (ConfigurationContext)this.getServletConfig().getServletContext().getAttribute("ConfigurationContext");
                    UserAdminClient client = new UserAdminClient(cookie, backendServerURL, configContext);
                    boolean sharedRoleEnabled = client.isSharedRolesEnabled();
                    session.setAttribute("shared.role.enabled", (Object)sharedRoleEnabled);
                    if (filter.length() > 0) {
                        FlaggedName[] datas = client.getAllPermittedRoleNames(modifiedFilter, PERMISSION_VIEWTASKS, -1);
                        datasList = new ArrayList<FlaggedName>(Arrays.asList(datas));
                        exceededDomains = (FlaggedName)datasList.remove(datasList.size() - 1);
                        session.setAttribute("role.list.cache.exceeded.domains", (Object)exceededDomains);
                        datas = datasList.toArray(new FlaggedName[datasList.size()]);
                        if (datas == null || datas.length == 0) {
                            session.removeAttribute("org.wso2.carbon.role.filter");
                            showFilterMessage = true;
                        }
                    }
                    if (userRealmInfo == null) {
                        userRealmInfo = client.getUserRealmInfo();
                        session.setAttribute("org.wso2.carbon.userstore.info", (Object)userRealmInfo);
                    }
                    if (datasList != null) {
                        flaggedNameMap = new HashMap<Integer, PaginatedNamesBean>();
                        int max = pageNumber + cachePages;
                        for (int i = pageNumber - cachePages; i < max; ++i) {
                            if (i < 0) {
                                ++max;
                                continue;
                            }
                            PaginatedNamesBean bean3 = Util.retrievePaginatedFlaggedName(i, datasList);
                            flaggedNameMap.put(i, bean3);
                            if (bean3.getNumberOfPages() == i + 1) break;
                        }
                        roles = ((PaginatedNamesBean)flaggedNameMap.get(pageNumber)).getNames();
                        numberOfPages = ((PaginatedNamesBean)flaggedNameMap.get(pageNumber)).getNumberOfPages();
                        session.setAttribute("role.list.cache", flaggedNameMap);
                    }
                }
                catch (Exception cookie) {
                    // empty catch block
                }
                String resp = "";
                if (roles != null) {
                    RoleBean[] roleList = new RoleBean[roles.length];
                    for (int i = 0; i < roles.length; ++i) {
                        FlaggedName flaggedName = roles[i];
                        RoleBean role = new RoleBean();
                        role.setRoleName(flaggedName.getItemName());
                        roleList[i] = role;
                    }
                    RoleSearchResult roleSearchResult = new RoleSearchResult();
                    roleSearchResult.setPageNumber(pageNumber);
                    roleSearchResult.setNumberOfPages(numberOfPages);
                    roleSearchResult.setNoOfPageLinksToDisplay(noOfPageLinksToDisplay);
                    roleSearchResult.setRoleBeans(roleList);
                    Gson gson = new Gson();
                    resp = gson.toJson((Object)roleSearchResult);
                }
                response.setContentType("application/json");
                response.getWriter().write(resp);
            }
        }
    }
}

