/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.ui.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.governance.stub.IdentityGovernanceAdminServiceIdentityGovernanceExceptionException;
import org.wso2.carbon.identity.governance.stub.IdentityGovernanceAdminServiceStub;
import org.wso2.carbon.identity.governance.stub.bean.ConnectorConfig;
import org.wso2.carbon.identity.governance.stub.bean.Property;

public class IdentityGovernanceAdminClient {
    protected IdentityGovernanceAdminServiceStub stub = null;
    public static final String IDENTITY_MGT_ADMIN_SERVICE_URL = "IdentityGovernanceAdminService";
    public static final String DEFAULT = "DEFAULT";
    private static final Log log = LogFactory.getLog(IdentityGovernanceAdminClient.class);

    public IdentityGovernanceAdminClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new IdentityGovernanceAdminServiceStub(configContext, backendServerURL + IDENTITY_MGT_ADMIN_SERVICE_URL);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            throw new Exception("Error occurred while creating IdentityGovernanceAdminClient Object", e);
        }
    }

    public Map<String, Map<String, List<ConnectorConfig>>> getConnectorList() throws RemoteException, IdentityGovernanceAdminServiceIdentityGovernanceExceptionException {
        ConnectorConfig[] configs = this.stub.getConnectorList();
        HashMap<String, Map<String, List<ConnectorConfig>>> catMap = new HashMap<String, Map<String, List<ConnectorConfig>>>();
        if (configs != null) {
            for (ConnectorConfig conf : configs) {
                ArrayList<ConnectorConfig> confList;
                String categoryName = StringUtils.isBlank((String)conf.getCategory()) ? DEFAULT : conf.getCategory();
                String subCategoryName = StringUtils.isBlank((String)conf.getSubCategory()) ? DEFAULT : conf.getSubCategory();
                HashMap<String, ArrayList<ConnectorConfig>> subCatMap = (HashMap<String, ArrayList<ConnectorConfig>>)catMap.get(categoryName);
                if (subCatMap == null) {
                    subCatMap = new HashMap<String, ArrayList<ConnectorConfig>>();
                    catMap.put(categoryName, subCatMap);
                }
                if ((confList = (ArrayList<ConnectorConfig>)subCatMap.get(subCategoryName)) == null) {
                    confList = new ArrayList<ConnectorConfig>();
                    subCatMap.put(subCategoryName, confList);
                }
                confList.add(conf);
            }
        }
        return catMap;
    }

    public void updateConfigurations(Property[] properties) throws RemoteException, IdentityGovernanceAdminServiceIdentityGovernanceExceptionException {
        this.stub.updateConfigurations(properties);
    }
}

