/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.ui.client;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.ClaimMetadataManagementServiceClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.ClaimMetadataManagementServiceStub;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.dto.ClaimPropertyDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.dto.LocalClaimDTO;
import org.wso2.carbon.user.mgt.ui.ClaimDataAdminException;

public class ClaimDataAdminClient {
    private ClaimMetadataManagementServiceStub stub;
    private static final String SERVICE = "ClaimMetadataManagementService";

    public ClaimDataAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + SERVICE;
        this.stub = new ClaimMetadataManagementServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public LocalClaimDTO[] getLocalClaims() throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        LocalClaimDTO[] localClaimDTOs = this.stub.getLocalClaims();
        if (localClaimDTOs == null) {
            localClaimDTOs = new LocalClaimDTO[]{};
        }
        return localClaimDTOs;
    }

    public String getRegex(LocalClaimDTO[] localClaimDTO, String claimURI) {
        String pattern = "";
        block0: for (LocalClaimDTO localClaim : localClaimDTO) {
            ClaimPropertyDTO[] claimPropertyDTOs;
            if (!claimURI.equals(localClaim.getLocalClaimURI()) || (claimPropertyDTOs = localClaim.getClaimProperties()) == null) continue;
            for (ClaimPropertyDTO claimPropertyDTO : claimPropertyDTOs) {
                if (!"RegEx".equals(claimPropertyDTO.getPropertyName())) continue;
                pattern = claimPropertyDTO.getPropertyValue();
                pattern = "/" + pattern + "/";
                continue block0;
            }
        }
        return pattern;
    }

    public String getRegex(String claimURI) throws ClaimDataAdminException {
        LocalClaimDTO[] localClaims = new LocalClaimDTO[]{};
        try {
            localClaims = this.getLocalClaims();
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            throw new ClaimDataAdminException("Error while accessing claims.", e);
        }
        catch (RemoteException e) {
            throw new ClaimDataAdminException("Error while getting new claims.", e);
        }
        return this.getRegex(localClaims, claimURI);
    }
}

