/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.util.AdminServicesUtil;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.stub.bean.ConnectorConfig;
import org.wso2.carbon.identity.governance.stub.bean.Property;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.user.mgt.common.DefaultPasswordGenerator;
import org.wso2.carbon.user.mgt.common.RandomPasswordGenerator;
import org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName;
import org.wso2.carbon.user.mgt.stub.types.carbon.UserRealmInfo;
import org.wso2.carbon.user.mgt.stub.types.carbon.UserStoreInfo;
import org.wso2.carbon.user.mgt.ui.PaginatedNamesBean;
import org.wso2.carbon.user.mgt.ui.UserAdminUIConstants;
import org.wso2.carbon.user.mgt.ui.UserManagementUIException;
import org.wso2.carbon.user.mgt.ui.client.IdentityGovernanceAdminClient;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.Pageable;

public class Util {
    public static final String ALL = "ALL";
    private static final Log log = LogFactory.getLog(Util.class);
    private static final String EMAIL_VERIFICATION_ENABLE_PROP_NAME = "EmailVerification.Enable";
    private static final String ASK_PASSWORD_TEMP_PASSWORD_GENERATOR = "EmailVerification.AskPassword.PasswordGenerator";
    private static final String ASK_PASSWORD_ADMIN_UI_ENABLE_PROP_NAME = "EnableAskPasswordAdminUI";
    private static final String ENCRYPT_USERNAME_IN_URL = "encryptUsernameInUrl";
    private static boolean isAskPasswordAdminUIEnabled;
    private static boolean isAskPasswordEnabled;

    private Util() {
    }

    public static String getDN(String roleName, int index, FlaggedName[] names) {
        if (names != null && names.length > index) {
            return names[index].getDn();
        }
        return null;
    }

    public static UserStoreInfo getUserStoreInfo(String domainName, UserRealmInfo realmInfo) {
        for (UserStoreInfo info : realmInfo.getUserStoresInfo()) {
            if (domainName == null || !domainName.equalsIgnoreCase(info.getDomainName())) continue;
            return info;
        }
        return null;
    }

    public static UserStoreInfo getUserStoreInfoForUser(String userName, UserRealmInfo realmInfo) {
        if (userName != null && userName.contains(UserAdminUIConstants.DOMAIN_SEPARATOR)) {
            String domainName = userName.substring(0, userName.indexOf(UserAdminUIConstants.DOMAIN_SEPARATOR));
            for (UserStoreInfo info : realmInfo.getUserStoresInfo()) {
                if (domainName == null || !domainName.equalsIgnoreCase(info.getDomainName())) continue;
                return info;
            }
        }
        return realmInfo.getPrimaryUserStoreInfo();
    }

    public static DataHandler buildDataHandler(byte[] content) {
        DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(content, "application/octet-stream"));
        return dataHandler;
    }

    public static PaginatedNamesBean retrievePaginatedFlaggedName(int pageNumber, String[] names) {
        ArrayList<FlaggedName> list = new ArrayList<FlaggedName>();
        for (String name : names) {
            FlaggedName flaggedName = new FlaggedName();
            flaggedName.setItemName(name);
            list.add(flaggedName);
        }
        return Util.retrievePaginatedFlaggedName(pageNumber, list);
    }

    public static PaginatedNamesBean retrievePaginatedFlaggedName(int pageNumber, List<FlaggedName> names) {
        PaginatedNamesBean bean = new PaginatedNamesBean();
        DataPaginator.doPaging((int)pageNumber, names, (Pageable)bean);
        return bean;
    }

    public static void updateCheckboxStateMap(Map<String, Boolean> checkBoxMap, Map<Integer, PaginatedNamesBean> flaggedNamesMap, String selectedBoxesStr, String unselectedBoxesStr, String regex) {
        if (selectedBoxesStr != null || unselectedBoxesStr != null) {
            if (selectedBoxesStr != null && ALL.equals(selectedBoxesStr) || unselectedBoxesStr != null && ALL.equals(unselectedBoxesStr)) {
                FlaggedName[] flaggedNames;
                if (selectedBoxesStr != null && ALL.equals(selectedBoxesStr) && flaggedNamesMap != null) {
                    for (Map.Entry<Integer, PaginatedNamesBean> entry : flaggedNamesMap.entrySet()) {
                        for (FlaggedName flaggedName : flaggedNames = entry.getValue().getNames()) {
                            if (!flaggedName.getEditable()) continue;
                            checkBoxMap.put(flaggedName.getItemName(), true);
                        }
                    }
                }
                if (unselectedBoxesStr != null && ALL.equals(unselectedBoxesStr) && flaggedNamesMap != null) {
                    for (Map.Entry<Integer, PaginatedNamesBean> entry : flaggedNamesMap.entrySet()) {
                        for (FlaggedName flaggedName : flaggedNames = entry.getValue().getNames()) {
                            if (!flaggedName.getEditable()) continue;
                            checkBoxMap.put(flaggedName.getItemName(), false);
                        }
                    }
                }
                return;
            }
            if (selectedBoxesStr != null && !"".equals(selectedBoxesStr)) {
                String[] selectedBoxes;
                for (String selectedBox : selectedBoxes = selectedBoxesStr.split(regex)) {
                    checkBoxMap.put(selectedBox, true);
                }
            }
            if (unselectedBoxesStr != null && !"".equals(unselectedBoxesStr)) {
                String[] unselectedBoxes;
                for (String unselectedBox : unselectedBoxes = unselectedBoxesStr.split(regex)) {
                    checkBoxMap.put(unselectedBox, false);
                }
            }
        }
    }

    public static boolean isAskPasswordEnabled() {
        return isAskPasswordEnabled;
    }

    public static boolean isUserOnBoardingEnabled(ServletContext context, HttpSession session) {
        Map<String, Map<String, List<ConnectorConfig>>> connectorList;
        if (!isAskPasswordAdminUIEnabled) {
            return false;
        }
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)context, (HttpSession)session);
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        ConfigurationContext configContext = (ConfigurationContext)context.getAttribute("ConfigurationContext");
        try {
            IdentityGovernanceAdminClient client = new IdentityGovernanceAdminClient(cookie, backendServerURL, configContext);
            connectorList = client.getConnectorList();
        }
        catch (Exception e) {
            log.error((Object)("Error while getting connector list from governance service, at URL :" + backendServerURL), (Throwable)e);
            return false;
        }
        if (connectorList != null) {
            for (Map.Entry<String, Map<String, List<ConnectorConfig>>> entry : connectorList.entrySet()) {
                Map<String, List<ConnectorConfig>> subCatList = entry.getValue();
                for (String subCatKey : subCatList.keySet()) {
                    List<ConnectorConfig> connectorConfigs = subCatList.get(subCatKey);
                    for (ConnectorConfig connectorConfig : connectorConfigs) {
                        Property[] properties;
                        for (Property property : properties = connectorConfig.getProperties()) {
                            if (property == null || !EMAIL_VERIFICATION_ENABLE_PROP_NAME.equals(property.getName())) continue;
                            String propValue = property.getValue();
                            boolean isEmailVerificationEnabled = false;
                            if (!StringUtils.isEmpty((String)propValue)) {
                                isEmailVerificationEnabled = Boolean.parseBoolean(propValue);
                            }
                            return isEmailVerificationEnabled;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static char[] generateRandomPassword(ServletContext context, HttpSession session) {
        char[] tempPass = "password".toCharArray();
        try {
            return Util.getAskPasswordTempPassGenerator(context, session).generatePassword();
        }
        catch (Exception e) {
            log.error((Object)"Error while generating the temporary password. Used the default password as temp password", (Throwable)e);
            return tempPass;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static RandomPasswordGenerator getAskPasswordTempPassGenerator(ServletContext context, HttpSession session) {
        if (!Util.isAskPasswordAdminUIEnabled) {
            return new DefaultPasswordGenerator();
        }
        randomPasswordGenerationClass = "org.wso2.carbon.user.mgt.common.DefaultPasswordGenerator";
        if (Util.isUserOnBoardingEnabled(context, session)) {
            backendServerURL = CarbonUIUtil.getServerURL((ServletContext)context, (HttpSession)session);
            cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
            configContext = (ConfigurationContext)context.getAttribute("ConfigurationContext");
            try {
                client = new IdentityGovernanceAdminClient(cookie, backendServerURL, configContext);
                connectorList = client.getConnectorList();
                if (connectorList == null) ** GOTO lbl31
                for (Map.Entry<String, Map<String, List<ConnectorConfig>>> entry : connectorList.entrySet()) {
                    subCatList = entry.getValue();
                    for (String subCatKey : subCatList.keySet()) {
                        connectorConfigs = subCatList.get(subCatKey);
                        for (ConnectorConfig connectorConfig : connectorConfigs) {
                            for (Property property : properties = connectorConfig.getProperties()) {
                                if (!"EmailVerification.AskPassword.PasswordGenerator".equals(property.getName())) continue;
                                randomPasswordGenerationClass = property.getValue();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Util.log.error((Object)("Error while getting connector list from governance service, at URL :" + backendServerURL), (Throwable)e);
            }
        } else {
            randomPasswordGenerationClassFromFile = IdentityUtil.getProperty((String)"EmailVerification.AskPassword.PasswordGenerator");
            if (StringUtils.isNotBlank((String)randomPasswordGenerationClassFromFile)) {
                randomPasswordGenerationClass = randomPasswordGenerationClassFromFile;
            }
        }
lbl31:
        // 6 sources

        try {
            clazz = Class.forName(randomPasswordGenerationClass);
            return (RandomPasswordGenerator)clazz.newInstance();
        }
        catch (Exception e) {
            Util.log.error((Object)"Error while loading random password generator class. Default random password generator would be used", (Throwable)e);
            return new DefaultPasswordGenerator();
        }
    }

    public static String getEncryptedAndBase64encodedUsername(String username) throws UserManagementUIException {
        String encryptedAndBase64EncodedUsername;
        block4: {
            encryptedAndBase64EncodedUsername = null;
            try {
                if (!StringUtils.isNotBlank((String)username)) break block4;
                boolean isUsernameEncryptionEnabled = Util.isUsernameEncryptionEnabled();
                if (isUsernameEncryptionEnabled) {
                    encryptedAndBase64EncodedUsername = CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(username.getBytes());
                    break block4;
                }
                return username;
            }
            catch (CryptoException e) {
                String message = String.format("Error while trying to encrypt the username : '%s' ", username);
                log.error((Object)message, (Throwable)e);
                throw new UserManagementUIException(message, e);
            }
            catch (CarbonException | UserStoreException e) {
                String message = "Error while trying to get User Realm";
                log.error((Object)message, e);
                throw new UserManagementUIException(message, e);
            }
        }
        return encryptedAndBase64EncodedUsername;
    }

    public static String getDecryptedUsername(String encryptedAndBase64EncodedUsername) throws UserManagementUIException {
        try {
            boolean isUsernameEncryptionEnabled = Util.isUsernameEncryptionEnabled();
            if (isUsernameEncryptionEnabled) {
                return new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(encryptedAndBase64EncodedUsername));
            }
            return encryptedAndBase64EncodedUsername;
        }
        catch (CryptoException e) {
            String message = String.format("Error while trying to decrypt the username : '%s' ", encryptedAndBase64EncodedUsername);
            log.error((Object)message, (Throwable)e);
            throw new UserManagementUIException(message, e);
        }
        catch (CarbonException | UserStoreException e) {
            String message = "Error while trying to get User Realm";
            log.error((Object)message, e);
            throw new UserManagementUIException(message, e);
        }
    }

    public static boolean isCurrentUser(String currentUsername, String username, UserRealmInfo userRealmInfo) {
        if (username.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
            return currentUsername.equalsIgnoreCase(username);
        }
        if (currentUsername.contains(UserCoreConstants.DOMAIN_SEPARATOR) && !"PRIMARY".equalsIgnoreCase(UserCoreUtil.extractDomainFromName((String)currentUsername))) {
            return false;
        }
        return UserCoreUtil.removeDomainFromName((String)currentUsername).equalsIgnoreCase(username);
    }

    private static boolean isUsernameEncryptionEnabled() throws CarbonException, UserStoreException {
        return Boolean.parseBoolean((String)AdminServicesUtil.getUserRealm().getRealmConfiguration().getRealmProperties().get(ENCRYPT_USERNAME_IN_URL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        isAskPasswordEnabled = true;
        String isAskPasswordAdminUIEnabledProperty = IdentityUtil.getProperty((String)ASK_PASSWORD_ADMIN_UI_ENABLE_PROP_NAME);
        if (StringUtils.isNotBlank((String)isAskPasswordAdminUIEnabledProperty)) {
            isAskPasswordAdminUIEnabled = Boolean.parseBoolean(isAskPasswordAdminUIEnabledProperty);
        }
        InputStream is = null;
        try {
            boolean identityMgtListenerEnabled = true;
            IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)UserOperationEventListener.class.getName(), (String)"org.wso2.carbon.identity.mgt.IdentityMgtEventListener");
            if (identityEventListenerConfig != null) {
                identityMgtListenerEnabled = Boolean.parseBoolean(identityEventListenerConfig.getEnable());
            }
            if (identityMgtListenerEnabled) {
                File file = new File(IdentityUtil.getIdentityConfigDirPath() + "/identity-mgt.properties");
                if (file.exists() && file.isFile()) {
                    is = new FileInputStream(file);
                    Properties identityMgtProperties = new Properties();
                    identityMgtProperties.load(is);
                    boolean tempPasswordEnabled = Boolean.parseBoolean(identityMgtProperties.getProperty("Temporary.Password.Enable"));
                    boolean acctVerificationEnabled = Boolean.parseBoolean(identityMgtProperties.getProperty("UserAccount.Verification.Enable"));
                    if (!tempPasswordEnabled || !acctVerificationEnabled) {
                        isAskPasswordEnabled = false;
                    }
                } else {
                    isAskPasswordEnabled = false;
                }
            } else {
                isAskPasswordEnabled = false;
            }
        }
        catch (FileNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("identity-mgt.properties file not found in " + IdentityUtil.getIdentityConfigDirPath()));
            }
            isAskPasswordEnabled = false;
        }
        catch (IOException e) {
            log.error((Object)"Error while reading identity-mgt.properties file");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error occurred while closing the FileInputStream for identity-mgt.properties");
                }
            }
        }
    }
}

