/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.ui;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.user.store.count.stub.UserStoreCountServiceStub;
import org.wso2.carbon.identity.user.store.count.stub.UserStoreCountServiceUserStoreCounterException;
import org.wso2.carbon.identity.user.store.count.stub.dto.PairDTO;

public class UserStoreCountClient {
    protected UserStoreCountServiceStub stub = null;
    protected static final Log log = LogFactory.getLog(UserStoreCountClient.class);

    public UserStoreCountClient(String cookie, String url, String serviceName, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new UserStoreCountServiceStub(configContext, url + serviceName);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public UserStoreCountClient(String cookie, String url, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new UserStoreCountServiceStub(configContext, url + "UserStoreCountService");
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Map<String, String> countUsers(String filter) throws AxisFault {
        HashMap<String, String> counts = new HashMap();
        try {
            counts = this.convertArrayToMap(this.stub.countUsers(filter));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return counts;
    }

    public Map<String, String> countRoles(String filter) throws AxisFault {
        HashMap<String, String> counts = new HashMap();
        try {
            counts = this.convertArrayToMap(this.stub.countRoles(filter));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return counts;
    }

    public Map<String, String> countByClaim(String claimURI, String value) throws AxisFault {
        Map<String, String> counts = new HashMap<String, String>();
        try {
            counts = this.convertArrayToMap(this.stub.countClaim(claimURI, value));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return counts;
    }

    public Map<String, String> countByClaims(Map<String, String> claims) throws AxisFault {
        Map<String, String> counts = new HashMap<String, String>();
        try {
            counts = this.convertArrayToMap(this.stub.countClaims(this.convertMapToArray(claims)));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return counts;
    }

    public long countUsersInDomain(String filter, String domain) throws AxisFault {
        try {
            return this.stub.countUsersInDomain(filter, domain);
        }
        catch (Exception e) {
            this.handleException(e);
            return -1L;
        }
    }

    public long countRolesInDomain(String filter, String domain) throws AxisFault {
        try {
            return this.stub.countRolesInDomain(filter, domain);
        }
        catch (Exception e) {
            this.handleException(e);
            return -1L;
        }
    }

    public long countByClaimInDomain(String claimURI, String filter, String domain) throws AxisFault {
        try {
            return this.stub.countByClaimInDomain(claimURI, filter, domain);
        }
        catch (Exception e) {
            this.handleException(e);
            return -1L;
        }
    }

    public long countByClaimsInDomain(PairDTO[] pairDTOs, String domain) throws AxisFault {
        try {
            return this.stub.countByClaimsInDomain(pairDTOs, domain);
        }
        catch (Exception e) {
            this.handleException(e);
            return -1L;
        }
    }

    public Set<String> getCountableUserStores() throws AxisFault {
        try {
            if (this.stub.getCountEnabledUserStores() != null) {
                return new HashSet<String>(Arrays.asList(this.stub.getCountEnabledUserStores()));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return new HashSet<String>();
    }

    protected String[] handleException(Exception e) throws AxisFault {
        String errorMessage = "Unknown";
        if (e instanceof UserStoreCountServiceUserStoreCounterException) {
            UserStoreCountServiceUserStoreCounterException countException = (UserStoreCountServiceUserStoreCounterException)e;
            if (countException.getFaultMessage().getUserStoreCounterException() != null) {
                errorMessage = countException.getFaultMessage().getUserStoreCounterException().getMessage();
            }
        } else {
            errorMessage = e.getMessage();
        }
        log.error((Object)errorMessage, (Throwable)e);
        throw new AxisFault(errorMessage, (Throwable)e);
    }

    private Map<String, String> convertArrayToMap(PairDTO[] pairDTOs) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (pairDTOs != null) {
            for (PairDTO pairDTO : pairDTOs) {
                map.put(pairDTO.getKey(), pairDTO.getValue());
            }
        }
        return map;
    }

    private PairDTO[] convertMapToArray(Map<String, String> claims) {
        PairDTO[] pairs = new PairDTO[claims.size()];
        Iterator<Map.Entry<String, String>> iterator = claims.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            PairDTO pair = new PairDTO();
            pair.setKey(entry.getKey());
            pair.setValue(entry.getValue());
            pairs[i] = pair;
            ++i;
        }
        return pairs;
    }
}

