/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.wso2.carbon.user.mgt.ui.UserAdminUIConstants;

public class UserBean {
    private String domain = "";
    private String username = "";
    private String password = "";
    private String[] userRoles = new String[0];
    private String email = "";

    public String getUsername() {
        if (!this.username.contains(UserAdminUIConstants.DOMAIN_SEPARATOR) && this.domain != null && this.domain.trim().length() > 0) {
            return this.domain + UserAdminUIConstants.DOMAIN_SEPARATOR + this.username;
        }
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String[] getUserRoles() {
        return Arrays.copyOf(this.userRoles, this.userRoles.length);
    }

    public void setUserRoles(String[] userRoles) {
        this.userRoles = Arrays.copyOf(userRoles, userRoles.length);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        if (!"PRIMARY-DOMAIN [Domain name is not defined]".equalsIgnoreCase(domain)) {
            this.domain = domain;
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setClaimMapping() {
    }

    public void cleanup() {
        this.username = null;
        this.password = null;
        this.userRoles = null;
        this.email = null;
        this.domain = null;
    }

    public void addUserRoles(Map<String, Boolean> checkedRolesMap) {
        if (checkedRolesMap == null) {
            return;
        }
        ArrayList<String> userRolesList = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : checkedRolesMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            userRolesList.add(entry.getKey());
        }
        for (String role : this.userRoles) {
            if (userRolesList.contains(role)) continue;
            userRolesList.add(role);
        }
        this.userRoles = userRolesList.toArray(new String[userRolesList.size()]);
    }
}

