/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.wso2.carbon.user.mgt.ui.UserAdminUIConstants;

public class RoleBean {
    private String domain = "";
    private String roleName = "";
    private String sharedRole = "";
    private String[] roleUsers = new String[0];
    private String[] selectedPermissions = new String[0];
    private String[] shownUsers = new String[0];
    private String storeType = "";
    private String roleType = "";

    public String getStoreType() {
        return this.storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public String getRoleName() {
        if (!this.roleName.contains(UserAdminUIConstants.DOMAIN_SEPARATOR) && this.domain != null && this.domain.trim().length() > 0) {
            return this.domain + UserAdminUIConstants.DOMAIN_SEPARATOR + this.roleName;
        }
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getSharedRole() {
        return this.sharedRole;
    }

    public void setSharedRole(String sharedRole) {
        this.sharedRole = sharedRole;
    }

    public String[] getRoleUsers() {
        return Arrays.copyOf(this.roleUsers, this.roleUsers.length);
    }

    public void setRoleUsers(String[] selectedUsers) {
        this.roleUsers = Arrays.copyOf(selectedUsers, selectedUsers.length);
    }

    public String[] getSelectedPermissions() {
        return Arrays.copyOf(this.selectedPermissions, this.selectedPermissions.length);
    }

    public void setSelectedPermissions(String[] selectedPermissions) {
        this.selectedPermissions = Arrays.copyOf(selectedPermissions, selectedPermissions.length);
    }

    public String[] getShownUsers() {
        return Arrays.copyOf(this.shownUsers, this.shownUsers.length);
    }

    public void setShownUsers(String[] shownUsers) {
        this.shownUsers = Arrays.copyOf(shownUsers, shownUsers.length);
    }

    public void cleanup() {
        if (!"Internal".equalsIgnoreCase(this.domain)) {
            this.domain = "";
        }
        this.roleName = "";
        this.sharedRole = "";
        this.roleUsers = new String[0];
        this.selectedPermissions = new String[0];
        this.shownUsers = new String[0];
        this.storeType = "";
        this.roleType = "";
    }

    public String getRoleType() {
        return this.roleType;
    }

    public void setRoleType(String roleType) {
        this.roleType = roleType;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        if (!"PRIMARY-DOMAIN [Domain name is not defined]".equalsIgnoreCase(domain)) {
            this.domain = domain;
        }
    }

    public void addRoleUsers(Map<String, Boolean> checkedUsersMap) {
        if (checkedUsersMap == null) {
            return;
        }
        ArrayList<String> roleUsersList = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : checkedUsersMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            roleUsersList.add(entry.getKey());
        }
        for (String role : this.roleUsers) {
            if (roleUsersList.contains(role)) continue;
            roleUsersList.add(role);
        }
        this.roleUsers = roleUsersList.toArray(new String[roleUsersList.size()]);
    }
}

