/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.library.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalEntryUtil {
    private static Log log = LogFactory.getLog(LocalEntryUtil.class);

    public static OMElement getOMElement(File file) {
        FileInputStream is;
        OMElement document = null;
        try {
            is = FileUtils.openInputStream((File)file);
        }
        catch (IOException e) {
            log.error((Object)("Error while opening the file: " + file.getName() + " for reading"), (Throwable)e);
            return null;
        }
        try {
            document = new StAXOMBuilder((InputStream)is).getDocumentElement();
            document.build();
            is.close();
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while parsing the content of the file: " + file.getName()), (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)("Error while closing the input stream from the file: " + file.getName()), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Error while building the content of the file: " + file.getName()), (Throwable)e);
        }
        return document;
    }

    public static OMElement nonCoalescingStringToOm(String xmlStr) throws XMLStreamException {
        StringReader strReader = new StringReader(xmlStr);
        XMLInputFactory xmlInFac = XMLInputFactory.newInstance();
        xmlInFac.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader parser = xmlInFac.createXMLStreamReader(strReader);
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }
}

