/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.library.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.EntryFactory;
import org.apache.synapse.config.xml.SynapseImportFactory;
import org.apache.synapse.config.xml.SynapseImportSerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.util.LibDeployerUtils;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.mediation.library.service.LibraryArtifiactInfo;
import org.wso2.carbon.mediation.library.service.LibraryInfo;
import org.wso2.carbon.mediation.library.util.LocalEntryUtil;

public class MediationLibraryAdminService
extends AbstractServiceBusAdmin {
    private static Log log = LogFactory.getLog(MediationLibraryAdminService.class);
    public static final int MSGS_PER_PAGE = 10;
    public static final String SYNAPSE_CONFIGURATION = "SynapseConfiguration";

    private void addImport(String xml) throws AxisFault {
        try {
            OMElement imprtElem = this.createElement(xml);
            SynapseImport synapseImport = SynapseImportFactory.createImport((OMElement)imprtElem, null);
            if (synapseImport != null && synapseImport.getName() != null) {
                SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
                String fileName = ServiceBusUtils.generateFileName((String)synapseImport.getName());
                synapseImport.setFileName(fileName);
                synapseConfiguration.addSynapseImport(synapseImport.getName(), synapseImport);
                String synImportQualfiedName = LibDeployerUtils.getQualifiedName((SynapseImport)synapseImport);
                Library synLib = (Library)this.getSynapseConfiguration().getSynapseLibraries().get(synImportQualfiedName);
                if (synLib != null) {
                    synLib.getArtifacts().put(SYNAPSE_CONFIGURATION, synapseConfiguration);
                    LibDeployerUtils.loadLibArtifacts((SynapseImport)synapseImport, (Library)synLib);
                }
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager mp = this.getMediationPersistenceManager();
                    mp.saveItem(synapseImport.getName(), 14);
                }
            } else {
                String message = "Unable to create a Synapse Import for :  " + xml;
                this.handleException(log, message, null);
            }
        }
        catch (XMLStreamException e) {
            String message = "Unable to create a Synapse Import for :  " + xml;
            this.handleException(log, message, e);
        }
    }

    public void addImport(String libName, String packageName) throws AxisFault {
        SynapseImport synImport = new SynapseImport();
        synImport.setLibName(libName);
        synImport.setLibPackage(packageName);
        OMElement impEl = SynapseImportSerializer.serializeImport((SynapseImport)synImport);
        if (impEl != null) {
            try {
                this.addImport(impEl.toString());
            }
            catch (AxisFault axisFault) {
                this.handleException(log, "Could not add Synapse Import", (Exception)((Object)axisFault));
            }
        } else {
            this.handleException(log, "Could not add Synapse Import. Invalid import params for libName : " + libName + " packageName : " + packageName, null);
        }
    }

    public LibraryInfo getLibraryInfo(String libName, String packageName) throws AxisFault {
        SynapseImport synImport = new SynapseImport();
        synImport.setLibName(libName);
        synImport.setLibPackage(packageName);
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        OMElement impEl = SynapseImportSerializer.serializeImport((SynapseImport)synImport);
        if (impEl != null) {
            try {
                SynapseImport synapseImport = (SynapseImport)configuration.getSynapseImports().get("{" + packageName + "}" + libName);
                OMElement imprtElem = this.createElement(impEl.toString());
                if (synapseImport == null) {
                    synapseImport = SynapseImportFactory.createImport((OMElement)imprtElem, null);
                }
                if (synapseImport != null && synapseImport.getName() != null) {
                    String fileName = ServiceBusUtils.generateFileName((String)synapseImport.getName());
                    synapseImport.setFileName(fileName);
                    String synImportQualfiedName = LibDeployerUtils.getQualifiedName((SynapseImport)synapseImport);
                    Library synLib = (Library)this.getSynapseConfiguration().getSynapseLibraries().get(synImportQualfiedName);
                    if (synLib != null) {
                        LibraryInfo info = new LibraryInfo();
                        info.setLibName(libName);
                        info.setPackageName(packageName);
                        info.setDescription(synLib.getDescription());
                        info.setQName(synLib.getQName().toString());
                        info.setStatus(synLib.getLibStatus());
                        ArrayList<LibraryArtifiactInfo> artifactsList = new ArrayList<LibraryArtifiactInfo>();
                        for (Map.Entry entry : synLib.getLibArtifactDetails().entrySet()) {
                            if (entry.getValue() == null || entry.getKey() == null) continue;
                            LibraryArtifiactInfo artifactInfo = new LibraryArtifiactInfo();
                            artifactInfo.setName((String)entry.getKey());
                            artifactInfo.setDescription(synLib.getArtifactDescription((String)entry.getKey()));
                            artifactsList.add(artifactInfo);
                        }
                        LibraryArtifiactInfo[] artifacts = new LibraryArtifiactInfo[artifactsList.size()];
                        for (int i = 0; i < artifacts.length; ++i) {
                            artifacts[i] = (LibraryArtifiactInfo)artifactsList.get(i);
                        }
                        info.setArtifacts(artifacts);
                        return info;
                    }
                }
            }
            catch (XMLStreamException e) {
                String message = "Unable to create a Synapse Import for :  ";
                this.handleException(log, message, e);
            }
        }
        return null;
    }

    public String getImport(String qualifiedName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        SynapseImport synapseImport = (SynapseImport)configuration.getSynapseImports().get(qualifiedName);
        String xml = null;
        if (synapseImport != null) {
            xml = SynapseImportSerializer.serializeImport((SynapseImport)synapseImport).toString();
        } else {
            this.handleException(log, "Library Import " + synapseImport + " does not exist", null);
        }
        return xml;
    }

    public void deleteImport(String importQualifiedName) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        if (configuration.getSynapseImports().containsKey(importQualifiedName)) {
            SynapseImport synapseImport = configuration.removeSynapseImport(importQualifiedName);
            String fileName = synapseImport.getFileName();
            Library synLib = (Library)this.getSynapseConfiguration().getSynapseLibraries().get(importQualifiedName);
            if (synLib != null) {
                synLib.unLoadLibrary();
                this.undeployingLocalEntries(synLib, configuration);
            }
            if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                MediationPersistenceManager pm = this.getMediationPersistenceManager();
                pm.deleteItem(synapseImport.getName(), fileName, 14);
            }
        }
    }

    public void deleteLibrary(String libQualifiedName) throws Exception {
        if (libQualifiedName == null) {
            this.handleException(log, "Library name can't be null", null);
            return;
        }
        Library currentMediationLib = null;
        SynapseConfiguration synConfigForTenant = this.getSynapseConfiguration();
        if (synConfigForTenant != null) {
            Collection appList = synConfigForTenant.getSynapseLibraries().values();
            for (Library mediationLib : appList) {
                if (!libQualifiedName.equals(mediationLib.getQName().toString())) continue;
                currentMediationLib = mediationLib;
            }
            if (currentMediationLib == null) {
                this.handleException(log, "No Mediation Library found of the name : " + libQualifiedName, null);
                return;
            }
            this.deleteImport(libQualifiedName);
            String libFilePath = currentMediationLib.getFileName();
            File file = new File(libFilePath);
            if (file.exists() && !file.delete()) {
                log.error((Object)("Artifact file couldn't be deleted for Mediation Library : " + currentMediationLib.getQName().toString()));
            }
        }
    }

    public String[] getAllImports() throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        Set names = configuration.getSynapseImports().keySet();
        return names.toArray(new String[names.size()]);
    }

    public String[] getAllLibraries() throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        Set names = configuration.getSynapseLibraries().keySet();
        return names.toArray(new String[names.size()]);
    }

    public LibraryInfo[] getAllLibraryInfo() throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        ArrayList<LibraryInfo> librarySet = new ArrayList<LibraryInfo>();
        Collection libraries = configuration.getSynapseLibraries().values();
        for (Library library : libraries) {
            LibraryInfo libInfo = new LibraryInfo();
            libInfo.setLibName(library.getQName().getLocalPart());
            libInfo.setPackageName(library.getPackage());
            libInfo.setDescription(library.getDescription());
            libInfo.setQName(library.getQName().toString());
            libInfo.setStatus(library.getLibStatus());
            librarySet.add(libInfo);
        }
        return librarySet.toArray(new LibraryInfo[libraries.size()]);
    }

    private void handleException(Log log, String message, Exception e) throws AxisFault {
        if (e == null) {
            AxisFault exception = new AxisFault(message);
            log.error((Object)message, (Throwable)exception);
            throw exception;
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new AxisFault(message, (Throwable)e);
    }

    private OMElement createElement(String str) throws XMLStreamException {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        return new StAXOMBuilder((InputStream)in).getDocumentElement();
    }

    private static String getTenantIdString(AxisConfiguration axisConfig) {
        return String.valueOf(MediationLibraryAdminService.getTenantId(axisConfig));
    }

    private static int getTenantId(AxisConfiguration axisConfig) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        return carbonContext.getTenantId();
    }

    public DataHandler downloadLibraryArchive(String fileName) throws Exception {
        Library currentMediationLib = null;
        SynapseConfiguration synConfigForTenant = this.getSynapseConfiguration();
        Collection appList = synConfigForTenant.getSynapseLibraries().values();
        for (Library mediationLib : appList) {
            if (!fileName.equals(mediationLib.getQName().getLocalPart().toString())) continue;
            currentMediationLib = mediationLib;
        }
        FileDataSource datasource = new FileDataSource(new File(currentMediationLib.getFileName()));
        DataHandler handler = new DataHandler((DataSource)datasource);
        return handler;
    }

    public boolean updateStatus(String libQName, String libName, String packageName, String status) throws AxisFault {
        try {
            SynapseConfiguration configuration = this.getSynapseConfiguration();
            SynapseImport synapseImport = (SynapseImport)configuration.getSynapseImports().get(libQName);
            if (synapseImport == null && libName != null && packageName != null) {
                this.addImport(libName, packageName);
                synapseImport = (SynapseImport)configuration.getSynapseImports().get(libQName);
            }
            Library synLib = (Library)this.getSynapseConfiguration().getSynapseLibraries().get(libQName);
            if (libQName != null && synLib != null) {
                if ("enabled".equals(status)) {
                    synapseImport.setStatus(true);
                    synLib.setLibStatus(true);
                    synLib.getArtifacts().put(SYNAPSE_CONFIGURATION, configuration);
                    synLib.loadLibrary();
                    this.deployingLocalEntries(synLib, configuration);
                } else {
                    synapseImport.setStatus(false);
                    synLib.setLibStatus(false);
                    synLib.getArtifacts().put(SYNAPSE_CONFIGURATION, configuration);
                    synLib.unLoadLibrary();
                    this.undeployingLocalEntries(synLib, configuration);
                }
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager mp = this.getMediationPersistenceManager();
                    mp.saveItem(synapseImport.getName(), 14);
                }
            }
        }
        catch (Exception e) {
            String message = "Unable to update status for :  " + libQName;
            this.handleException(log, message, e);
        }
        return true;
    }

    private void deployingLocalEntries(Library library, SynapseConfiguration config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start : Adding Local registry entries to the configuration");
        }
        for (Map.Entry libararyEntryMap : library.getLocalEntryArtifacts().entrySet()) {
            File localEntryFileObj = (File)libararyEntryMap.getValue();
            OMElement document = LocalEntryUtil.getOMElement(localEntryFileObj);
            this.addEntry(document.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End : Adding Local registry entries to the configuration");
        }
    }

    private void undeployingLocalEntries(Library library, SynapseConfiguration config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start : Removing Local registry entries from the configuration");
        }
        for (Map.Entry libararyEntryMap : library.getLocalEntryArtifacts().entrySet()) {
            File localEntryFileObj = (File)libararyEntryMap.getValue();
            OMElement document = LocalEntryUtil.getOMElement(localEntryFileObj);
            this.deleteEntry(document.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End : Removing Local registry entries from the configuration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addEntry(String ele) {
        Lock lock = this.getLock();
        try {
            OMElement elem;
            lock.lock();
            try {
                elem = LocalEntryUtil.nonCoalescingStringToOm(ele);
            }
            catch (XMLStreamException e) {
                log.error((Object)("Error while converting the file content : " + e.getMessage()));
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            if (elem.getQName().getLocalPart().equals(XMLConfigConstants.ENTRY_ELT.getLocalPart())) {
                String entryKey = elem.getAttributeValue(new QName("key"));
                entryKey = entryKey.trim();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding local entry with key : " + entryKey));
                }
                if (this.getSynapseConfiguration().getLocalRegistry().containsKey(entryKey)) {
                    log.error((Object)("An Entry with key " + entryKey + " is already used within the configuration"));
                } else {
                    Entry entry = EntryFactory.createEntry((OMElement)elem, (Properties)this.getSynapseConfiguration().getProperties());
                    entry.setFileName(ServiceBusUtils.generateFileName((String)entry.getKey()));
                    this.getSynapseConfiguration().addEntry(entryKey, entry);
                    if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                        MediationPersistenceManager pm = ServiceBusUtils.getMediationPersistenceManager((AxisConfiguration)this.getAxisConfig());
                        pm.saveItem(entry.getKey(), 4);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Local registry entry : " + entryKey + " added to the configuration"));
                }
                boolean bl = true;
                return bl;
            }
            log.warn((Object)"Error adding local entry. Invalid definition");
        }
        catch (SynapseException syne) {
            log.error((Object)"Unable to add local entry ", (Throwable)syne);
        }
        catch (OMException e) {
            log.error((Object)"Unable to add local entry. Invalid XML ", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Unable to add local entry. Invalid XML ", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntry(String ele) {
        Lock lock = this.getLock();
        String entryKey = null;
        try {
            OMElement elem;
            lock.lock();
            try {
                elem = LocalEntryUtil.nonCoalescingStringToOm(ele);
            }
            catch (XMLStreamException e) {
                log.error((Object)("Error while converting the file content : " + e.getMessage()));
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            if (elem.getQName().getLocalPart().equals(XMLConfigConstants.ENTRY_ELT.getLocalPart())) {
                entryKey = elem.getAttributeValue(new QName("key"));
                entryKey = entryKey.trim();
                log.debug((Object)("Adding local entry with key : " + entryKey));
                SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
                Entry entry = (Entry)synapseConfiguration.getDefinedEntries().get(entryKey);
                if (entry != null) {
                    synapseConfiguration.removeEntry(entryKey);
                    if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                        MediationPersistenceManager pm = ServiceBusUtils.getMediationPersistenceManager((AxisConfiguration)this.getAxisConfig());
                        pm.deleteItem(entryKey, entry.getFileName(), 4);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deleted local entry with key : " + entryKey));
                    }
                    boolean bl = true;
                    return bl;
                }
                log.warn((Object)("No entry exists by the key : " + entryKey));
                boolean bl = false;
                return bl;
            }
        }
        catch (SynapseException syne) {
            log.error((Object)("Unable to delete the local entry : " + entryKey), (Throwable)syne);
        }
        catch (Exception e) {
            log.error((Object)("Unable to delete the local entry : " + entryKey), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return false;
    }
}

