/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.library;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.wso2.carbon.mediation.library.util.ConfigHolder;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class RegistryCachingHandler
extends Handler {
    public static final Log log = LogFactory.getLog(RegistryCachingHandler.class);
    public static final String GOV_REGISTRY_PATH = "/_system/governance";
    public static final String GOV_REGISTRY_PREFIX = "gov:";
    public static final String CONFIG_REGISTRY_PATH = "/_system/config";
    public static final String CONFIG_REGISTRY_PREFIX = "conf:";

    public void put(RequestContext requestContext) throws RegistryException {
        this.resolveRegistryPathAndClear(requestContext);
    }

    public String rename(RequestContext requestContext) throws RegistryException {
        this.resolveRegistryPathAndClear(requestContext);
        return requestContext.getTargetPath();
    }

    public String move(RequestContext requestContext) throws RegistryException {
        this.resolveRegistryPathAndClear(requestContext);
        return requestContext.getTargetPath();
    }

    public void delete(RequestContext requestContext) throws RegistryException {
        this.resolveRegistryPathAndClear(requestContext);
    }

    private void resolveRegistryPathAndClear(RequestContext requestContext) {
        String resourcePath = requestContext.getResourcePath().getPath();
        ConfigHolder configHolder = ConfigHolder.getInstance();
        if (configHolder.isSynapseConfigurationInitialized()) {
            try {
                SynapseConfiguration synapseConfiguration = configHolder.getSynapseConfiguration();
                if (!resourcePath.isEmpty()) {
                    List mounts = requestContext.getRegistry().getRegistryContext().getMounts();
                    for (Mount mount : mounts) {
                        if (!resourcePath.startsWith(mount.getTargetPath())) continue;
                        if (mount.getPath().contains(CONFIG_REGISTRY_PATH)) {
                            String key = CONFIG_REGISTRY_PREFIX + resourcePath.substring(mount.getTargetPath().length());
                            Object entry = synapseConfiguration.getEntry(key);
                            if (entry == null) break;
                            this.removeEntry(synapseConfiguration, key);
                            break;
                        }
                        if (mount.getPath().contains(GOV_REGISTRY_PATH)) {
                            String key = GOV_REGISTRY_PREFIX + resourcePath.substring(mount.getTargetPath().length());
                            Object entry = synapseConfiguration.getEntry(key);
                            if (entry == null) break;
                            this.removeEntry(synapseConfiguration, key);
                            break;
                        }
                        log.warn((Object)("Given path is invalid to clear Synapse cache " + resourcePath));
                    }
                    if (mounts.size() == 0) {
                        Object entry;
                        String key = "";
                        if (resourcePath.startsWith(CONFIG_REGISTRY_PATH)) {
                            key = CONFIG_REGISTRY_PREFIX + resourcePath.substring(CONFIG_REGISTRY_PATH.length());
                            entry = synapseConfiguration.getEntry(key);
                            if (entry != null) {
                                this.removeEntry(synapseConfiguration, key);
                            }
                        } else if (resourcePath.startsWith(GOV_REGISTRY_PATH)) {
                            key = GOV_REGISTRY_PREFIX + resourcePath.substring(GOV_REGISTRY_PATH.length());
                            entry = synapseConfiguration.getEntry(key);
                            if (entry != null) {
                                this.removeEntry(synapseConfiguration, key);
                            }
                        } else {
                            log.warn((Object)("Given path is invalid to clear Synapse cache " + resourcePath));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while loading synapse configurations for clear cache in " + resourcePath), (Throwable)e);
            }
        }
    }

    private void removeEntry(SynapseConfiguration synapseConfiguration, String key) {
        Entry entry = synapseConfiguration.getEntryDefinition(key);
        if (entry != null && entry.isCached()) {
            synapseConfiguration.removeEntry(key);
        }
    }
}

