/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.library;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.deployers.ImportDeployer;
import org.apache.synapse.deployers.LibraryArtifactDeployer;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.mediation.library.service.LibraryDeployerService;
import org.wso2.carbon.mediation.library.service.LibraryDeployerServiceImpl;
import org.wso2.carbon.mediation.library.util.ConfigHolder;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.mediation.library.service", immediate=true)
public class MediationLibraryServiceComponent
extends AbstractAxis2ConfigurationContextObserver {
    private static Log log = LogFactory.getLog(MediationLibraryServiceComponent.class);
    private boolean activated = false;

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            BundleContext bndCtx = ctxt.getBundleContext();
            bndCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)this, null);
            bndCtx.registerService(LibraryDeployerService.class.getName(), (Object)new LibraryDeployerServiceImpl(), null);
            SynapseEnvironmentService synEnvService = ConfigHolder.getInstance().getSynapseEnvironmentService(-1234);
            this.registerDeployer(ConfigHolder.getInstance().getAxisConfiguration(), synEnvService.getSynapseEnvironment());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Message Store Admin bundle is activated for Super tenant");
            }
            this.activated = true;
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Message Store Admin bundle for Super tenant ", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        try {
            Set<Map.Entry<Integer, SynapseEnvironmentService>> entrySet = ConfigHolder.getInstance().getSynapseEnvironmentServices().entrySet();
            for (Map.Entry<Integer, SynapseEnvironmentService> entry : entrySet) {
                this.unregisterDeployer(entry.getValue().getConfigurationContext().getAxisConfiguration(), entry.getValue().getSynapseEnvironment());
            }
        }
        catch (Exception e) {
            log.warn((Object)"Couldn't remove the Message Store Deployer");
        }
    }

    @Reference(name="configuration.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(cfgCtxService.getServerConfigContext().getAxisConfiguration());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(null);
    }

    @Reference(name="synapse.config.service", service=SynapseConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseConfigurationService")
    protected void setSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(synapseConfigurationService.getSynapseConfiguration());
    }

    protected void unsetSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(null);
    }

    @Reference(name="synapse.env.service", service=SynapseEnvironmentService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseEnvironmentService")
    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        boolean alreadyCreated = ConfigHolder.getInstance().getSynapseEnvironmentServices().containsKey(synapseEnvironmentService.getTenantId());
        ConfigHolder.getInstance().addSynapseEnvironmentService(synapseEnvironmentService.getTenantId(), synapseEnvironmentService);
        if (this.activated && !alreadyCreated) {
            try {
                this.registerDeployer(synapseEnvironmentService.getConfigurationContext().getAxisConfiguration(), synapseEnvironmentService.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Mediation Library Admin bundle is activated for tenant");
                }
            }
            catch (Throwable e) {
                log.error((Object)"Failed to activate Mediation Library Admin bundle for tenant ", e);
            }
        }
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        ConfigHolder.getInstance().removeSynapseEnvironmentService(synapseEnvironmentService.getTenantId());
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the ESB initialization process");
        }
        try {
            ConfigHolder.getInstance().setRegistry(regService.getConfigSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)"Couldn't retrieve the registry from the registry service");
        }
    }

    @Reference(name="synapse.registrations.service", service=SynapseRegistrationsService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseRegistrationsService")
    protected void setSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
    }

    protected void unsetSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
        int tenantId = synapseRegistrationsService.getTenantId();
        if (ConfigHolder.getInstance().getSynapseEnvironmentServices().containsKey(tenantId)) {
            SynapseEnvironment env = ConfigHolder.getInstance().getSynapseEnvironmentService(tenantId).getSynapseEnvironment();
            ConfigHolder.getInstance().removeSynapseEnvironmentService(synapseRegistrationsService.getTenantId());
            AxisConfiguration axisConfig = synapseRegistrationsService.getConfigurationContext().getAxisConfiguration();
            if (axisConfig != null) {
                this.unregisterDeployer(axisConfig, env);
            }
        }
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the ESB environment");
        }
        ConfigHolder.getInstance().setRegistry(null);
    }

    @Reference(name="dependency.mgt.service", service=DependencyManagementService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetDependencyManager")
    protected void setDependencyManager(DependencyManagementService dependencyMgr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Dependency management service bound to the endpoint component");
        }
        ConfigHolder.getInstance().setDependencyManager(dependencyMgr);
    }

    protected void unsetDependencyManager(DependencyManagementService dependencyMgr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Dependency management service unbound from the endpoint component");
        }
        ConfigHolder.getInstance().setDependencyManager(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) {
        SynapseConfiguration synCfg = synapseEnvironment.getSynapseConfiguration();
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        SynapseArtifactDeploymentStore deploymentStore = synCfg.getArtifactDeploymentStore();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
        String synapseImportDir = synapseConfigPath + File.separator + "imports";
        for (SynapseImport synImport : synCfg.getSynapseImports().values()) {
            if (synImport.getFileName() == null) continue;
            deploymentStore.addRestoredArtifact(synapseImportDir + File.separator + synImport.getFileName());
        }
        AxisConfiguration axisConfiguration = axisConfig;
        synchronized (axisConfiguration) {
            deploymentEngine.addDeployer((Deployer)new ImportDeployer(), synapseImportDir, "xml");
        }
        String carbonRepoPath = axisConfig.getRepository().getPath();
        String libsPath = carbonRepoPath + File.separator + "synapse-libs";
        AxisConfiguration axisConfiguration2 = axisConfig;
        synchronized (axisConfiguration2) {
            deploymentEngine.addDeployer((Deployer)new LibraryArtifactDeployer(), libsPath, "zip");
        }
    }

    private void unregisterDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) {
        if (axisConfig != null) {
            DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
            String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
            String importDirPath = synapseConfigPath + File.separator + "imports";
            deploymentEngine.removeDeployer(importDirPath, "xml");
            String carbonRepoPath = axisConfig.getRepository().getPath();
            String libsPath = carbonRepoPath + File.separator + "synapse-libs";
            deploymentEngine.removeDeployer(libsPath, "zip");
        }
    }

    public void createdConfigurationContext(ConfigurationContext configContext) {
        SynapseEnvironmentService synEnvService;
        AxisConfiguration axisConfig = configContext.getAxisConfiguration();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (axisConfig != null && (synEnvService = ConfigHolder.getInstance().getSynapseEnvironmentService(tenantId)) != null) {
            try {
                this.registerDeployer(axisConfig, synEnvService.getSynapseEnvironment());
            }
            catch (Exception e) {
                log.error((Object)"Error while initializing MediationLibrary Admin", (Throwable)e);
            }
        }
    }
}

