/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Stack;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.stream.StreamHostObject;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class WebSocketHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(WebSocketHostObject.class);
    private static final String hostObjectName = "WebSocket";
    private ContextFactory contextFactory;
    private Session session;
    private Function textCallback = null;
    private Function onOpencallback = null;
    private Function onCloseCallback = null;
    private Function binaryCallback = null;
    private JaggeryContext asyncContext;

    public String getClassName() {
        return hostObjectName;
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)hostObjectName, (int)argsCount, (boolean)true);
        }
        WebSocketHostObject who = new WebSocketHostObject();
        who.contextFactory = cx.getFactory();
        JaggeryContext currentContext = (JaggeryContext)RhinoEngine.getContextProperty((Object)"engine.jaggeryContext");
        JaggeryContext asyncContext = new JaggeryContext();
        asyncContext.setEngine(currentContext.getEngine());
        asyncContext.setScope(currentContext.getScope());
        asyncContext.setTenantId(currentContext.getTenantId());
        asyncContext.addProperty("jaggery.servlet.context", currentContext.getProperty("jaggery.servlet.context"));
        asyncContext.addProperty("hostobject.log.loglevel", currentContext.getProperty("hostobject.log.loglevel"));
        asyncContext.addProperty("hostobjects.file.filemanager", currentContext.getProperty("hostobjects.file.filemanager"));
        asyncContext.addProperty("jaggery.core.manager", currentContext.getProperty("jaggery.core.manager"));
        asyncContext.addProperty("jaggery.included.scripts", new HashMap());
        asyncContext.addProperty("jaggery.includes.callstack", new Stack());
        asyncContext.addProperty("jaggery.required.modules", new HashMap());
        who.asyncContext = asyncContext;
        return who;
    }

    public void jsSet_ontext(Object outPutMessage) throws ScriptException {
        if (!(outPutMessage instanceof Function)) {
            HostObjectUtil.invalidProperty((String)hostObjectName, (String)"ontext", (String)"function", (Object)outPutMessage);
        }
        this.textCallback = (Function)outPutMessage;
    }

    public Scriptable jsGet_ontext() {
        return this.textCallback;
    }

    public void jsSet_onopen(Object openFunction) throws ScriptException {
        if (!(openFunction instanceof Function)) {
            HostObjectUtil.invalidProperty((String)hostObjectName, (String)"onopen", (String)"function", (Object)openFunction);
        }
        this.onOpencallback = (Function)openFunction;
    }

    public Scriptable jsGet_onopen() {
        return this.onOpencallback;
    }

    public void jsSet_onclose(Object closeFunction) throws ScriptException {
        if (!(closeFunction instanceof Function)) {
            HostObjectUtil.invalidProperty((String)hostObjectName, (String)"onclose", (String)"function", (Object)closeFunction);
        }
        this.onCloseCallback = (Function)closeFunction;
    }

    public Scriptable jsGet_onclose() {
        return this.onCloseCallback;
    }

    public void jsSet_onbinary(Object outPutMessage) throws ScriptException {
        if (!(outPutMessage instanceof Function)) {
            HostObjectUtil.invalidProperty((String)hostObjectName, (String)"onbinary", (String)"function", (Object)outPutMessage);
        }
        this.binaryCallback = (Function)outPutMessage;
    }

    public Scriptable jsGet_onbinary() {
        return this.binaryCallback;
    }

    public static void jsFunction_send(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "send";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String) && !(args[1] instanceof StreamHostObject)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string | Stream", (Object)args[0], (boolean)false);
        }
        WebSocketHostObject who = (WebSocketHostObject)thisObj;
        RemoteEndpoint.Basic remoteEndpoint = who.session.getBasicRemote();
        Object result = args[0];
        try {
            if (result instanceof String) {
                remoteEndpoint.sendText((String)result);
            } else if (result instanceof ByteBuffer) {
                remoteEndpoint.sendBinary((ByteBuffer)result);
            } else if (result instanceof byte[]) {
                remoteEndpoint.sendBinary(ByteBuffer.wrap((byte[])result));
            } else {
                remoteEndpoint.sendObject(result);
            }
        }
        catch (IOException | EncodeException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public static void jsFunction_close(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "close";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        WebSocketHostObject who = (WebSocketHostObject)thisObj;
        try {
            who.session.close();
        }
        catch (IOException e) {
            log.error((Object)"Unable to close the websocket connection. ", (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public void processText(String msg) {
        if (this.textCallback == null) {
            return;
        }
        Context cx = RhinoEngine.enterContext((ContextFactory)this.contextFactory);
        RhinoEngine.putContextProperty((Object)"engine.jaggeryContext", (Object)this.asyncContext);
        this.textCallback.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{msg});
        RhinoEngine.exitContext();
    }

    public void processOnOpen() {
        if (this.onOpencallback == null) {
            return;
        }
        Context cx = RhinoEngine.enterContext((ContextFactory)this.contextFactory);
        RhinoEngine.putContextProperty((Object)"engine.jaggeryContext", (Object)this.asyncContext);
        this.onOpencallback.call(cx, (Scriptable)this, (Scriptable)this, new Object[0]);
        RhinoEngine.exitContext();
    }

    public void processOnClose(int status) {
        if (this.onCloseCallback == null) {
            return;
        }
        Context cx = RhinoEngine.enterContext((ContextFactory)this.contextFactory);
        RhinoEngine.putContextProperty((Object)"engine.jaggeryContext", (Object)this.asyncContext);
        this.onCloseCallback.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{status});
        RhinoEngine.exitContext();
    }

    public void processBinary(ByteBuffer byteBuffer) {
        if (this.binaryCallback == null) {
            return;
        }
        Context cx = RhinoEngine.enterContext((ContextFactory)this.contextFactory);
        RhinoEngine.putContextProperty((Object)"engine.jaggeryContext", (Object)this.asyncContext);
        ByteArrayInputStream bis = new ByteArrayInputStream(byteBuffer.array());
        StreamHostObject sho = (StreamHostObject)cx.newObject((Scriptable)this, "Stream", new Object[]{bis});
        this.binaryCallback.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{sho});
        RhinoEngine.exitContext();
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

