/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RequestHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(RequestHostObject.class);
    private static final String hostObjectName = "Request";
    private HttpServletRequest request;
    private boolean isMultipart = false;
    private Map<String, ArrayList<FileItem>> parameterMap = new HashMap<String, ArrayList<FileItem>>();
    private Scriptable parameters = null;
    private Scriptable files = null;
    private Scriptable cookies = null;
    private Scriptable locales = null;
    private Object content = null;
    private Context context;

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)hostObjectName, (int)argsCount, (boolean)true);
        }
        if (!(args[0] instanceof HttpServletRequest)) {
            HostObjectUtil.getReservedHostObjectWarn((String)hostObjectName);
        }
        RequestHostObject rho = new RequestHostObject();
        rho.request = (HttpServletRequest)args[0];
        rho.isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)rho.request);
        rho.context = cx;
        return rho;
    }

    public String getClassName() {
        return hostObjectName;
    }

    public static Object jsFunction_getContent(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getContent";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        try {
            if (rho.content != null) {
                return rho.content;
            }
            String data = HostObjectUtil.streamToString((InputStream)rho.request.getInputStream());
            String contentType = rho.request.getContentType();
            rho.content = contentType != null ? ((contentType = contentType.trim().toLowerCase()).startsWith("application/json") || contentType.startsWith("application/json/badgerfish") ? (data != null && !"".equals(data) ? HostObjectUtil.parseJSON((Context)cx, (Scriptable)thisObj, (String)data) : null) : data) : data;
            return rho.content;
        }
        catch (IOException e) {
            String msg = "Error occurred while reading Servlet InputStream";
            log.warn((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    public static Object jsFunction_getStream(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getStream";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        try {
            return cx.newObject(thisObj, "Stream", new Object[]{rho.request.getInputStream()});
        }
        catch (IOException e) {
            String msg = "Error occurred while reading Servlet InputStream";
            log.warn((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    public static InputStream jsFunction_getInputStream(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getInputStream";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        try {
            return rho.request.getInputStream();
        }
        catch (IOException e) {
            String msg = "Error occurred while reading Servlet InputStream";
            log.warn((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    public static String jsFunction_getMethod(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getMethod";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getMethod();
    }

    public static String jsFunction_getUser(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getUser";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        Principal principle = rho.request.getUserPrincipal();
        if (principle == null) {
            return null;
        }
        return principle.getName();
    }

    public static String jsFunction_getContextPath(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getContextPath";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getContextPath();
    }

    public static String jsFunction_getPathTranslated(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getPathTranslated";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getPathTranslated();
    }

    public static String jsFunction_getProtocol(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getProtocol";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getProtocol();
    }

    public static String jsFunction_getQueryString(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getQueryString";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getQueryString();
    }

    public static String jsFunction_getContentType(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getContentType";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getContentType();
    }

    public static int jsFunction_getContentLength(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getContentLength";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getContentLength();
    }

    public static Scriptable jsFunction_getAllParameters(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getAllParameters";
        int argsCount = args.length;
        if (argsCount > 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        if (!rho.isMultipart) {
            RequestHostObject.parseParameters(rho);
            return rho.parameters;
        }
        String encoding = null;
        if (argsCount == 1) {
            if (!(args[0] instanceof String)) {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
            }
            encoding = (String)args[0];
        }
        RequestHostObject.parseMultipart(rho);
        RequestHostObject.parseMultipartParams(rho, encoding == null ? "UTF-8" : encoding, cx, thisObj);
        return rho.parameters;
    }

    public static Scriptable jsFunction_getAllFiles(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getAllFiles";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        if (!rho.isMultipart) {
            return null;
        }
        RequestHostObject.parseMultipart(rho);
        return rho.files;
    }

    public static String jsFunction_getRequestURI(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getRequestURI";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getRequestURI();
    }

    public static String jsFunction_getRequestURL(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getRequestURL";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        String strURL = rho.request.getRequestURL().toString();
        return strURL;
    }

    public static boolean jsFunction_isSecure(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "isSecure";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.isSecure();
    }

    public static String jsFunction_getHeader(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getHeader";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getHeader((String)args[0]);
    }

    public static Scriptable jsFunction_getAllHeaders(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getAllHeaders";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        Enumeration names = rho.request.getHeaderNames();
        Scriptable headers = cx.newObject(thisObj);
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            headers.put(name, headers, (Object)rho.request.getHeader(name));
        }
        return headers;
    }

    public static String jsFunction_getRemoteAddr(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getRemoteAddr";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getRemoteAddr();
    }

    public static String jsFunction_getLocale(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getLocale";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getLocale().getLanguage();
    }

    public static Scriptable jsFunction_getAllLocales(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getAllLocales";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        Enumeration locales = rho.request.getLocales();
        Scriptable localesOut = cx.newObject(thisObj);
        while (locales.hasMoreElements()) {
            Locale localname = (Locale)locales.nextElement();
            localesOut.put(localname.getLanguage(), localesOut, (Object)rho.request.getLocales());
        }
        return localesOut;
    }

    public static int jsFunction_getLocalPort(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getLocalPort";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getLocalPort();
    }

    public static Object jsFunction_getParameter(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getParameter";
        int argsCount = args.length;
        if (argsCount != 1 && argsCount != 2) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if (argsCount == 2 && !(args[1] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"string", (Object)args[1], (boolean)false);
        }
        String parameter = (String)args[0];
        RequestHostObject rho = (RequestHostObject)thisObj;
        if (!rho.isMultipart) {
            return RequestHostObject.getParameter(parameter, rho.request, (Scriptable)rho);
        }
        RequestHostObject.parseMultipart(rho);
        if (rho.parameterMap.get(parameter) == null) {
            return null;
        }
        FileItem item = rho.parameterMap.get(parameter).get(0);
        if (argsCount == 1) {
            return item.getString();
        }
        try {
            return item.getString((String)args[1]);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public static Scriptable jsFunction_getFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getFile";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        if (!rho.isMultipart) {
            return null;
        }
        RequestHostObject.parseMultipart(rho);
        Object obj = rho.files.get((String)args[0], thisObj);
        if (obj instanceof Scriptable) {
            return (Scriptable)obj;
        }
        return null;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    private static void parseMultipart(RequestHostObject rho) throws ScriptException {
        if (rho.files != null) {
            return;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List items = null;
        try {
            items = upload.parseRequest(rho.request);
        }
        catch (FileUploadException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)((Object)e));
        }
        rho.files = rho.context.newObject((Scriptable)rho);
        for (Object obj : items) {
            FileItem item = (FileItem)obj;
            String name = item.getFieldName();
            if (item.isFormField()) {
                ArrayList<FileItem> x = rho.parameterMap.get(name);
                if (x == null) {
                    ArrayList<FileItem> array = new ArrayList<FileItem>(1);
                    array.add(item);
                    rho.parameterMap.put(name, array);
                    continue;
                }
                x.add(item);
                continue;
            }
            rho.files.put(item.getFieldName(), rho.files, (Object)rho.context.newObject((Scriptable)rho, "File", new Object[]{item}));
        }
    }

    private static void parseMultipartParams(RequestHostObject rho, String encoding, Context cx, Scriptable scope) throws ScriptException {
        if (rho.parameters != null) {
            return;
        }
        rho.parameters = rho.context.newObject((Scriptable)rho);
        for (String name : rho.parameterMap.keySet()) {
            try {
                ArrayList<FileItem> x = rho.parameterMap.get(name);
                if (x.size() > 1) {
                    Scriptable y = cx.newArray(scope, x.size());
                    for (int i = 0; i < x.size(); ++i) {
                        y.put(i, y, (Object)x.get(i).getString(encoding));
                    }
                    rho.parameters.put(name, rho.parameters, (Object)y);
                    continue;
                }
                rho.parameters.put(name, rho.parameters, (Object)x.get(0).getString(encoding));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
        }
    }

    private static void parseParameters(RequestHostObject rho) {
        if (rho.parameters != null) {
            return;
        }
        rho.parameters = rho.context.newObject((Scriptable)rho);
        Enumeration params = rho.request.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            rho.parameters.put(name, rho.parameters, RequestHostObject.getParameter(name, rho.request, (Scriptable)rho));
        }
    }

    public static Scriptable jsFunction_getCookie(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getCookie";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        if (rho.cookies == null) {
            rho.cookies = rho.context.newObject((Scriptable)rho);
            RequestHostObject.parseCookies(cx, thisObj, rho);
        }
        if (rho.cookies.get((String)args[0], rho.cookies) != NOT_FOUND) {
            return (Scriptable)rho.cookies.get((String)args[0], rho.cookies);
        }
        return null;
    }

    public static Scriptable jsFunction_getAllCookies(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getAllCookies";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        if (rho.cookies == null) {
            rho.cookies = cx.newObject((Scriptable)rho);
            RequestHostObject.parseCookies(cx, thisObj, rho);
        }
        return rho.cookies;
    }

    public static String jsFunction_getMappedPath(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getMappedPath";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        JaggeryContext context = (JaggeryContext)RhinoEngine.getContextProperty((Object)"engine.jaggeryContext");
        Stack stack = (Stack)context.getProperty("jaggery.includes.callstack");
        String path = (String)stack.firstElement();
        if (rho.request.getRequestURI().equals(path)) {
            return null;
        }
        return path;
    }

    public static Object jsFunction_getAttribute(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getAttribute";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getAttribute((String)args[0]);
    }

    private static void parseCookies(Context cx, Scriptable thisObj, RequestHostObject rho) {
        if (rho.request.getCookies() != null) {
            for (Cookie cookie : rho.request.getCookies()) {
                Scriptable o = cx.newObject(thisObj);
                o.put("name", o, (Object)cookie.getName());
                o.put("value", o, (Object)cookie.getValue());
                o.put("comment", o, (Object)cookie.getComment());
                o.put("domain", o, (Object)cookie.getDomain());
                o.put("maxAge", o, (Object)cookie.getMaxAge());
                o.put("path", o, (Object)cookie.getPath());
                o.put("secure", o, (Object)cookie.getSecure());
                o.put("version", o, (Object)cookie.getVersion());
                rho.cookies.put(cookie.getName(), rho.cookies, (Object)o);
            }
        }
    }

    private static Object getParameter(String name, HttpServletRequest request, Scriptable scope) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        return Context.javaToJS((Object)values, (Scriptable)scope);
    }

    public static Scriptable jsFunction_getSession(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getSession";
        int argsCount = args.length;
        RequestHostObject rho = (RequestHostObject)thisObj;
        if (0 == argsCount) {
            HttpSession sessionObj = rho.request.getSession();
        } else {
            if (1 != argsCount && !(args[0] instanceof Boolean)) {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"boolean", (Object)args[0], (boolean)false);
            }
            Boolean parameter = (Boolean)args[0];
            HttpSession sessionObj = rho.request.getSession(parameter.booleanValue());
        }
        return cx.newObject(thisObj.getParentScope(), "Session", new Object[]{rho.request});
    }
}

