/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.InterfaceTypeDefinition;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.TypeResolver;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLInterfaceType
implements GraphQLType,
GraphQLOutputType,
GraphQLFieldsContainer,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Map<String, GraphQLFieldDefinition> fieldDefinitionsByName = new LinkedHashMap<String, GraphQLFieldDefinition>();
    private final TypeResolver typeResolver;
    private final InterfaceTypeDefinition definition;
    private final List<GraphQLDirective> directives;

    @Internal
    @Deprecated
    public GraphQLInterfaceType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, TypeResolver typeResolver) {
        this(name, description, fieldDefinitions, typeResolver, Collections.emptyList(), null);
    }

    @Internal
    @Deprecated
    public GraphQLInterfaceType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, TypeResolver typeResolver, List<GraphQLDirective> directives, InterfaceTypeDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(fieldDefinitions, "fieldDefinitions can't null", new Object[0]);
        Assert.assertNotNull(directives, "directives cannot be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.typeResolver = typeResolver;
        this.definition = definition;
        this.directives = directives;
        this.buildDefinitionMap(fieldDefinitions);
    }

    private void buildDefinitionMap(List<GraphQLFieldDefinition> fieldDefinitions) {
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            String name = fieldDefinition.getName();
            if (this.fieldDefinitionsByName.containsKey(name)) {
                throw new AssertException(String.format("Duplicated definition for field '%s' in interface '%s'", name, this.name));
            }
            this.fieldDefinitionsByName.put(name, fieldDefinition);
        }
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition(String name) {
        return this.fieldDefinitionsByName.get(name);
    }

    @Override
    public List<GraphQLFieldDefinition> getFieldDefinitions() {
        return new ArrayList<GraphQLFieldDefinition>(this.fieldDefinitionsByName.values());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public InterfaceTypeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public String toString() {
        return "GraphQLInterfaceType{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", fieldDefinitionsByName=" + this.fieldDefinitionsByName.keySet() + ", typeResolver=" + this.typeResolver + '}';
    }

    public GraphQLInterfaceType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLInterfaceType.newInterface(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLType> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLInterfaceType(this, context);
    }

    @Override
    public List<GraphQLType> getChildren() {
        ArrayList<GraphQLType> children = new ArrayList<GraphQLType>(this.fieldDefinitionsByName.values());
        children.addAll(this.directives);
        return children;
    }

    public static Builder newInterface() {
        return new Builder();
    }

    public static Builder newInterface(GraphQLInterfaceType existing) {
        return new Builder(existing);
    }

    @PublicApi
    public static class Builder
    extends GraphqlTypeBuilder {
        private TypeResolver typeResolver;
        private InterfaceTypeDefinition definition;
        private final Map<String, GraphQLFieldDefinition> fields = new LinkedHashMap<String, GraphQLFieldDefinition>();
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLInterfaceType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.typeResolver = existing.getTypeResolver();
            this.definition = existing.getDefinition();
            this.fields.putAll(FpKit.getByName(existing.getFieldDefinitions(), GraphQLFieldDefinition::getName));
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder description(String description) {
            super.description(description);
            return this;
        }

        @Override
        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            super.comparatorRegistry(comparatorRegistry);
            return this;
        }

        public Builder definition(InterfaceTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder field(GraphQLFieldDefinition fieldDefinition) {
            Assert.assertNotNull(fieldDefinition, "fieldDefinition can't be null", new Object[0]);
            this.fields.put(fieldDefinition.getName(), fieldDefinition);
            return this;
        }

        public Builder field(UnaryOperator<GraphQLFieldDefinition.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, "builderFunction can't be null", new Object[0]);
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            builder = (GraphQLFieldDefinition.Builder)builderFunction.apply(builder);
            return this.field(builder);
        }

        public Builder field(GraphQLFieldDefinition.Builder builder) {
            return this.field(builder.build());
        }

        public Builder fields(List<GraphQLFieldDefinition> fieldDefinitions) {
            Assert.assertNotNull(fieldDefinitions, "fieldDefinitions can't be null", new Object[0]);
            fieldDefinitions.forEach(this::field);
            return this;
        }

        public boolean hasField(String fieldName) {
            return this.fields.containsKey(fieldName);
        }

        public Builder clearFields() {
            this.fields.clear();
            return this;
        }

        @Deprecated
        public Builder typeResolver(TypeResolver typeResolver) {
            this.typeResolver = typeResolver;
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, "directive can't be null", new Object[0]);
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLInterfaceType build() {
            return new GraphQLInterfaceType(this.name, this.description, this.sort(this.fields, GraphQLInterfaceType.class, GraphQLFieldDefinition.class), this.typeResolver, this.sort(this.directives, GraphQLInterfaceType.class, GraphQLDirective.class), this.definition);
        }
    }
}

