/*
 * Decompiled with CFR 0.152.
 */
package graphql.relay;

import graphql.Assert;
import graphql.PublicApi;
import graphql.relay.Connection;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import java.util.Collections;
import java.util.List;

@PublicApi
public class DefaultConnection<T>
implements Connection<T> {
    private final List<Edge<T>> edges;
    private final PageInfo pageInfo;

    public DefaultConnection(List<Edge<T>> edges, PageInfo pageInfo) {
        this.edges = Collections.unmodifiableList(Assert.assertNotNull(edges, "edges cannot be null", new Object[0]));
        this.pageInfo = Assert.assertNotNull(pageInfo, "page info cannot be null", new Object[0]);
    }

    @Override
    public List<Edge<T>> getEdges() {
        return this.edges;
    }

    @Override
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public String toString() {
        return "DefaultConnection{edges=" + this.edges + ", pageInfo=" + this.pageInfo + '}';
    }
}

