/*
 * Decompiled with CFR 0.152.
 */
package graphql.nextgen;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.Internal;
import graphql.ParseResult;
import graphql.execution.AbortExecutionException;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.instrumentation.DocumentAndVariables;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.nextgen.Instrumentation;
import graphql.execution.instrumentation.nextgen.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.nextgen.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.nextgen.InstrumentationValidationParameters;
import graphql.execution.nextgen.DefaultExecutionStrategy;
import graphql.execution.nextgen.Execution;
import graphql.execution.nextgen.ExecutionStrategy;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.language.Document;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import graphql.validation.Validator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class GraphQL {
    private static final Logger log = LoggerFactory.getLogger(graphql.GraphQL.class);
    private final GraphQLSchema graphQLSchema;
    private final ExecutionStrategy executionStrategy;
    private final ExecutionIdProvider idProvider;
    private final Instrumentation instrumentation;
    private final PreparsedDocumentProvider preparsedDocumentProvider;

    public GraphQL(Builder builder) {
        this.graphQLSchema = builder.graphQLSchema;
        this.executionStrategy = builder.executionStrategy;
        this.idProvider = builder.idProvider;
        this.preparsedDocumentProvider = builder.preparsedDocumentProvider;
        this.instrumentation = builder.instrumentation;
    }

    public ExecutionResult execute(ExecutionInput.Builder executionInputBuilder) {
        return this.executeAsync(executionInputBuilder.build()).join();
    }

    public CompletableFuture<ExecutionResult> execute(UnaryOperator<ExecutionInput.Builder> builderFunction) {
        return this.executeAsync(((ExecutionInput.Builder)builderFunction.apply(ExecutionInput.newExecutionInput())).build());
    }

    public ExecutionResult execute(ExecutionInput executionInput) {
        return this.executeAsync(executionInput).join();
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput.Builder executionInputBuilder) {
        return this.executeAsync(executionInputBuilder.build());
    }

    public CompletableFuture<ExecutionResult> executeAsync(UnaryOperator<ExecutionInput.Builder> builderFunction) {
        return this.executeAsync(((ExecutionInput.Builder)builderFunction.apply(ExecutionInput.newExecutionInput())).build());
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput executionInput) {
        try {
            log.debug("Executing request. operation name: '{}'. query: '{}'. variables '{}'", new Object[]{executionInput.getOperationName(), executionInput.getQuery(), executionInput.getVariables()});
            InstrumentationState instrumentationState = this.instrumentation.createState(new InstrumentationCreateStateParameters(this.graphQLSchema, executionInput));
            InstrumentationExecutionParameters inputInstrumentationParameters = new InstrumentationExecutionParameters(executionInput, this.graphQLSchema, instrumentationState);
            executionInput = this.instrumentation.instrumentExecutionInput(executionInput, inputInstrumentationParameters);
            InstrumentationExecutionParameters instrumentationParameters = new InstrumentationExecutionParameters(executionInput, this.graphQLSchema, instrumentationState);
            InstrumentationContext<ExecutionResult> executionInstrumentation = this.instrumentation.beginExecution(instrumentationParameters);
            GraphQLSchema graphQLSchema = this.instrumentation.instrumentSchema(this.graphQLSchema, instrumentationParameters);
            CompletionStage<ExecutionResult> executionResult = this.parseValidateAndExecute(executionInput, graphQLSchema, instrumentationState);
            executionResult = ((CompletableFuture)executionResult).whenComplete(executionInstrumentation::onCompleted);
            executionResult = ((CompletableFuture)executionResult).thenApply(result -> this.instrumentation.instrumentExecutionResult((ExecutionResult)result, instrumentationParameters));
            return executionResult;
        }
        catch (AbortExecutionException abortException) {
            return CompletableFuture.completedFuture(abortException.toExecutionResult());
        }
    }

    private CompletableFuture<ExecutionResult> parseValidateAndExecute(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        AtomicReference<ExecutionInput> executionInputRef = new AtomicReference<ExecutionInput>(executionInput);
        Function<ExecutionInput, PreparsedDocumentEntry> computeFunction = transformedInput -> {
            executionInputRef.set((ExecutionInput)transformedInput);
            return this.parseAndValidate((ExecutionInput)executionInputRef.get(), graphQLSchema, instrumentationState);
        };
        PreparsedDocumentEntry preparsedDoc = this.preparsedDocumentProvider.getDocument(executionInput, computeFunction);
        if (preparsedDoc.hasErrors()) {
            return CompletableFuture.completedFuture(new ExecutionResultImpl(preparsedDoc.getErrors()));
        }
        return this.execute(executionInputRef.get(), preparsedDoc.getDocument(), graphQLSchema, instrumentationState);
    }

    private PreparsedDocumentEntry parseAndValidate(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        log.debug("Parsing query: '{}'...", (Object)executionInput.getQuery());
        ParseResult parseResult = this.parse(executionInput, graphQLSchema, instrumentationState);
        if (parseResult.isFailure()) {
            log.warn("Query failed to parse : '{}'", (Object)executionInput.getQuery());
            return new PreparsedDocumentEntry(parseResult.getException().toInvalidSyntaxError());
        }
        Document document = parseResult.getDocument();
        log.debug("Validating query: '{}'", (Object)executionInput.getQuery());
        List<ValidationError> errors = this.validate(executionInput, document, graphQLSchema, instrumentationState);
        if (!errors.isEmpty()) {
            log.warn("Query failed to validate : '{}'", (Object)executionInput.getQuery());
            return new PreparsedDocumentEntry(errors);
        }
        return new PreparsedDocumentEntry(document);
    }

    private ParseResult parse(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        DocumentAndVariables documentAndVariables;
        InstrumentationExecutionParameters parameters = new InstrumentationExecutionParameters(executionInput, graphQLSchema, instrumentationState);
        InstrumentationContext<Document> parseInstrumentation = this.instrumentation.beginParse(parameters);
        Parser parser = new Parser();
        try {
            Document document = parser.parseDocument(executionInput.getQuery());
            documentAndVariables = DocumentAndVariables.newDocumentAndVariables().document(document).variables(executionInput.getVariables()).build();
            documentAndVariables = this.instrumentation.instrumentDocumentAndVariables(documentAndVariables, parameters);
        }
        catch (InvalidSyntaxException e) {
            parseInstrumentation.onCompleted(null, e);
            return ParseResult.ofError(e);
        }
        parseInstrumentation.onCompleted(documentAndVariables.getDocument(), null);
        return ParseResult.of(documentAndVariables);
    }

    private List<ValidationError> validate(ExecutionInput executionInput, Document document, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        InstrumentationContext<List<ValidationError>> validationCtx = this.instrumentation.beginValidation(new InstrumentationValidationParameters(executionInput, document, graphQLSchema, instrumentationState));
        Validator validator = new Validator();
        List<ValidationError> validationErrors = validator.validateDocument(graphQLSchema, document);
        validationCtx.onCompleted(validationErrors, null);
        return validationErrors;
    }

    private CompletableFuture<ExecutionResult> execute(ExecutionInput executionInput, Document document, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        String query = executionInput.getQuery();
        String operationName = executionInput.getOperationName();
        Object context = executionInput.getContext();
        Execution execution = new Execution();
        ExecutionId executionId = this.idProvider.provide(query, operationName, context);
        log.debug("Executing '{}'. operation name: '{}'. query: '{}'. variables '{}'", new Object[]{executionId, executionInput.getOperationName(), executionInput.getQuery(), executionInput.getVariables()});
        CompletionStage<ExecutionResult> future = execution.execute(this.executionStrategy, document, graphQLSchema, executionId, executionInput, instrumentationState);
        future = future.whenComplete((result, throwable) -> {
            if (throwable != null) {
                log.error(String.format("Execution '%s' threw exception when executing : query : '%s'. variables '%s'", executionId, executionInput.getQuery(), executionInput.getVariables()), throwable);
            } else {
                int errorCount = result.getErrors().size();
                if (errorCount > 0) {
                    log.debug("Execution '{}' completed with '{}' errors", (Object)executionId, (Object)errorCount);
                } else {
                    log.debug("Execution '{}' completed with zero errors", (Object)executionId);
                }
            }
        });
        return future;
    }

    public static Builder newGraphQL(GraphQLSchema graphQLSchema) {
        return new Builder(graphQLSchema);
    }

    public GraphQL transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static class Builder {
        private GraphQLSchema graphQLSchema;
        private ExecutionStrategy executionStrategy = new DefaultExecutionStrategy();
        private ExecutionIdProvider idProvider = ExecutionIdProvider.DEFAULT_EXECUTION_ID_PROVIDER;
        private Instrumentation instrumentation = new Instrumentation(this){
            final /* synthetic */ Builder this$0;
            {
                this.this$0 = this$0;
            }
        };
        private PreparsedDocumentProvider preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;

        public Builder(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = graphQLSchema;
        }

        public Builder(GraphQL graphQL) {
            this.graphQLSchema = graphQL.graphQLSchema;
            this.executionStrategy = graphQL.executionStrategy;
            this.idProvider = graphQL.idProvider;
            this.instrumentation = graphQL.instrumentation;
        }

        public Builder schema(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = Assert.assertNotNull(graphQLSchema, "GraphQLSchema must be non null", new Object[0]);
            return this;
        }

        public Builder executionStrategy(ExecutionStrategy executionStrategy) {
            this.executionStrategy = Assert.assertNotNull(executionStrategy, "ExecutionStrategy must be non null", new Object[0]);
            return this;
        }

        public Builder instrumentation(Instrumentation instrumentation) {
            this.instrumentation = Assert.assertNotNull(instrumentation, "Instrumentation must be non null", new Object[0]);
            return this;
        }

        public Builder preparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
            this.preparsedDocumentProvider = Assert.assertNotNull(preparsedDocumentProvider, "PreparsedDocumentProvider must be non null", new Object[0]);
            return this;
        }

        public Builder executionIdProvider(ExecutionIdProvider executionIdProvider) {
            this.idProvider = Assert.assertNotNull(executionIdProvider, "ExecutionIdProvider must be non null", new Object[0]);
            return this;
        }

        public GraphQL build() {
            Assert.assertNotNull(this.graphQLSchema, "graphQLSchema must be non null", new Object[0]);
            return new GraphQL(this);
        }
    }
}

