/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.reactive;

import graphql.execution.reactive.DelegatingSubscription;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class CompletionStageMappingPublisher<D, U>
implements Publisher<D> {
    private final Publisher<U> upstreamPublisher;
    private final Function<U, CompletionStage<D>> mapper;

    public CompletionStageMappingPublisher(Publisher<U> upstreamPublisher, Function<U, CompletionStage<D>> mapper) {
        this.upstreamPublisher = upstreamPublisher;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(final Subscriber<? super D> downstreamSubscriber) {
        this.upstreamPublisher.subscribe(new Subscriber<U>(){
            Subscription delegatingSubscription;

            @Override
            public void onSubscribe(Subscription subscription) {
                this.delegatingSubscription = new DelegatingSubscription(subscription);
                downstreamSubscriber.onSubscribe(this.delegatingSubscription);
            }

            @Override
            public void onNext(U u) {
                try {
                    CompletionStage completionStage = (CompletionStage)CompletionStageMappingPublisher.this.mapper.apply(u);
                    completionStage.whenComplete((d, throwable) -> {
                        if (throwable != null) {
                            this.handleThrowable((Throwable)throwable);
                        } else {
                            downstreamSubscriber.onNext(d);
                        }
                    });
                }
                catch (RuntimeException throwable2) {
                    this.handleThrowable(throwable2);
                }
            }

            private void handleThrowable(Throwable throwable) {
                downstreamSubscriber.onError(throwable);
                this.delegatingSubscription.cancel();
            }

            @Override
            public void onError(Throwable t) {
                downstreamSubscriber.onError(t);
            }

            @Override
            public void onComplete() {
                downstreamSubscriber.onComplete();
            }
        });
    }
}

