/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.GraphQLException;
import graphql.PublicApi;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;

@PublicApi
public class UnresolvedTypeException
extends GraphQLException {
    private final GraphQLOutputType interfaceOrUnionType;

    public UnresolvedTypeException(String message, GraphQLOutputType interfaceOrUnionType) {
        super(message);
        this.interfaceOrUnionType = interfaceOrUnionType;
    }

    public UnresolvedTypeException(GraphQLOutputType interfaceOrUnionType) {
        this("Could not determine the exact type of '" + interfaceOrUnionType.getName() + "'", interfaceOrUnionType);
    }

    public UnresolvedTypeException(GraphQLOutputType interfaceOrUnionType, GraphQLType providedType) {
        this("Runtime Object type '" + providedType.getName() + "' is not a possible type for '" + interfaceOrUnionType.getName() + "'.", interfaceOrUnionType);
    }

    public GraphQLOutputType getInterfaceOrUnionType() {
        return this.interfaceOrUnionType;
    }
}

