/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.PublicSpi;
import graphql.SerializationError;
import graphql.TrivialDataFetcher;
import graphql.TypeMismatchError;
import graphql.UnresolvedTypeError;
import graphql.execution.AbortExecutionException;
import graphql.execution.AbsoluteGraphQLError;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStepInfoFactory;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FetchedValue;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResolveType;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.UnboxPossibleOptional;
import graphql.execution.UnresolvedTypeException;
import graphql.execution.ValuesResolver;
import graphql.execution.directives.QueryDirectivesImpl;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.DataFetchingFieldSelectionSetImpl;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicSpi
public abstract class ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExecutionStrategy.class);
    protected final ValuesResolver valuesResolver = new ValuesResolver();
    protected final FieldCollector fieldCollector = new FieldCollector();
    private final ExecutionStepInfoFactory executionStepInfoFactory = new ExecutionStepInfoFactory();
    private final ResolveType resolvedType = new ResolveType();
    protected final DataFetcherExceptionHandler dataFetcherExceptionHandler;

    protected ExecutionStrategy() {
        this.dataFetcherExceptionHandler = new SimpleDataFetcherExceptionHandler();
    }

    protected ExecutionStrategy(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        this.dataFetcherExceptionHandler = dataFetcherExceptionHandler;
    }

    public abstract CompletableFuture<ExecutionResult> execute(ExecutionContext var1, ExecutionStrategyParameters var2) throws NonNullableFieldWasNullException;

    protected CompletableFuture<ExecutionResult> resolveField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        return this.resolveFieldWithInfo(executionContext, parameters).thenCompose(FieldValueInfo::getFieldValue);
    }

    protected CompletableFuture<FieldValueInfo> resolveFieldWithInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext, parameters, parameters.getField().getSingleField());
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<ExecutionResult> fieldCtx = instrumentation.beginField(new InstrumentationFieldParameters(executionContext, fieldDef, this.createExecutionStepInfo(executionContext, parameters, fieldDef, null)));
        CompletableFuture<FetchedValue> fetchFieldFuture = this.fetchField(executionContext, parameters);
        CompletionStage result = fetchFieldFuture.thenApply(fetchedValue -> this.completeField(executionContext, parameters, (FetchedValue)fetchedValue));
        CompletionStage executionResultFuture = ((CompletableFuture)result).thenCompose(FieldValueInfo::getFieldValue);
        fieldCtx.onDispatched((CompletableFuture<ExecutionResult>)executionResultFuture);
        ((CompletableFuture)executionResultFuture).whenComplete(fieldCtx::onCompleted);
        return result;
    }

    protected CompletableFuture<FieldValueInfo> resolveFieldWithInfoToNull(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        FetchedValue fetchedValue = FetchedValue.newFetchedValue().build();
        FieldValueInfo fieldValueInfo = this.completeField(executionContext, parameters, fetchedValue);
        return CompletableFuture.completedFuture(fieldValueInfo);
    }

    protected CompletableFuture<FetchedValue> fetchField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        CompletableFuture<Object> fetchedValue;
        MergedField field = parameters.getField();
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field.getSingleField());
        GraphQLCodeRegistry codeRegistry = executionContext.getGraphQLSchema().getCodeRegistry();
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(codeRegistry, fieldDef.getArguments(), field.getArguments(), executionContext.getVariables());
        QueryDirectivesImpl queryDirectives = new QueryDirectivesImpl(field, executionContext.getGraphQLSchema(), executionContext.getVariables());
        GraphQLOutputType fieldType = fieldDef.getType();
        DataFetchingFieldSelectionSet fieldCollector = DataFetchingFieldSelectionSetImpl.newCollector(executionContext, fieldType, parameters.getField());
        ExecutionStepInfo executionStepInfo = this.createExecutionStepInfo(executionContext, parameters, fieldDef, parentType);
        DataFetchingEnvironment environment = DataFetchingEnvironmentImpl.newDataFetchingEnvironment(executionContext).source(parameters.getSource()).localContext(parameters.getLocalContext()).arguments(argumentValues).fieldDefinition(fieldDef).mergedField(parameters.getField()).fieldType(fieldType).executionStepInfo(executionStepInfo).parentType(parentType).selectionSet(fieldCollector).queryDirectives(queryDirectives).build();
        DataFetcher<?> dataFetcher = codeRegistry.getDataFetcher(parentType, fieldDef);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldFetchParameters instrumentationFieldFetchParams = new InstrumentationFieldFetchParameters(executionContext, fieldDef, environment, parameters, dataFetcher instanceof TrivialDataFetcher);
        InstrumentationContext<Object> fetchCtx = instrumentation.beginFieldFetch(instrumentationFieldFetchParams);
        dataFetcher = instrumentation.instrumentDataFetcher(dataFetcher, instrumentationFieldFetchParams);
        ExecutionId executionId = executionContext.getExecutionId();
        try {
            log.debug("'{}' fetching field '{}' using data fetcher '{}'...", new Object[]{executionId, executionStepInfo.getPath(), dataFetcher.getClass().getName()});
            Object fetchedValueRaw = dataFetcher.get(environment);
            log.debug("'{}' field '{}' fetch returned '{}'", new Object[]{executionId, executionStepInfo.getPath(), fetchedValueRaw == null ? "null" : fetchedValueRaw.getClass().getName()});
            fetchedValue = Async.toCompletableFuture(fetchedValueRaw);
        }
        catch (Exception e) {
            log.debug(String.format("'%s', field '%s' fetch threw exception", executionId, executionStepInfo.getPath()), (Throwable)e);
            fetchedValue = new CompletableFuture();
            fetchedValue.completeExceptionally(e);
        }
        fetchCtx.onDispatched(fetchedValue);
        return ((CompletableFuture)fetchedValue.handle((result, exception) -> {
            fetchCtx.onCompleted(result, (Throwable)exception);
            if (exception != null) {
                this.handleFetchingException(executionContext, parameters, environment, (Throwable)exception);
                return null;
            }
            return result;
        })).thenApply(result -> this.unboxPossibleDataFetcherResult(executionContext, parameters, result));
    }

    FetchedValue unboxPossibleDataFetcherResult(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        if (result instanceof DataFetcherResult) {
            DataFetcherResult dataFetcherResult = (DataFetcherResult)result;
            if (dataFetcherResult.isMapRelativeErrors()) {
                dataFetcherResult.getErrors().stream().map(relError -> new AbsoluteGraphQLError(parameters, (GraphQLError)relError)).forEach(executionContext::addError);
            } else {
                dataFetcherResult.getErrors().forEach(executionContext::addError);
            }
            Object localContext = dataFetcherResult.getLocalContext();
            if (localContext == null) {
                localContext = parameters.getLocalContext();
            }
            return FetchedValue.newFetchedValue().fetchedValue(UnboxPossibleOptional.unboxPossibleOptional(dataFetcherResult.getData())).rawFetchedValue(dataFetcherResult.getData()).errors(dataFetcherResult.getErrors()).localContext(localContext).build();
        }
        return FetchedValue.newFetchedValue().fetchedValue(UnboxPossibleOptional.unboxPossibleOptional(result)).rawFetchedValue(result).localContext(parameters.getLocalContext()).build();
    }

    private void handleFetchingException(ExecutionContext executionContext, ExecutionStrategyParameters parameters, DataFetchingEnvironment environment, Throwable e) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(environment).exception(e).build();
        DataFetcherExceptionHandlerResult handlerResult = this.dataFetcherExceptionHandler.onException(handlerParameters);
        handlerResult.getErrors().forEach(executionContext::addError);
        parameters.deferredErrorSupport().onFetchingException(parameters, e);
    }

    protected FieldValueInfo completeField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, FetchedValue fetchedValue) {
        Field field = parameters.getField().getSingleField();
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
        ExecutionStepInfo executionStepInfo = this.createExecutionStepInfo(executionContext, parameters, fieldDef, parentType);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, fieldDef, executionStepInfo, fetchedValue);
        InstrumentationContext<ExecutionResult> ctxCompleteField = instrumentation.beginFieldComplete(instrumentationParams);
        GraphQLCodeRegistry codeRegistry = executionContext.getGraphQLSchema().getCodeRegistry();
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(codeRegistry, fieldDef.getArguments(), field.getArguments(), executionContext.getVariables());
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, executionStepInfo);
        ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(executionStepInfo).arguments(argumentValues).source(fetchedValue.getFetchedValue()).localContext(fetchedValue.getLocalContext()).nonNullFieldValidator(nonNullableFieldValidator));
        log.debug("'{}' completing field '{}'...", (Object)executionContext.getExecutionId(), (Object)executionStepInfo.getPath());
        FieldValueInfo fieldValueInfo = this.completeValue(executionContext, newParameters);
        CompletableFuture<ExecutionResult> executionResultFuture = fieldValueInfo.getFieldValue();
        ctxCompleteField.onDispatched(executionResultFuture);
        executionResultFuture.whenComplete(ctxCompleteField::onCompleted);
        return fieldValueInfo;
    }

    protected FieldValueInfo completeValue(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        CompletableFuture<ExecutionResult> fieldValue;
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        Object result = UnboxPossibleOptional.unboxPossibleOptional(parameters.getSource());
        GraphQLOutputType fieldType = executionStepInfo.getUnwrappedNonNullType();
        if (result == null) {
            CompletableFuture<ExecutionResult> fieldValue2 = this.completeValueForNull(parameters);
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.NULL).fieldValue(fieldValue2).build();
        }
        if (GraphQLTypeUtil.isList(fieldType)) {
            return this.completeValueForList(executionContext, parameters, result);
        }
        if (fieldType instanceof GraphQLScalarType) {
            CompletableFuture<ExecutionResult> fieldValue3 = this.completeValueForScalar(executionContext, parameters, (GraphQLScalarType)fieldType, result);
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.SCALAR).fieldValue(fieldValue3).build();
        }
        if (fieldType instanceof GraphQLEnumType) {
            CompletableFuture<ExecutionResult> fieldValue4 = this.completeValueForEnum(executionContext, parameters, (GraphQLEnumType)fieldType, result);
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.ENUM).fieldValue(fieldValue4).build();
        }
        try {
            GraphQLObjectType resolvedObjectType = this.resolveType(executionContext, parameters, fieldType);
            fieldValue = this.completeValueForObject(executionContext, parameters, resolvedObjectType, result);
        }
        catch (UnresolvedTypeException ex) {
            this.handleUnresolvedTypeProblem(executionContext, parameters, ex);
            parameters.getNonNullFieldValidator().validate(parameters.getPath(), null);
            fieldValue = CompletableFuture.completedFuture(new ExecutionResultImpl(null, null));
        }
        return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.OBJECT).fieldValue(fieldValue).build();
    }

    private void handleUnresolvedTypeProblem(ExecutionContext context, ExecutionStrategyParameters parameters, UnresolvedTypeException e) {
        UnresolvedTypeError error = new UnresolvedTypeError(parameters.getPath(), parameters.getExecutionStepInfo(), e);
        log.warn(error.getMessage(), (Throwable)e);
        context.addError(error);
        parameters.deferredErrorSupport().onError(error);
    }

    private CompletableFuture<ExecutionResult> completeValueForNull(ExecutionStrategyParameters parameters) {
        return Async.tryCatch(() -> {
            Object nullValue = parameters.getNonNullFieldValidator().validate(parameters.getPath(), null);
            return CompletableFuture.completedFuture(new ExecutionResultImpl(nullValue, null));
        });
    }

    protected FieldValueInfo completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        Iterable<Object> resultIterable = this.toIterable(executionContext, parameters, result);
        try {
            resultIterable = parameters.getNonNullFieldValidator().validate(parameters.getPath(), resultIterable);
        }
        catch (NonNullableFieldWasNullException e) {
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(Async.exceptionallyCompletedFuture(e)).build();
        }
        if (resultIterable == null) {
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(CompletableFuture.completedFuture(new ExecutionResultImpl(null, null))).build();
        }
        return this.completeValueForList(executionContext, parameters, resultIterable);
    }

    protected FieldValueInfo completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Iterable<Object> iterableValues) {
        Collection values = FpKit.toCollection(iterableValues);
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        GraphQLFieldDefinition fieldDef = parameters.getExecutionStepInfo().getFieldDefinition();
        GraphQLObjectType fieldContainer = parameters.getExecutionStepInfo().getFieldContainer();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, fieldDef, this.createExecutionStepInfo(executionContext, parameters, fieldDef, fieldContainer), values);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<ExecutionResult> completeListCtx = instrumentation.beginFieldListComplete(instrumentationParams);
        ArrayList<FieldValueInfo> fieldValueInfos = new ArrayList<FieldValueInfo>();
        int index = 0;
        for (Object item2 : values) {
            ExecutionPath indexedPath = parameters.getPath().segment(index);
            ExecutionStepInfo stepInfoForListElement = this.executionStepInfoFactory.newExecutionStepInfoForListElement(executionStepInfo, index);
            NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, stepInfoForListElement);
            int finalIndex = index++;
            FetchedValue value = this.unboxPossibleDataFetcherResult(executionContext, parameters, item2);
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(stepInfoForListElement).nonNullFieldValidator(nonNullableFieldValidator).listSize(values.size()).localContext(value.getLocalContext()).currentListIndex(finalIndex).path(indexedPath).source(value.getFetchedValue()));
            fieldValueInfos.add(this.completeValue(executionContext, newParameters));
        }
        CompletableFuture resultsFuture = Async.each(fieldValueInfos, (item, i) -> item.getFieldValue());
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        completeListCtx.onDispatched(overallResult);
        resultsFuture.whenComplete((results, exception) -> {
            if (exception != null) {
                ExecutionResult executionResult = this.handleNonNullException(executionContext, overallResult, (Throwable)exception);
                completeListCtx.onCompleted(executionResult, (Throwable)exception);
                return;
            }
            ArrayList completedResults = new ArrayList();
            for (ExecutionResult completedValue : results) {
                completedResults.add(completedValue.getData());
            }
            ExecutionResultImpl executionResult = new ExecutionResultImpl(completedResults, null);
            overallResult.complete(executionResult);
        });
        overallResult.whenComplete(completeListCtx::onCompleted);
        return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(overallResult).fieldValueInfos(fieldValueInfos).build();
    }

    protected CompletableFuture<ExecutionResult> completeValueForScalar(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLScalarType scalarType, Object result) {
        Object serialized;
        try {
            serialized = scalarType.getCoercing().serialize(result);
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        if (serialized instanceof Double && ((Double)serialized).isNaN()) {
            serialized = null;
        }
        try {
            serialized = parameters.getNonNullFieldValidator().validate(parameters.getPath(), serialized);
        }
        catch (NonNullableFieldWasNullException e) {
            return Async.exceptionallyCompletedFuture(e);
        }
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, null));
    }

    protected CompletableFuture<ExecutionResult> completeValueForEnum(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLEnumType enumType, Object result) {
        Object serialized;
        try {
            serialized = enumType.getCoercing().serialize(result);
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        try {
            serialized = parameters.getNonNullFieldValidator().validate(parameters.getPath(), serialized);
        }
        catch (NonNullableFieldWasNullException e) {
            return Async.exceptionallyCompletedFuture(e);
        }
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, null));
    }

    protected CompletableFuture<ExecutionResult> completeValueForObject(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLObjectType resolvedObjectType, Object result) {
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(resolvedObjectType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getVariables()).build();
        MergedSelectionSet subFields = this.fieldCollector.collectFields(collectorParameters, parameters.getField());
        ExecutionStepInfo newExecutionStepInfo = executionStepInfo.changeTypeWithPreservedNonNull(resolvedObjectType);
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, newExecutionStepInfo);
        ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(newExecutionStepInfo).fields(subFields).nonNullFieldValidator(nonNullableFieldValidator).source(result));
        return executionContext.getQueryStrategy().execute(executionContext, newParameters);
    }

    private Object handleCoercionProblem(ExecutionContext context, ExecutionStrategyParameters parameters, CoercingSerializeException e) {
        SerializationError error = new SerializationError(parameters.getPath(), e);
        log.warn(error.getMessage(), (Throwable)e);
        context.addError(error);
        parameters.deferredErrorSupport().onError(error);
        return null;
    }

    protected Iterable<Object> toIterable(Object result) {
        return FpKit.toCollection(result);
    }

    protected GraphQLObjectType resolveType(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLType fieldType) {
        return this.resolvedType.resolveType(executionContext, parameters.getField(), parameters.getSource(), parameters.getArguments(), fieldType);
    }

    protected Iterable<Object> toIterable(ExecutionContext context, ExecutionStrategyParameters parameters, Object result) {
        if (result.getClass().isArray() || result instanceof Iterable) {
            return this.toIterable(result);
        }
        this.handleTypeMismatchProblem(context, parameters, result);
        return null;
    }

    private void handleTypeMismatchProblem(ExecutionContext context, ExecutionStrategyParameters parameters, Object result) {
        TypeMismatchError error = new TypeMismatchError(parameters.getPath(), parameters.getExecutionStepInfo().getUnwrappedNonNullType());
        log.warn("{} got {}", (Object)error.getMessage(), result.getClass());
        context.addError(error);
        parameters.deferredErrorSupport().onError(error);
    }

    protected GraphQLFieldDefinition getFieldDef(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Field field) {
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        return this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
    }

    protected GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLObjectType parentType, Field field) {
        return Introspection.getFieldDef(schema, parentType, field.getName());
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e) throws NonNullableFieldWasNullException {
        ExecutionStepInfo executionStepInfo = e.getExecutionStepInfo();
        if (executionStepInfo.hasParent() && executionStepInfo.getParent().isNonNullType()) {
            throw new NonNullableFieldWasNullException(e);
        }
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e, CompletableFuture<?> completableFuture) throws NonNullableFieldWasNullException {
        ExecutionStepInfo executionStepInfo = e.getExecutionStepInfo();
        if (executionStepInfo.hasParent() && executionStepInfo.getParent().isNonNullType()) {
            completableFuture.completeExceptionally(new NonNullableFieldWasNullException(e));
        }
    }

    protected ExecutionResult handleNonNullException(ExecutionContext executionContext, CompletableFuture<ExecutionResult> result, Throwable e) {
        ExecutionResult executionResult = null;
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>(executionContext.getErrors());
        Throwable underlyingException = e;
        if (e instanceof CompletionException) {
            underlyingException = e.getCause();
        }
        if (underlyingException instanceof NonNullableFieldWasNullException) {
            this.assertNonNullFieldPrecondition((NonNullableFieldWasNullException)underlyingException, result);
            if (!result.isDone()) {
                executionResult = new ExecutionResultImpl(null, errors);
                result.complete(executionResult);
            }
        } else if (underlyingException instanceof AbortExecutionException) {
            AbortExecutionException abortException = (AbortExecutionException)underlyingException;
            executionResult = abortException.toExecutionResult();
            result.complete(executionResult);
        } else {
            result.completeExceptionally(e);
        }
        return executionResult;
    }

    protected ExecutionStepInfo createExecutionStepInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLFieldDefinition fieldDefinition, GraphQLObjectType fieldContainer) {
        GraphQLOutputType fieldType = fieldDefinition.getType();
        MergedField field = parameters.getField();
        List<Argument> fieldArgs = field.getArguments();
        GraphQLCodeRegistry codeRegistry = executionContext.getGraphQLSchema().getCodeRegistry();
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(codeRegistry, fieldDefinition.getArguments(), fieldArgs, executionContext.getVariables());
        return ExecutionStepInfo.newExecutionStepInfo().type(fieldType).fieldDefinition(fieldDefinition).fieldContainer(fieldContainer).field(field).path(parameters.getPath()).parentInfo(parameters.getExecutionStepInfo()).arguments(argumentValues).build();
    }

    @Internal
    public static String mkNameForPath(Field currentField) {
        return ExecutionStrategy.mkNameForPath(Collections.singletonList(currentField));
    }

    @Internal
    public static String mkNameForPath(MergedField mergedField) {
        return ExecutionStrategy.mkNameForPath(mergedField.getFields());
    }

    @Internal
    public static String mkNameForPath(List<Field> currentField) {
        Field field = currentField.get(0);
        return field.getAlias() != null ? field.getAlias() : field.getName();
    }
}

