/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.hybrid;

import com.google.step2.hybrid.HybridOauthMessage;
import java.util.Arrays;
import java.util.List;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;

public class HybridOauthRequest
extends HybridOauthMessage {
    static final String CONSUMER_KEY = "consumer";
    protected static final List<String> requiredFields = Arrays.asList("consumer");
    protected static final List<String> optionalFields = Arrays.asList("scope");

    HybridOauthRequest(ParameterList parameters) throws MessageException {
        this.parameters = parameters;
        if (!this.isValid()) {
            throw new MessageException("Invalid parameters for Oauth fetch");
        }
    }

    public HybridOauthRequest(String consumerKey, String scope) {
        if (consumerKey == null || consumerKey.trim().length() == 0) {
            throw new IllegalArgumentException("consumer key is required");
        }
        this.parameters.set(new Parameter(CONSUMER_KEY, consumerKey));
        if (scope != null && scope.trim().length() > 0) {
            this.parameters.set(new Parameter("scope", scope));
        }
    }

    boolean isValid() {
        return this.isValid(requiredFields, optionalFields);
    }

    public String getConsumerKey() {
        return this.parameters.getParameterValue(CONSUMER_KEY);
    }
}

