/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.http;

import com.google.step2.http.FetchException;
import com.google.step2.http.FetchRequest;
import com.google.step2.http.FetchResponse;
import com.google.step2.http.HttpFetcher;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;

public class DefaultHttpFetcher
implements HttpFetcher {
    private final DefaultHttpClient httpClient;

    public DefaultHttpFetcher() {
        DefaultHttpClient httpClientTmp = new DefaultHttpClient();
        ClientConnectionManager mgr = httpClientTmp.getConnectionManager();
        HttpParams params = httpClientTmp.getParams();
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(params, mgr.getSchemeRegistry()), params);
        this.httpClient.setRoutePlanner((HttpRoutePlanner)new ProxySelectorRoutePlanner(this.httpClient.getConnectionManager().getSchemeRegistry(), null));
    }

    @Override
    public FetchResponse fetch(FetchRequest request) throws FetchException {
        HttpGet uriRequest;
        switch (request.getMethod()) {
            case GET: {
                uriRequest = new HttpGet(request.getUri());
                break;
            }
            case POST: {
                uriRequest = new HttpPost(request.getUri());
                break;
            }
            case HEAD: {
                uriRequest = new HttpHead(request.getUri());
                break;
            }
            default: {
                throw new FetchException("unsupported HTTP method: " + (Object)((Object)request.getMethod()));
            }
        }
        try {
            return new DefaultFetchResponse(this.httpClient.execute((HttpUriRequest)uriRequest));
        }
        catch (ClientProtocolException e) {
            throw new FetchException(request, (Throwable)e);
        }
        catch (IOException e) {
            throw new FetchException(request, (Throwable)e);
        }
    }

    private static class DefaultFetchResponse
    implements FetchResponse {
        private final HttpResponse response;

        public DefaultFetchResponse(HttpResponse response) {
            this.response = response;
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        @Override
        public InputStream getContentAsStream() throws FetchException {
            try {
                return this.response.getEntity().getContent();
            }
            catch (IllegalStateException e) {
                throw new FetchException(e);
            }
            catch (IOException e) {
                throw new FetchException(e);
            }
        }

        @Override
        public byte[] getContentAsBytes() throws FetchException {
            try {
                return IOUtils.toByteArray((InputStream)this.getContentAsStream());
            }
            catch (IOException e) {
                throw new FetchException(e);
            }
        }

        @Override
        public String getFirstHeader(String name) {
            Header header = this.response.getFirstHeader(name);
            if (header == null) {
                return null;
            }
            return header.getValue();
        }
    }
}

