/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.ui.session;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.internal.SAML2SSOAuthFEDataHolder;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.session.SessionClusterMessage;
import org.wso2.carbon.ui.CarbonSSOSessionManager;
import org.wso2.carbon.ui.CarbonUIAuthenticator;

public class SSOSessionManager {
    public static final Log log = LogFactory.getLog(SSOSessionManager.class);
    private static volatile SSOSessionManager instance;
    private Map sessionMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSOSessionManager getInstance() {
        if (instance != null) return instance;
        Class<SSOSessionManager> clazz = SSOSessionManager.class;
        synchronized (SSOSessionManager.class) {
            if (instance != null) return instance;
            instance = new SSOSessionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addSession(String sessionIndex, HttpSession httpSession) {
        this.sessionMap.put(sessionIndex, httpSession);
    }

    public void removeSession(String sessionIndex) {
        if (this.sessionMap.containsKey(sessionIndex)) {
            this.sessionMap.remove(sessionIndex);
        }
    }

    public HttpSession getSession(String sessionIndex) {
        Object session = this.sessionMap.get(sessionIndex);
        if (session != null) {
            return (HttpSession)session;
        }
        return null;
    }

    public void handleLogout(String sessionIndex) {
        HttpSession session = (HttpSession)this.sessionMap.get(sessionIndex);
        if (session == null) {
            this.sendSessionInvalidationClusterMessage(sessionIndex);
            return;
        }
        CarbonSSOSessionManager ssoSessionManager = SAML2SSOAuthFEDataHolder.getInstance().getCarbonSSOSessionManager();
        ssoSessionManager.makeSessionInvalid(sessionIndex);
        String username = (String)session.getAttribute("logged-user");
        log.info((Object)("Invalidating session for user " + username));
        try {
            CarbonUIAuthenticator authenticator = (CarbonUIAuthenticator)session.getAttribute("CarbonAuthenticator");
            if (authenticator != null) {
                authenticator.unauthenticate((Object)session);
                log.debug((Object)"Backend session invalidated");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        session.setAttribute("authenticated", (Object)false);
        session.removeAttribute("logged-user");
        session.getServletContext().removeAttribute("logged-user");
        this.removeSession(sessionIndex);
        try {
            session.invalidate();
        }
        catch (Exception ignored) {
            log.error((Object)ignored.getMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cleared authenticated session " + session.getId()));
        }
    }

    public void sendSessionInvalidationClusterMessage(String sessionIndex) {
        SessionClusterMessage clusterMessage = new SessionClusterMessage();
        clusterMessage.setMessageId(UUID.randomUUID());
        clusterMessage.setSessionIndex(sessionIndex);
        ClusteringAgent clusteringAgent = SAML2SSOAuthFEDataHolder.getInstance().getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getClusteringAgent();
        if (clusteringAgent != null) {
            int numberOfRetries = 0;
            while (numberOfRetries < 60) {
                try {
                    clusteringAgent.sendMessage((ClusteringMessage)clusterMessage, true);
                    log.info((Object)("Sent [" + (Object)((Object)clusterMessage) + "]"));
                    break;
                }
                catch (ClusteringFault e) {
                    if (++numberOfRetries < 60) {
                        log.warn((Object)("Could not send SSOSessionInvalidationClusterMessage. Retry will be attempted in 2s. Request: " + (Object)((Object)clusterMessage)), (Throwable)e);
                    } else {
                        log.error((Object)("Could not send SSOSessionInvalidationClusterMessage. Several retries failed. Request:" + (Object)((Object)clusterMessage)), (Throwable)e);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

