/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.ui.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.SAML2SSOUIAuthenticatorException;
import org.wso2.carbon.identity.sso.saml.stub.IdentitySAMLSSOServiceStub;
import org.wso2.carbon.identity.sso.saml.stub.types.SAMLSSOAuthnReqDTO;
import org.wso2.carbon.identity.sso.saml.stub.types.SAMLSSOReqValidationResponseDTO;
import org.wso2.carbon.identity.sso.saml.stub.types.SAMLSSORespDTO;

public class SAMLSSOServiceClient {
    private static final Log log = LogFactory.getLog(SAMLSSOServiceClient.class);
    private IdentitySAMLSSOServiceStub stub;

    public SAMLSSOServiceClient(String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "IdentitySAMLSSOService";
        this.stub = new IdentitySAMLSSOServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
    }

    public SAMLSSOReqValidationResponseDTO validate(String samlReq, String queryString, String sessionId, String rpSessionId, String authnMode, boolean isPost) throws SAML2SSOUIAuthenticatorException {
        try {
            return this.stub.validateSPInitSSORequest(samlReq, queryString, sessionId, rpSessionId, authnMode, isPost);
        }
        catch (Exception e) {
            log.error((Object)"Error validating the Authentication Request", (Throwable)e);
            throw new SAML2SSOUIAuthenticatorException("Error in parsing authentication request", (Throwable)e);
        }
    }

    public SAMLSSORespDTO authenticate(SAMLSSOAuthnReqDTO authnReqDTO, String sessionId) throws SAML2SSOUIAuthenticatorException {
        try {
            return this.stub.authenticate(authnReqDTO, sessionId, false, null, null);
        }
        catch (Exception e) {
            log.error((Object)"Error authenticating the user.", (Throwable)e);
            throw new SAML2SSOUIAuthenticatorException("Authentication Failure", (Throwable)e);
        }
    }

    public SAMLSSOReqValidationResponseDTO doSingleLogout(String sessionId) throws SAML2SSOUIAuthenticatorException {
        try {
            return this.stub.doSingleLogout(sessionId);
        }
        catch (Exception ex) {
            log.error((Object)"Error performing single logout.", (Throwable)ex);
            throw new SAML2SSOUIAuthenticatorException("Error performing Single Logout", (Throwable)ex);
        }
    }
}

