/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.ui.client;

import java.rmi.RemoteException;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.identity.authenticator.saml2.sso.stub.SAML2SSOAuthenticationServiceStub;
import org.wso2.carbon.identity.authenticator.saml2.sso.stub.types.AuthnReqDTO;
import org.wso2.carbon.utils.CarbonUtils;

public class SAML2SSOAuthenticationClient {
    private static final Log log = LogFactory.getLog(SAML2SSOAuthenticationClient.class);
    private SAML2SSOAuthenticationServiceStub stub;
    private HttpSession session;

    private SAML2SSOAuthenticationClient() {
    }

    public SAML2SSOAuthenticationClient(ConfigurationContext ctx, String serverURL, String cookie, HttpSession session) throws Exception {
        this.session = session;
        String serviceEPR = serverURL + "SAML2SSOAuthenticationService";
        this.stub = new SAML2SSOAuthenticationServiceStub(ctx, serviceEPR);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        if (cookie != null) {
            options.setProperty("Cookie", (Object)cookie);
        }
    }

    public boolean login(String samlResp, String username) throws AuthenticationException {
        try {
            AuthnReqDTO authDTO = new AuthnReqDTO();
            authDTO.setResponse(samlResp);
            boolean authStatus = this.stub.login(authDTO);
            this.setAdminCookie(authStatus);
            return authStatus;
        }
        catch (RemoteException e) {
            log.error((Object)("Error when sign-in for the user : " + username), (Throwable)e);
            throw new AuthenticationException("Error when sign-in for the user : " + username, (Throwable)e);
        }
    }

    public void logout(HttpSession session) throws AuthenticationException {
        try {
            if (!CarbonUtils.isRunningOnLocalTransportMode()) {
                this.stub.logout();
            }
            session.removeAttribute("wso2carbon.admin.service.cookie");
        }
        catch (Exception e) {
            String msg = "Error occurred while logging out";
            log.error((Object)msg, (Throwable)e);
            throw new AuthenticationException(msg, (Throwable)e);
        }
    }

    private void setAdminCookie(boolean result) {
        if (result) {
            String cookie = (String)this.stub._getServiceClient().getServiceContext().getProperty("Cookie");
            if (cookie == null) {
                cookie = UUID.randomUUID().toString();
            }
            this.session.setAttribute("wso2carbon.admin.service.cookie", (Object)cookie);
        }
    }
}

