/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.ui.authenticator;

import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.SAML2SSOUIAuthenticatorException;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.Util;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.client.SAML2SSOAuthenticationClient;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.internal.SAML2SSOAuthFEDataHolder;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.session.SSOSessionManager;
import org.wso2.carbon.ui.AbstractCarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonSSOSessionManager;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class SAML2SSOUIAuthenticator
extends AbstractCarbonUIAuthenticator {
    public static final Log log = LogFactory.getLog(SAML2SSOUIAuthenticator.class);
    private static final Log AUDIT_LOG = CarbonConstants.AUDIT_LOG;
    private static final int DEFAULT_PRIORITY_LEVEL = 50;
    private static final String AUTHENTICATOR_NAME = "SAML2SSOUIAuthenticator";

    public boolean canHandle(HttpServletRequest request) {
        String relayState = request.getParameter("RelayState");
        Object samlResponse = request.getAttribute("SAML2ResponseToken");
        if (request.getRequestURI().indexOf("/carbon/admin/logout_action.jsp") > -1) {
            return true;
        }
        return samlResponse != null && samlResponse instanceof Response && relayState != null;
    }

    public void authenticate(HttpServletRequest request) throws AuthenticationException {
        boolean isAuthenticated = false;
        String auditResult = "Failed";
        this.regenerateSession(request);
        HttpSession session = request.getSession();
        Response samlResponse = (Response)request.getAttribute("SAML2ResponseToken");
        String responseStr = request.getParameter("SAMLResponse");
        String username = Util.getUsernameFromResponse((Response)samlResponse);
        ServletContext servletContext = request.getSession().getServletContext();
        ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        String backEndServerURL = request.getParameter("backendURL");
        if (backEndServerURL == null) {
            backEndServerURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)session);
        }
        session.setAttribute("ServerURL", (Object)backEndServerURL);
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        SAML2SSOAuthenticationClient authenticationClient = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking the SAML2 SSO Authenticator BE for the Response : " + responseStr));
            }
            if (isAuthenticated = (authenticationClient = new SAML2SSOAuthenticationClient(configContext, backEndServerURL, cookie, session)).login(responseStr, username)) {
                CarbonSSOSessionManager ssoSessionManager = SAML2SSOAuthFEDataHolder.getInstance().getCarbonSSOSessionManager();
                String sessionId = this.getSessionIndexFromResponse(samlResponse);
                if (sessionId != null) {
                    ssoSessionManager.addSessionMapping(this.getSessionIndexFromResponse(samlResponse), session.getId());
                    request.getSession().setAttribute("idpSessionIndex", (Object)sessionId);
                    SSOSessionManager.getInstance().addSession(sessionId, request.getSession());
                }
                this.onSuccessAdminLogin(request, username);
                auditResult = "Success";
            } else {
                log.error((Object)"Authentication failed.");
            }
        }
        catch (SAML2SSOUIAuthenticatorException e) {
            log.error((Object)("Error when authenticating the user : " + username), (Throwable)e);
            throw new AuthenticationException("Error when authenticating the user : " + username, (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error when creating SAML2SSOAuthenticationClient.", (Throwable)e);
            throw new AuthenticationException("Error when creating SAML2SSOAuthenticationClient.", (Throwable)e);
        }
        if (username != null && username.trim().length() > 0 && AUDIT_LOG.isInfoEnabled()) {
            String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)username);
            String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
            String auditInitiator = tenantAwareUsername + "@" + tenantDomain;
            String auditData = "";
            AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator, "Login", AUTHENTICATOR_NAME, auditData, auditResult));
        }
        if (!isAuthenticated) {
            throw new AuthenticationException("Authentication failure " + username);
        }
    }

    public void unauthenticate(Object o) throws Exception {
        String username;
        HttpServletRequest request;
        String auditResult;
        block11: {
            auditResult = "Failed";
            request = null;
            HttpSession session = null;
            if (o instanceof HttpSession) {
                session = (HttpSession)o;
            } else {
                request = (HttpServletRequest)o;
                session = request.getSession();
            }
            username = (String)session.getAttribute("logged-user");
            ServletContext servletContext = session.getServletContext();
            ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
            String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)session);
            try {
                String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
                SAML2SSOAuthenticationClient authClient = new SAML2SSOAuthenticationClient(configContext, backendServerURL, cookie, session);
                authClient.logout(session);
                if (request != null) {
                    request.setAttribute("logoutRequest", (Object)true);
                    request.setAttribute("loggedInUser", session.getAttribute("logged-user"));
                    if (!Util.isLogoutSupportedIDP()) {
                        request.setAttribute("ExternalLogoutPage", (Object)Util.getExternalLogoutPage());
                    }
                }
                auditResult = "Success";
                if (username == null || "".equals(username.trim()) || request == null || !"true".equalsIgnoreCase(request.getParameter("logoutcomplete"))) break block11;
                if (session.getAttribute("tenantDomain") != null) {
                    username = username + "@" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                }
                log.info((Object)(username + " successfully logged out"));
            }
            catch (Exception ignored) {
                try {
                    String msg = "Configuration context is null.";
                    log.error((Object)msg);
                    throw new Exception(msg);
                }
                catch (Throwable throwable) {
                    if (username != null && username.trim().length() > 0 && AUDIT_LOG.isInfoEnabled() && request != null && "true".equalsIgnoreCase(request.getParameter("logoutcomplete"))) {
                        String auditInitiator = username;
                        String auditData = "";
                        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator, "Logout", AUTHENTICATOR_NAME, auditData, auditResult));
                    }
                    throw throwable;
                }
            }
        }
        if (username != null && username.trim().length() > 0 && AUDIT_LOG.isInfoEnabled() && request != null && "true".equalsIgnoreCase(request.getParameter("logoutcomplete"))) {
            String auditInitiator = username;
            String auditData = "";
            AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator, "Logout", AUTHENTICATOR_NAME, auditData, auditResult));
        }
    }

    public int getPriority() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig("SAML2SSOAuthenticator");
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            return authenticatorConfig.getPriority();
        }
        return 50;
    }

    public String getAuthenticatorName() {
        return "SAML2SSOAuthenticator";
    }

    public boolean isDisabled() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig("SAML2SSOAuthenticator");
        if (authenticatorConfig != null) {
            return authenticatorConfig.isDisabled();
        }
        return false;
    }

    private String getUsernameFromResponse(Response response) {
        List assertions = response.getAssertions();
        Assertion assertion = null;
        if (assertions != null && assertions.size() > 0) {
            assertion = (Assertion)assertions.get(0);
            return assertion.getSubject().getNameID().getValue();
        }
        return null;
    }

    private String getSessionIndexFromResponse(Response response) {
        List authnStatements;
        List assertions = response.getAssertions();
        String sessionIndex = null;
        if (assertions != null && assertions.size() > 0 && (authnStatements = ((Assertion)assertions.get(0)).getAuthnStatements()) != null && authnStatements.size() > 0) {
            AuthnStatement authStmt = (AuthnStatement)authnStatements.get(0);
            sessionIndex = authStmt.getSessionIndex();
        }
        return sessionIndex;
    }

    private void regenerateSession(HttpServletRequest request) {
        HttpSession oldSession = request.getSession();
        Enumeration<Object> attrNames = oldSession.getAttributeNames();
        Properties props = new Properties();
        while (attrNames != null && attrNames.hasMoreElements()) {
            String key = (String)attrNames.nextElement();
            props.put(key, oldSession.getAttribute(key));
        }
        oldSession.invalidate();
        HttpSession newSession = request.getSession(true);
        attrNames = props.keys();
        while (attrNames != null && attrNames.hasMoreElements()) {
            String key = (String)attrNames.nextElement();
            newSession.setAttribute(key, props.get(key));
        }
    }

    public boolean reAuthenticateOnSessionExpire(Object object) throws AuthenticationException {
        return false;
    }

    public void authenticateWithCookie(HttpServletRequest request) throws AuthenticationException {
    }

    public String doAuthentication(Object credentials, boolean isRememberMe, ServiceClient client, HttpServletRequest request) throws AuthenticationException {
        return null;
    }

    public void handleRememberMe(Map transportHeaders, HttpServletRequest httpServletRequest) throws AuthenticationException {
    }
}

