/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.ui;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Subject;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.FederatedSSOToken;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.SAML2SSOUIAuthenticatorException;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.Util;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.authenticator.SAML2SSOUIAuthenticator;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.client.SAMLSSOServiceClient;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.session.SSOSessionManager;
import org.wso2.carbon.identity.sso.saml.stub.types.SAMLSSOAuthnReqDTO;
import org.wso2.carbon.identity.sso.saml.stub.types.SAMLSSOReqValidationResponseDTO;
import org.wso2.carbon.identity.sso.saml.stub.types.SAMLSSORespDTO;
import org.wso2.carbon.ui.CarbonUIUtil;

public class SSOAssertionConsumerService
extends HttpServlet {
    public static final Log log = LogFactory.getLog(SSOAssertionConsumerService.class);
    public static final String SSO_TOKEN_ID = "ssoTokenId";
    private static final long serialVersionUID = 5451353570561170887L;
    private static final int SSO_SESSION_EXPIRE = 36000;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String samlRespString = req.getParameter("SAMLResponse");
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing SAML Response");
            Enumeration headerNames = req.getHeaderNames();
            log.debug((Object)"[Request Headers] :");
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                log.debug((Object)(">> " + headerName + ":" + req.getHeader(headerName)));
            }
            Enumeration params = req.getParameterNames();
            log.debug((Object)"[Request Parameters] :");
            while (params.hasMoreElements()) {
                String paramName = (String)params.nextElement();
                log.debug((Object)(">> " + paramName + ":" + req.getParameter(paramName)));
            }
        }
        if (req.getParameter("SAMLRequest") != null) {
            this.handleSingleLogoutRequest(req, resp);
            return;
        }
        if (samlRespString == null) {
            log.error((Object)"SAML Response is not present in the request.");
            this.handleMalformedResponses(req, resp, "response.not.present");
            return;
        }
        try {
            XMLObject samlObject = Util.unmarshall((String)Util.decode((String)samlRespString));
            if (samlObject instanceof LogoutResponse) {
                String externalLogoutPage = Util.getExternalLogoutPage();
                if (externalLogoutPage != null && !externalLogoutPage.isEmpty()) {
                    this.handleExternalLogout(req, resp, externalLogoutPage);
                } else {
                    resp.sendRedirect(this.getAdminConsoleURL(req) + "admin/logout_action.jsp?logoutcomplete=true");
                }
            } else if (samlObject instanceof Response) {
                this.handleSAMLResponses(req, resp, samlObject);
            }
        }
        catch (SAML2SSOUIAuthenticatorException e) {
            log.error((Object)"Error when processing the SAML Assertion in the request.", (Throwable)e);
            this.handleMalformedResponses(req, resp, "response.malformed");
        }
    }

    private void handleSAMLResponses(HttpServletRequest req, HttpServletResponse resp, XMLObject samlObject) throws ServletException, IOException, SAML2SSOUIAuthenticatorException {
        FederatedSSOToken federatedSSOToken;
        Response samlResponse = (Response)samlObject;
        List assertions = samlResponse.getAssertions();
        Assertion assertion = null;
        if (assertions != null && assertions.size() > 0) {
            assertion = (Assertion)assertions.get(0);
        } else {
            List encryptedAssertions = samlResponse.getEncryptedAssertions();
            if (encryptedAssertions.size() > 0) {
                EncryptedAssertion encryptedAssertion = (EncryptedAssertion)encryptedAssertions.get(0);
                try {
                    String tenantDomain = "carbon.super";
                    assertion = Util.getDecryptedAssertion((EncryptedAssertion)encryptedAssertion, (String)tenantDomain);
                }
                catch (SAML2SSOUIAuthenticatorException e) {
                    throw new SAML2SSOUIAuthenticatorException("Unable to decrypt the SAML Assertion", (Throwable)e);
                }
            }
        }
        if (assertion == null) {
            if (samlResponse.getStatus() != null && samlResponse.getStatus().getStatusCode() != null && samlResponse.getStatus().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Responder") && samlResponse.getStatus().getStatusCode().getStatusCode() != null && samlResponse.getStatus().getStatusCode().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:NoPassive")) {
                RequestDispatcher requestDispatcher = req.getRequestDispatcher("/carbon/admin/login.jsp");
                requestDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            if (samlResponse.getStatus() != null && samlResponse.getStatus().getStatusMessage() != null) {
                log.error((Object)samlResponse.getStatus().getStatusMessage().getMessage());
            } else {
                log.error((Object)"SAML Assertion not found in the Response.");
            }
            throw new SAML2SSOUIAuthenticatorException("SAML Authentication Failed.");
        }
        String username = null;
        if (assertion.getSubject() != null && assertion.getSubject().getNameID() != null) {
            username = Util.getUsernameFromResponse((Response)samlResponse);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("A username is extracted from the response. : " + username));
        }
        if (username == null) {
            log.error((Object)"SAMLResponse does not contain the name of the subject");
            throw new SAML2SSOUIAuthenticatorException("SAMLResponse does not contain the name of the subject");
        }
        String relayState = req.getParameter("RelayState");
        boolean isFederated = false;
        if (relayState != null && (federatedSSOToken = org.wso2.carbon.identity.authenticator.saml2.sso.common.SSOSessionManager.getFederatedToken((String)relayState)) != null) {
            isFederated = true;
            HttpServletRequest fedRequest = federatedSSOToken.getHttpServletRequest();
            String samlRequest = fedRequest.getParameter("SAMLRequest");
            String authMode = "usernamePasswordBasedAuthn";
            String fedRelayState = fedRequest.getParameter("RelayState");
            String rpSessionId = fedRequest.getParameter("SSOAuthSessionID");
            Enumeration e = fedRequest.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                req.setAttribute(name, fedRequest.getAttribute(name));
            }
            Cookie[] cookies = fedRequest.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    resp.addCookie(cookies[i]);
                }
            }
            HttpSession session = fedRequest.getSession();
            String ssoTokenID = session.getId();
            Cookie tokenCookie = this.getSSOTokenCookie(fedRequest);
            if (tokenCookie != null) {
                ssoTokenID = tokenCookie.getValue();
            }
            this.handleFederatedSAMLRequest(req, resp, ssoTokenID, samlRequest, fedRelayState, authMode, assertion.getSubject(), rpSessionId);
        }
        if (!isFederated) {
            req.setAttribute("SAML2ResponseToken", (Object)samlResponse);
            String sessionIndex = null;
            List authnStatements = assertion.getAuthnStatements();
            if (authnStatements != null && authnStatements.size() > 0) {
                AuthnStatement authStmt = (AuthnStatement)authnStatements.get(0);
                sessionIndex = authStmt.getSessionIndex();
            }
            String url = req.getRequestURI();
            url = url.replace("acs", "carbon/admin/login_action.jsp?username=" + URLEncoder.encode(username, "UTF-8"));
            if (sessionIndex != null) {
                url = url + "&idpSessionIndex=" + URLEncoder.encode(sessionIndex, "UTF-8");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Forwarding to path : " + url));
            }
            RequestDispatcher reqDispatcher = req.getRequestDispatcher(url);
            req.getSession().setAttribute("CarbonAuthenticator", (Object)new SAML2SSOUIAuthenticator());
            reqDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private void handleMalformedResponses(HttpServletRequest req, HttpServletResponse resp, String errorMsg) throws IOException {
        HttpSession session = req.getSession();
        session.setAttribute("ErrorMessage", (Object)errorMsg);
        resp.sendRedirect(this.getAdminConsoleURL(req) + "sso-acs/notifications.jsp");
    }

    private void handleSingleLogoutRequest(HttpServletRequest req, HttpServletResponse resp) {
        LogoutRequest logoutRequest;
        List sessionIndexList;
        String logoutReqStr = req.getParameter("SAMLRequest");
        XMLObject samlObject = null;
        try {
            samlObject = Util.unmarshall((String)Util.decode((String)logoutReqStr));
        }
        catch (SAML2SSOUIAuthenticatorException e) {
            log.error((Object)"Error handling the single logout request", (Throwable)e);
        }
        if (samlObject instanceof LogoutRequest && (sessionIndexList = (logoutRequest = (LogoutRequest)samlObject).getSessionIndexes()).size() > 0) {
            SSOSessionManager.getInstance().handleLogout(((SessionIndex)sessionIndexList.get(0)).getSessionIndex());
        }
    }

    private String getAdminConsoleURL(HttpServletRequest request) {
        String url = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)request);
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (url.indexOf("/acs") != -1) {
            url = url.replace("/acs", "");
        }
        return url;
    }

    private void handleFederatedSAMLRequest(HttpServletRequest req, HttpServletResponse resp, String ssoTokenID, String samlRequest, String relayState, String authMode, Subject subject, String rpSessionId) throws IOException, ServletException, SAML2SSOUIAuthenticatorException {
        SAMLSSOReqValidationResponseDTO signInRespDTO;
        HttpSession session = req.getSession();
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)session.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)session.getServletContext().getAttribute("ConfigurationContext");
        SAMLSSOServiceClient ssoServiceClient = new SAMLSSOServiceClient(serverURL, configContext);
        String method = req.getMethod();
        boolean isPost = false;
        if ("post".equalsIgnoreCase(method)) {
            isPost = true;
        }
        if ((signInRespDTO = ssoServiceClient.validate(samlRequest, null, ssoTokenID, rpSessionId, authMode, isPost)).getValid()) {
            this.handleRequestFromLoginPage(req, resp, ssoTokenID, signInRespDTO.getAssertionConsumerURL(), signInRespDTO.getId(), signInRespDTO.getIssuer(), subject.getNameID().getValue(), subject.getNameID().getValue(), signInRespDTO.getRpSessionId(), signInRespDTO.getRequestMessageString(), relayState);
        }
    }

    private void handleRequestFromLoginPage(HttpServletRequest req, HttpServletResponse resp, String ssoTokenID, String assertionConsumerUrl, String id, String issuer, String userName, String subject, String rpSession, String requestMsgString, String relayState) throws IOException, ServletException, SAML2SSOUIAuthenticatorException {
        HttpSession session = req.getSession();
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)session.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)session.getServletContext().getAttribute("ConfigurationContext");
        SAMLSSOServiceClient ssoServiceClient = new SAMLSSOServiceClient(serverURL, configContext);
        SAMLSSOAuthnReqDTO authnReqDTO = new SAMLSSOAuthnReqDTO();
        authnReqDTO.setAssertionConsumerURL(assertionConsumerUrl);
        authnReqDTO.setId(id);
        authnReqDTO.setIssuer(issuer);
        authnReqDTO.setUser(null);
        authnReqDTO.setPassword("federated_idp_login");
        authnReqDTO.setSubject(subject);
        authnReqDTO.setRpSessionId(rpSession);
        authnReqDTO.setRequestMessageString(requestMsgString);
        SAMLSSORespDTO authRespDTO = ssoServiceClient.authenticate(authnReqDTO, ssoTokenID);
        if (authRespDTO.getSessionEstablished()) {
            this.storeSSOTokenCookie(ssoTokenID, req, resp);
            req.setAttribute("RelayState", (Object)relayState);
            req.setAttribute("assertionString", (Object)authRespDTO.getRespString());
            req.setAttribute("assertnConsumerURL", (Object)authRespDTO.getAssertionConsumerURL());
            req.setAttribute("subject", (Object)authRespDTO.getSubject());
            RequestDispatcher reqDispatcher = req.getRequestDispatcher("/carbon/sso-acs/federation_ajaxprocessor.jsp");
            reqDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
    }

    private void storeSSOTokenCookie(String ssoTokenID, HttpServletRequest req, HttpServletResponse resp) {
        Cookie ssoTokenCookie = this.getSSOTokenCookie(req);
        if (ssoTokenCookie == null) {
            ssoTokenCookie = new Cookie(SSO_TOKEN_ID, ssoTokenID);
            ssoTokenCookie.setSecure(true);
            ssoTokenCookie.setHttpOnly(true);
        }
        ssoTokenCookie.setMaxAge(36000);
        resp.addCookie(ssoTokenCookie);
    }

    private Cookie getSSOTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!SSO_TOKEN_ID.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    private void handleExternalLogout(HttpServletRequest req, HttpServletResponse resp, String externalLogoutPage) throws IOException {
        HttpSession currentSession = req.getSession(false);
        if (currentSession != null) {
            currentSession.removeAttribute("logged-user");
            currentSession.getServletContext().removeAttribute("logged-user");
            try {
                currentSession.invalidate();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Frontend session invalidated");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.clearCookies(req, resp);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending to " + externalLogoutPage));
        }
        resp.sendRedirect(externalLogoutPage);
    }

    private void clearCookies(HttpServletRequest req, HttpServletResponse resp) {
        Cookie[] cookies;
        for (Cookie curCookie : cookies = req.getCookies()) {
            Cookie cookie;
            if (curCookie.getName().equals("requestedURI")) {
                cookie = new Cookie("requestedURI", null);
                cookie.setPath("/");
                cookie.setMaxAge(0);
                resp.addCookie(cookie);
                continue;
            }
            if (!curCookie.getName().equals("wso2.carbon.rememberme")) continue;
            cookie = new Cookie("wso2.carbon.rememberme", null);
            cookie.setPath("/");
            cookie.setMaxAge(0);
            resp.addCookie(cookie);
        }
    }
}

