/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.carbon.server.CarbonLaunchExtension;
import org.wso2.carbon.server.util.FileUtils;
import org.wso2.carbon.server.util.Utils;

public abstract class FragmentBundleCreator
implements CarbonLaunchExtension {
    private static final Logger logger = Logger.getLogger(FragmentBundleCreator.class.getName());
    private static String FRAGMENT_BUNDLE_VERSION = "1.0.0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() {
        File[] files = this.getBundleConfigs();
        if (files.length > 0) {
            for (File file : files) {
                String fragmentHostBundleName = this.getFragmentHostBundleName(file);
                String fragmentBundleName = this.getFragmentBundleName(file);
                try {
                    Manifest mf = new Manifest();
                    Attributes attribs = mf.getMainAttributes();
                    attribs.putValue("Manifest-Version", "1.0");
                    attribs.putValue("Bundle-ManifestVersion", "2");
                    attribs.putValue("Bundle-Name", fragmentBundleName);
                    attribs.putValue("Bundle-SymbolicName", fragmentBundleName);
                    attribs.putValue("Bundle-Version", FRAGMENT_BUNDLE_VERSION);
                    attribs.putValue("Fragment-Host", fragmentHostBundleName);
                    attribs.putValue("Bundle-ClassPath", ".");
                    String dropinsPath = System.getProperty("carbon.dropins.dir.path");
                    File dropinsFolder = dropinsPath == null ? new File(Utils.getCarbonComponentRepo(), "dropins") : new File(dropinsPath);
                    String targetFilePath = dropinsFolder.getAbsolutePath() + File.separator + fragmentBundleName + "_" + FRAGMENT_BUNDLE_VERSION + ".jar";
                    String tempDirPath = Utils.JAR_TO_BUNDLE_DIR + File.separator + System.currentTimeMillis() + Math.random();
                    FileOutputStream mfos = null;
                    try {
                        if (file.isDirectory()) {
                            FileUtils.copyDirectory(file, new File(tempDirPath));
                        } else {
                            Utils.copyFileToDir(file, new File(tempDirPath));
                        }
                        String metaInfPath = tempDirPath + File.separator + "META-INF";
                        if (!new File(metaInfPath).mkdirs()) {
                            throw new IOException("Failed to create the directory: " + metaInfPath);
                        }
                        mfos = new FileOutputStream(metaInfPath + File.separator + "MANIFEST.MF");
                        mf.write(mfos);
                        Utils.archiveDir(targetFilePath, tempDirPath);
                        Utils.deleteDir(new File(tempDirPath));
                    }
                    finally {
                        try {
                            if (mfos != null) {
                                mfos.close();
                            }
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "Unable to close the OutputStream " + e.getMessage(), e);
                        }
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Error occured while creating the log4j prop fragment bundle.", e);
                }
            }
        }
    }

    protected abstract File[] getBundleConfigs();

    protected abstract String getFragmentHostBundleName(File var1);

    protected abstract String getFragmentBundleName(File var1);
}

