/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.wso2.carbon.server.CarbonLauncher;
import org.wso2.carbon.server.extensions.DefaultBundleCreator;
import org.wso2.carbon.server.extensions.DropinsBundleDeployer;
import org.wso2.carbon.server.extensions.EclipseIniRewriter;
import org.wso2.carbon.server.extensions.LibraryFragmentBundleCreator;
import org.wso2.carbon.server.extensions.PatchInstaller;
import org.wso2.carbon.server.extensions.SystemBundleExtensionCreator;
import org.wso2.carbon.server.util.Utils;
import org.wso2.config.mapper.ConfigParser;
import org.wso2.config.mapper.ConfigParserException;

public class Main {
    private static final Logger logger = Logger.getLogger(Main.class.getName());
    private static final String CARBON_PROPERTIES = "carbon.properties";
    private static final String CONF_DIRECTORY_PATH = "carbon.config.dir.path";

    public static void main(String[] args) {
        String confPath = System.getProperty(CONF_DIRECTORY_PATH);
        System.setProperty("org.ops4j.pax.logging.DefaultServiceLog.level", "WARN");
        System.setProperty("org.ops4j.pax.logging.property.file", confPath + File.separator + "etc" + File.separator + "pax-logging.properties");
        if (System.getProperty("carbon.home") == null) {
            System.setProperty("carbon.home", ".");
        }
        System.setProperty("axis2.home", System.getProperty("carbon.home"));
        System.setProperty("wso2carbon.start.time", System.currentTimeMillis() + "");
        if (System.getProperty("carbon.instance.name") == null) {
            String hostName;
            String ipAddr;
            try {
                InetAddress addr = InetAddress.getLocalHost();
                ipAddr = addr.getHostAddress();
                hostName = addr.getHostName();
            }
            catch (UnknownHostException e) {
                ipAddr = "localhost";
                hostName = "127.0.0.1";
            }
            String uuId = UUID.randomUUID().toString();
            String timeStamp = System.currentTimeMillis() + "";
            String carbon_instance_name = timeStamp + "_" + hostName + "_" + ipAddr + "_" + uuId;
            System.setProperty("carbon.instance.name", carbon_instance_name);
        }
        Main.writePID(System.getProperty("carbon.home"));
        Main.processCmdLineArgs(args);
        if (System.getProperty("workerNode") != null && "true".equals(System.getProperty("workerNode")) && System.getProperty("profile") == null) {
            File profileDir = new File(Utils.getCarbonComponentRepo() + File.separator + "worker");
            if (!profileDir.exists()) {
                logger.log(Level.SEVERE, "OSGi runtime worker profile not found");
                throw new RuntimeException("worker profile not found");
            }
            System.setProperty("profile", "worker");
        }
        if (System.getProperty("profile") == null) {
            System.setProperty("profile", "default");
        }
        Main.handleConfiguration();
        Main.addSystemProperties();
        Main.invokeExtensions();
        Main.launchCarbon();
    }

    public static void processCmdLineArgs(String[] args) {
        String cmd = null;
        int index = 0;
        for (String arg : args) {
            ++index;
            if (arg.startsWith("-D")) {
                String value;
                String property;
                int indexOfEq = arg.indexOf(61);
                if (indexOfEq != -1) {
                    property = arg.substring(2, indexOfEq);
                    value = arg.substring(indexOfEq + 1);
                } else {
                    property = arg.substring(2);
                    value = "true";
                }
                System.setProperty(property, value);
                continue;
            }
            if (arg.toUpperCase().endsWith("HELP")) {
                Utils.printUsages();
                System.exit(0);
                continue;
            }
            if (arg.toUpperCase().endsWith("CLEANREGISTRY")) {
                System.setProperty("carbon.registry.clean", "true");
                continue;
            }
            if (cmd != null) continue;
            cmd = arg;
        }
    }

    public static void invokeExtensions() {
        new DefaultBundleCreator().perform();
        new SystemBundleExtensionCreator().perform();
        new LibraryFragmentBundleCreator().perform();
        new DropinsBundleDeployer().perform();
        new PatchInstaller().perform();
        new EclipseIniRewriter().perform();
    }

    public static void launchCarbon() {
        CarbonLauncher carbonLauncher = new CarbonLauncher();
        carbonLauncher.launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePID(String carbonHome) {
        Process p;
        byte[] bo = new byte[100];
        String[] cmd = new String[]{"sh", "-c", "echo $PPID"};
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            return;
        }
        try {
            int e = p.getInputStream().read(bo);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        String pid = new String(bo);
        if (pid.length() != 0) {
            BufferedWriter out = null;
            try {
                FileWriter writer = new FileWriter(carbonHome + File.separator + "wso2carbon.pid");
                out = new BufferedWriter(writer);
                out.write(pid);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Cannot write wso2carbon.pid file");
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void handleConfiguration() {
        String resourcesDir = System.getProperty("carbon.new.config.dir.path");
        String configFilePath = System.getProperty("deployment.config.file.path");
        if (StringUtils.isEmpty((CharSequence)configFilePath)) {
            configFilePath = System.getProperty(CONF_DIRECTORY_PATH) + File.separator + "deployment.toml";
        }
        String outputDir = System.getProperty("carbon.home");
        try {
            ConfigParser.parse((String)configFilePath, (String)resourcesDir, (String)outputDir);
        }
        catch (ConfigParserException e) {
            logger.log(Level.SEVERE, "Error while performing configuration changes", e);
            System.exit(1);
        }
    }

    private static void addSystemProperties() {
        Properties properties = new Properties();
        String filePath = System.getProperty(CONF_DIRECTORY_PATH) + File.separator + CARBON_PROPERTIES;
        File file = new File(filePath);
        if (file.exists()) {
            try (FileInputStream in = new FileInputStream(file);){
                properties.load(in);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error while reading the file '" + filePath + "'.", e);
                System.exit(1);
            }
        } else {
            logger.log(Level.WARNING, "The file '" + filePath + "' does not exist.");
        }
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            System.setProperty((String)key, (String)properties.get(key));
        }
        System.setProperty("javax.xml.bind.JAXBContextFactory", "com.sun.xml.bind.v2.ContextFactory");
    }
}

