/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring.support;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassContext;
import org.compass.core.CompassSession;
import org.compass.core.spi.InternalCompass;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.support.session.CompassSessionTransactionalProxy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompassContextBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ApplicationContext applicationContext;
    private Map<Class<?>, List<AnnotatedMember>> classMetadata = new HashMap();
    private Map<String, Compass> compassesByName;
    private Compass uniqueCompass;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private synchronized void initMapsIfNecessary() {
        if (this.compassesByName == null) {
            String[] beanNames;
            this.compassesByName = new HashMap<String, Compass>();
            for (String emfName : beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, Compass.class)) {
                Compass compass = (Compass)this.applicationContext.getBean(emfName);
                this.compassesByName.put(((InternalCompass)compass).getName(), compass);
            }
            if (this.compassesByName.isEmpty()) {
                if (beanNames.length == 1) {
                    this.uniqueCompass = (Compass)this.applicationContext.getBean(beanNames[0]);
                }
            } else if (this.compassesByName.size() == 1) {
                this.uniqueCompass = this.compassesByName.values().iterator().next();
            }
            if (this.compassesByName.isEmpty() && this.uniqueCompass == null) {
                this.logger.warn((Object)"No named compass instances defined and not exactly one anonymous one: cannot inject");
            }
        }
    }

    protected Compass findEntityManagerFactoryByName(String compassName) throws NoSuchBeanDefinitionException {
        this.initMapsIfNecessary();
        if (compassName == null || "".equals(compassName)) {
            if (this.uniqueCompass != null) {
                return this.uniqueCompass;
            }
            throw new NoSuchBeanDefinitionException("No Compass name given and factory contains several");
        }
        Compass namedCompass = this.compassesByName.get(compassName);
        if (namedCompass == null) {
            throw new NoSuchBeanDefinitionException("No Compass found for name [" + compassName + "]");
        }
        return namedCompass;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        List<AnnotatedMember> metadata = this.findClassMetadata(bean.getClass());
        for (AnnotatedMember member : metadata) {
            member.inject(bean);
        }
        return true;
    }

    private synchronized List<AnnotatedMember> findClassMetadata(Class<? extends Object> clazz) {
        List<AnnotatedMember> metadata = this.classMetadata.get(clazz);
        if (metadata == null) {
            final LinkedList<AnnotatedMember> newMetadata = new LinkedList<AnnotatedMember>();
            ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field f) {
                    CompassContextBeanPostProcessor.this.addIfPresent(newMetadata, f);
                }
            });
            ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method m) {
                    CompassContextBeanPostProcessor.this.addIfPresent(newMetadata, m);
                }
            });
            metadata = newMetadata;
            this.classMetadata.put(clazz, metadata);
        }
        return metadata;
    }

    private void addIfPresent(List<AnnotatedMember> metadata, AccessibleObject ao) {
        CompassContext compassContext = ao.getAnnotation(CompassContext.class);
        if (compassContext != null) {
            metadata.add(new AnnotatedMember(compassContext.name(), ao));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotatedMember {
        private final String name;
        private final AccessibleObject member;

        public AnnotatedMember(String name, AccessibleObject member) {
            this.name = name;
            this.member = member;
            Class<?> memberType = this.getMemberType();
            if (!Compass.class.isAssignableFrom(memberType) && !CompassSession.class.isAssignableFrom(memberType)) {
                throw new IllegalArgumentException("Cannot inject " + member + ": not a supported Compass type");
            }
        }

        public void inject(Object instance) {
            block6: {
                Object value = this.resolve();
                try {
                    if (!this.member.isAccessible()) {
                        this.member.setAccessible(true);
                    }
                    if (this.member instanceof Field) {
                        ((Field)this.member).set(instance, value);
                        break block6;
                    }
                    if (this.member instanceof Method) {
                        ((Method)this.member).invoke(instance, value);
                        break block6;
                    }
                    throw new IllegalArgumentException("Cannot inject unknown AccessibleObject type " + this.member);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException("Cannot inject member " + this.member, ex);
                }
                catch (InvocationTargetException ex) {
                    throw new IllegalArgumentException("Attempt to inject setter method " + this.member + " resulted in an exception", ex);
                }
            }
        }

        public Class<?> getMemberType() {
            if (this.member instanceof Field) {
                return ((Field)this.member).getType();
            }
            if (this.member instanceof Method) {
                Method setter = (Method)this.member;
                if (setter.getParameterTypes().length != 1) {
                    throw new IllegalArgumentException("Supposed setter " + this.member + " must have 1 argument, not " + setter.getParameterTypes().length);
                }
                return setter.getParameterTypes()[0];
            }
            throw new IllegalArgumentException("Unknown AccessibleObject type " + this.member.getClass() + "; Can only inject settermethods or fields");
        }

        protected Object resolve() {
            Compass compass = CompassContextBeanPostProcessor.this.findEntityManagerFactoryByName(this.name);
            if (Compass.class.isAssignableFrom(this.getMemberType())) {
                if (!this.getMemberType().isInstance(compass)) {
                    throw new IllegalArgumentException("Cannot inject " + this.member + " with Compass [" + this.name + "]: type mismatch");
                }
                return compass;
            }
            return Proxy.newProxyInstance(CompassContextBeanPostProcessor.class.getClassLoader(), new Class[]{InternalCompassSession.class}, (InvocationHandler)new CompassSessionTransactionalProxy(compass));
        }
    }
}

