/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.gps.device.jpa.EntityManagerWrapper;
import org.compass.gps.device.jpa.JpaGpsDeviceException;

public abstract class AbstractEntityManagerWrapper
implements EntityManagerWrapper {
    protected Log log = LogFactory.getLog(this.getClass());
    protected EntityManagerFactory entityManagerFactory;
    protected EntityManager entityManager;

    public void setUp(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManager getEntityManager() {
        if (this.entityManager == null) {
            throw new IllegalStateException("Must be called between open and close");
        }
        return this.entityManager;
    }

    public void open() throws JpaGpsDeviceException, PersistenceException {
        this.doCreateEntityManager();
        this.beginTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JpaGpsDeviceException, PersistenceException {
        try {
            this.commitTransaction();
        }
        finally {
            if (this.shouldCloseEntityManager()) {
                try {
                    this.entityManager.close();
                }
                catch (PersistenceException e) {
                    this.log.warn((Object)"Failed to close JPA EntityManager", (Throwable)e);
                }
                finally {
                    this.entityManager = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOnError() throws JpaGpsDeviceException {
        try {
            this.rollbackTransaction();
        }
        catch (PersistenceException e) {
            this.log.warn((Object)"Failed to rollback JPA transaction, ignoring", (Throwable)e);
        }
        if (this.shouldCloseEntityManager()) {
            try {
                if (this.entityManager != null) {
                    this.entityManager.close();
                }
            }
            catch (PersistenceException e) {
                this.log.warn((Object)"Failed to close JPA EntityManager, ignoring", (Throwable)e);
            }
            finally {
                this.entityManager = null;
            }
        }
    }

    public EntityManagerWrapper newInstance() {
        try {
            AbstractEntityManagerWrapper copy = (AbstractEntityManagerWrapper)this.getClass().newInstance();
            copy.entityManagerFactory = this.entityManagerFactory;
            return copy;
        }
        catch (Exception e) {
            throw new JpaGpsDeviceException("Failed to create new wrapper", e);
        }
    }

    protected void doCreateEntityManager() throws PersistenceException {
        this.entityManager = this.entityManagerFactory.createEntityManager();
    }

    protected abstract void beginTransaction() throws PersistenceException;

    protected abstract void commitTransaction() throws PersistenceException;

    protected abstract void rollbackTransaction() throws PersistenceException;

    protected abstract boolean shouldCloseEntityManager();
}

