/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.cascade;

import java.lang.reflect.Array;
import java.util.Collection;
import org.compass.core.CompassException;
import org.compass.core.cascade.CompassCascadeFilter;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.AliasedObject;
import org.compass.core.spi.InternalCompassSession;

public class CascadingManager
implements CompassConfigurable {
    private InternalCompassSession session;
    private CompassMapping mapping;
    private CompassCascadeFilter cascadeFilter;

    public CascadingManager(InternalCompassSession session) {
        this.session = session;
        this.mapping = session.getMapping();
        this.configure(session.getCompass().getSettings());
    }

    public void configure(CompassSettings settings) throws CompassException {
        String filterName = settings.getSetting("compass.cascade.filter.type");
        if (filterName != null) {
            try {
                Class filterClass = settings.getSettingAsClass("compass.cascade.filter.type", CompassCascadeFilter.class);
                this.cascadeFilter = (CompassCascadeFilter)filterClass.newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to create cascade filter of class " + filterName, e);
            }
        }
    }

    public boolean cascade(Object root, CascadeMapping.Cascade cascade) throws CompassException {
        if (this.cascadingDisabled()) {
            return false;
        }
        if (root instanceof AliasedObject) {
            return this.cascade(((AliasedObject)root).getAlias(), root, cascade);
        }
        return this.cascade(root.getClass(), root, cascade);
    }

    public boolean cascade(String alias, Object root, CascadeMapping.Cascade cascade) throws CompassException {
        if (this.cascadingDisabled()) {
            return false;
        }
        ResourceMapping resourceMapping = this.mapping.getMappingByAlias(alias);
        return resourceMapping != null && this.cascade(resourceMapping, root, cascade);
    }

    public boolean cascade(Class clazz, Object root, CascadeMapping.Cascade cascade) throws CompassException {
        if (this.cascadingDisabled()) {
            return false;
        }
        ResourceMapping resourceMapping = this.mapping.getMappingByClass(clazz);
        return resourceMapping != null && this.cascade(resourceMapping, root, cascade);
    }

    private boolean cascade(ResourceMapping resourceMapping, Object root, CascadeMapping.Cascade cascade) throws CompassException {
        if (this.cascadingDisabled()) {
            return false;
        }
        CascadeMapping[] cascadeMappings = resourceMapping.getCascadeMappings();
        if (cascadeMappings == null) {
            return false;
        }
        boolean retVal = false;
        for (CascadeMapping cascadeMapping : cascadeMappings) {
            if (!cascadeMapping.shouldCascade(cascade)) continue;
            retVal = true;
            Object value = cascadeMapping.getCascadeValue(root);
            if (value == null) continue;
            if (value instanceof Object[]) {
                int length = Array.getLength(value);
                for (int j = 0; j < length; ++j) {
                    this.cascadeOperation(cascade, Array.get(value, j));
                }
                continue;
            }
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    this.cascadeOperation(cascade, o);
                }
                continue;
            }
            this.cascadeOperation(cascade, value);
        }
        return retVal;
    }

    private void cascadeOperation(CascadeMapping.Cascade cascade, Object value) {
        if (value == null) {
            return;
        }
        if (cascade == CascadeMapping.Cascade.DELETE) {
            if (this.cascadeFilter != null && this.cascadeFilter.shouldFilterDelete(value)) {
                return;
            }
            this.session.delete(value);
        } else if (cascade == CascadeMapping.Cascade.CREATE) {
            if (this.cascadeFilter != null && this.cascadeFilter.shouldFilterCreate(value)) {
                return;
            }
            this.session.create(value);
        } else if (cascade == CascadeMapping.Cascade.SAVE) {
            if (this.cascadeFilter != null && this.cascadeFilter.shouldFilterSave(value)) {
                return;
            }
            this.session.save(value);
        } else {
            throw new IllegalArgumentException("Failed to perform cascading unknown type [" + cascade + "]");
        }
    }

    private boolean cascadingDisabled() {
        return this.session.getSettings().getSettingAsBoolean("compass.cascade.disable", false);
    }
}

