/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.Directory;
import org.compass.core.executor.ExecutorManager;
import org.compass.core.transaction.context.TransactionContext;
import org.compass.core.transaction.context.TransactionalRunnable;

public class ExecutorMergeScheduler
extends MergeScheduler {
    private ExecutorManager executorManager;
    private TransactionContext transactionContext;
    private volatile int currentConcurrentMerges = 0;
    private volatile int maxConcurrentMerges = 3;
    private Directory dir;
    private boolean closed;
    private IndexWriter writer;
    static boolean anyExceptions = false;
    private boolean suppressExceptions;

    public ExecutorMergeScheduler(ExecutorManager executorManager, TransactionContext transactionContext) {
        this.executorManager = executorManager;
        this.transactionContext = transactionContext;
    }

    public int getMaxConcurrentMerges() {
        return this.maxConcurrentMerges;
    }

    public void setMaxConcurrentMerges(int maxConcurrentMerges) {
        this.maxConcurrentMerges = maxConcurrentMerges;
    }

    private void message(String message) {
        if (this.writer != null) {
            this.writer.message("EMS: " + message);
        }
    }

    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(IndexWriter writer) throws CorruptIndexException, IOException {
        this.writer = writer;
        this.dir = writer.getDirectory();
        this.message("now merge");
        this.message("  index: " + writer.segString());
        while (true) {
            MergePolicy.OneMerge merge;
            if ((merge = writer.getNextMerge()) == null) {
                this.message("  no more merges pending; now return");
                return;
            }
            writer.mergeInit(merge);
            this.message("  consider merge " + merge.segString(this.dir));
            if (merge.isExternal) {
                this.message("    merge involves segments from an external directory; now run in foreground");
            } else {
                ExecutorMergeScheduler executorMergeScheduler = this;
                synchronized (executorMergeScheduler) {
                    if (this.currentConcurrentMerges < this.maxConcurrentMerges) {
                        ++this.currentConcurrentMerges;
                        MergeThread merger = new MergeThread(writer, merge);
                        this.executorManager.submit(new TransactionalRunnable(this.transactionContext, merger));
                        this.message("    executed merge in executor manager");
                        continue;
                    }
                    this.message("    too many merge threads running; run merge in foreground");
                }
            }
            writer.merge(merge);
        }
    }

    void setSuppressExceptions() {
        this.suppressExceptions = true;
    }

    void clearSuppressExceptions() {
        this.suppressExceptions = false;
    }

    private class MergeThread
    implements Runnable {
        IndexWriter writer;
        MergePolicy.OneMerge startMerge;
        MergePolicy.OneMerge runningMerge;

        public MergeThread(IndexWriter writer, MergePolicy.OneMerge startMerge) throws IOException {
            this.writer = writer;
            this.startMerge = startMerge;
        }

        public synchronized void setRunningMerge(MergePolicy.OneMerge merge) {
            this.runningMerge = merge;
        }

        public synchronized MergePolicy.OneMerge getRunningMerge() {
            return this.runningMerge;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MergePolicy.OneMerge merge = this.startMerge;
            if (this.runningMerge != null) {
                merge = this.runningMerge;
            }
            try {
                ExecutorMergeScheduler.this.message("  merge thread: start");
                this.setRunningMerge(merge);
                this.writer.merge(merge);
                merge = this.writer.getNextMerge();
                if (merge != null) {
                    this.writer.mergeInit(merge);
                    ExecutorMergeScheduler.this.message("  merge thread: do another merge " + merge.segString(ExecutorMergeScheduler.this.dir));
                    this.setRunningMerge(merge);
                    ExecutorMergeScheduler.this.executorManager.submit(new TransactionalRunnable(ExecutorMergeScheduler.this.transactionContext, this));
                } else {
                    ExecutorMergeScheduler.this.currentConcurrentMerges--;
                }
                ExecutorMergeScheduler.this.message("  merge thread: done");
            }
            catch (Throwable exc) {
                if (merge != null) {
                    merge.setException(exc);
                    this.writer.addMergeException(merge);
                }
                if (!(exc instanceof MergePolicy.MergeAbortedException) && !ExecutorMergeScheduler.this.suppressExceptions) {
                    anyExceptions = true;
                    throw new MergePolicy.MergeException(exc);
                }
            }
            finally {
                if (merge == null) {
                    ExecutorMergeScheduler executorMergeScheduler = ExecutorMergeScheduler.this;
                    synchronized (executorMergeScheduler) {
                    }
                }
            }
        }

        public String toString() {
            MergePolicy.OneMerge merge = this.getRunningMerge();
            if (merge == null) {
                merge = this.startMerge;
            }
            return "merge thread: " + merge.segString(ExecutorMergeScheduler.this.dir);
        }
    }
}

