/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.transport.handlers.utils;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfigUtils;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;

public class RequestProcessorDispatcherUtil {
    private static final Log log = LogFactory.getLog(RequestProcessorDispatcherUtil.class);

    public static boolean isDispatchToApiGetProcessor(String requestUri, ConfigurationContext configurationContext) {
        boolean foundNewTenant = false;
        String apiName = null;
        String tenantDomain = "carbon.super";
        String pathSeparator = "/";
        if (requestUri.contains(pathSeparator + "t" + pathSeparator)) {
            String[] paths = requestUri.split(pathSeparator);
            boolean foundTenantDelimiter = false;
            for (String pathString : paths) {
                if (!foundTenantDelimiter && "t".equals(pathString)) {
                    foundTenantDelimiter = true;
                    continue;
                }
                if (foundTenantDelimiter && "carbon.super".equals(tenantDomain)) {
                    tenantDomain = pathString;
                    foundNewTenant = true;
                    continue;
                }
                if (!foundNewTenant) continue;
                apiName = pathString;
                break;
            }
        } else {
            apiName = requestUri.substring(1);
        }
        if (apiName != null) {
            if (foundNewTenant) {
                TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)configurationContext);
            }
            if (SynapseConfigUtils.getSynapseConfiguration((String)tenantDomain).getAPI(apiName) != null) {
                return true;
            }
        }
        return false;
    }
}

