/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisResource;
import org.apache.axis2.description.AxisResourceMap;
import org.apache.axis2.description.AxisResourceParameter;
import org.apache.axis2.description.AxisResources;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediation.commons.rest.api.swagger.ServerConfig;
import org.wso2.carbon.mediation.registry.RegistryServiceHolder;
import org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format.CarbonServerConfig;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public final class SwaggerUtils {
    static final String PROTOCOL_HTTP = "http";
    static final String PROTOCOL_HTTPS = "https";
    public static final String DATA_TYPE_INTEGER = "integer";
    public static final String DATA_TYPE_NUMBER = "number";
    public static final String DATA_TYPE_BOOLEAN = "boolean";
    private static Log logger = LogFactory.getLog((String)SwaggerUtils.class.getName());

    public static String getDataServiceSwagger(String requestURI, ConfigurationContext configurationContext, boolean isJSON) throws AxisFault {
        AxisService dataService;
        String dataServiceName = requestURI.substring(requestURI.lastIndexOf("/") + 1);
        String tenantDomain = MultitenantUtils.getTenantDomainFromRequestURL((String)requestURI);
        if (tenantDomain != null) {
            ConcurrentHashMap contextConcurrentHashMap = (ConcurrentHashMap)configurationContext.getProperty("tenant.config.contexts");
            ConfigurationContext tenantConfigContext = (ConfigurationContext)contextConcurrentHashMap.get(tenantDomain);
            dataService = tenantConfigContext.getAxisConfiguration().getService(dataServiceName);
        } else {
            dataService = configurationContext.getAxisConfiguration().getService(dataServiceName);
        }
        if (dataService != null) {
            CarbonServerConfig serverConfig = new CarbonServerConfig();
            Object dataServiceObject = dataService.getParameter("org.wso2.ws.dataservice.dataservice.obj").getValue();
            if (dataService.getParameter("org.wso2.ws.dataservice.dataservice.swagger.path") != null) {
                String swaggerLocation = (String)dataService.getParameter("org.wso2.ws.dataservice.dataservice.swagger.path").getValue();
                if (swaggerLocation != null && !swaggerLocation.isEmpty()) {
                    try {
                        return SwaggerUtils.fetchSwaggerFromRegistry(requestURI, swaggerLocation);
                    }
                    catch (RegistryException e) {
                        logger.error((Object)"Error occurred while fetching swagger from the registry", (Throwable)e);
                    }
                }
            } else {
                List transports = dataService.getExposedTransports();
                if (dataServiceObject instanceof AxisResources) {
                    AxisResourceMap axisResourceMap = ((AxisResources)dataServiceObject).getAxisResourceMap();
                    return SwaggerUtils.createSwaggerFromDefinition(axisResourceMap, dataServiceName, transports, serverConfig, isJSON);
                }
            }
            return null;
        }
        return null;
    }

    private static String createSwaggerFromDefinition(AxisResourceMap axisResourceMap, String dataServiceName, List<String> transports, ServerConfig serverConfig, boolean isJSON) throws AxisFault {
        OpenAPI openAPI = new OpenAPI();
        Info info = new Info();
        info.title(dataServiceName);
        info.setVersion("1.0");
        info.description("API Definition of dataservice : " + dataServiceName);
        openAPI.setInfo(info);
        SwaggerUtils.addServersSection(dataServiceName, transports, serverConfig, openAPI);
        Paths paths = new Paths();
        for (Map.Entry entry : axisResourceMap.getResources().entrySet()) {
            PathItem pathItem = new PathItem();
            for (String method : ((AxisResource)entry.getValue()).getMethods()) {
                Operation operation = new Operation();
                List parameterList = ((AxisResource)entry.getValue()).getResourceParameterList(method);
                SwaggerUtils.addPathAndQueryParameters(method, operation, parameterList);
                SwaggerUtils.addSampleRequestBody(method, operation, parameterList);
                SwaggerUtils.addDefaultResponseAndPathItem(pathItem, method, operation);
            }
            paths.put((Object)(((String)entry.getKey()).startsWith("/") ? (String)entry.getKey() : "/" + (String)entry.getKey()), (Object)pathItem);
        }
        openAPI.setPaths(paths);
        try {
            if (isJSON) {
                return Json.mapper().writeValueAsString((Object)openAPI);
            }
            return Yaml.mapper().writeValueAsString((Object)openAPI);
        }
        catch (JsonProcessingException e) {
            logger.error((Object)"Error occurred while creating the YAML configuration", (Throwable)e);
            return null;
        }
    }

    private static void addSampleRequestBody(String method, Operation operation, List<AxisResourceParameter> parameterList) {
        if (!method.equals("GET") && !method.equals("DELETE")) {
            RequestBody requestBody = new RequestBody();
            requestBody.description("Sample Payload");
            requestBody.setRequired(Boolean.valueOf(false));
            MediaType mediaType = new MediaType();
            Schema bodySchema = new Schema();
            bodySchema.setType("object");
            HashMap<String, ObjectSchema> inputProperties = new HashMap<String, ObjectSchema>();
            ObjectSchema objectSchema = new ObjectSchema();
            HashMap<String, Object> payloadProperties = new HashMap<String, Object>();
            block10: for (AxisResourceParameter resourceParameter : parameterList) {
                switch (resourceParameter.getParameterDataType()) {
                    case "integer": {
                        payloadProperties.put(resourceParameter.getParameterName(), new IntegerSchema());
                        continue block10;
                    }
                    case "number": {
                        payloadProperties.put(resourceParameter.getParameterName(), new NumberSchema());
                        continue block10;
                    }
                    case "boolean": {
                        payloadProperties.put(resourceParameter.getParameterName(), new BooleanSchema());
                        continue block10;
                    }
                }
                payloadProperties.put(resourceParameter.getParameterName(), new StringSchema());
            }
            objectSchema.setProperties(payloadProperties);
            bodySchema.setProperties(inputProperties);
            inputProperties.put("payload", objectSchema);
            mediaType.setSchema(bodySchema);
            Content content = new Content();
            content.addMediaType("application/json", mediaType);
            requestBody.setContent(content);
            operation.setRequestBody(requestBody);
        }
    }

    private static void addPathAndQueryParameters(String method, Operation operation, List<AxisResourceParameter> parameterList) {
        if (!parameterList.isEmpty()) {
            for (AxisResourceParameter resourceParameter : parameterList) {
                AxisResourceParameter.ParameterType resourceParameterType = resourceParameter.getParameterType();
                if (resourceParameterType.equals((Object)AxisResourceParameter.ParameterType.URL_PARAMETER)) {
                    PathParameter pathParameter = new PathParameter();
                    pathParameter.setName(resourceParameter.getParameterName());
                    switch (resourceParameter.getParameterDataType()) {
                        case "integer": {
                            pathParameter.setSchema((Schema)new IntegerSchema());
                            break;
                        }
                        case "number": {
                            pathParameter.setSchema((Schema)new NumberSchema());
                            break;
                        }
                        case "boolean": {
                            pathParameter.setSchema((Schema)new BooleanSchema());
                            break;
                        }
                        default: {
                            pathParameter.setSchema((Schema)new StringSchema());
                        }
                    }
                    pathParameter.required(Boolean.valueOf(true));
                    operation.addParametersItem((Parameter)pathParameter);
                    continue;
                }
                if (!resourceParameterType.equals((Object)AxisResourceParameter.ParameterType.QUERY_PARAMETER) || !method.equals("GET")) continue;
                QueryParameter queryParameter = new QueryParameter();
                queryParameter.setName(resourceParameter.getParameterName());
                switch (resourceParameter.getParameterDataType()) {
                    case "integer": {
                        queryParameter.setSchema((Schema)new IntegerSchema());
                        break;
                    }
                    case "number": {
                        queryParameter.setSchema((Schema)new NumberSchema());
                        break;
                    }
                    case "boolean": {
                        queryParameter.setSchema((Schema)new BooleanSchema());
                        break;
                    }
                    default: {
                        queryParameter.setSchema((Schema)new StringSchema());
                    }
                }
                queryParameter.required(Boolean.valueOf(true));
                operation.addParametersItem((Parameter)queryParameter);
            }
        }
    }

    private static void addDefaultResponseAndPathItem(PathItem pathItem, String method, Operation operation) {
        ApiResponses apiResponses = new ApiResponses();
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setDescription("Default response");
        apiResponses.addApiResponse("default", apiResponse);
        operation.setResponses(apiResponses);
        switch (method) {
            case "GET": {
                pathItem.setGet(operation);
                break;
            }
            case "POST": {
                pathItem.setPost(operation);
                break;
            }
            case "DELETE": {
                pathItem.setDelete(operation);
                break;
            }
            case "PUT": {
                pathItem.setPut(operation);
            }
        }
    }

    private static void addServersSection(String dataServiceName, List<String> transports, ServerConfig serverConfig, OpenAPI openAPI) throws AxisFault {
        String host;
        String scheme;
        if (transports.contains(PROTOCOL_HTTPS)) {
            scheme = PROTOCOL_HTTPS;
            host = serverConfig.getHost(PROTOCOL_HTTPS);
        } else {
            scheme = PROTOCOL_HTTP;
            host = serverConfig.getHost(PROTOCOL_HTTP);
        }
        String basePath = "/services/" + dataServiceName;
        Server server = new Server();
        server.setUrl(scheme + "://" + host + basePath);
        openAPI.setServers(Arrays.asList(server));
    }

    public static String fetchSwaggerFromRegistry(String requestURI, String resourcePath) throws RegistryException {
        boolean isSwaggerInConfReg = true;
        if (resourcePath.startsWith("conf:")) {
            resourcePath = resourcePath.substring(5);
        } else {
            resourcePath = resourcePath.substring(4);
            isSwaggerInConfReg = false;
        }
        RegistryService registryService = RegistryServiceHolder.getInstance().getRegistryService();
        String defString = null;
        String tenantDomain = MultitenantUtils.getTenantDomainFromRequestURL((String)requestURI);
        tenantDomain = tenantDomain != null ? tenantDomain : "carbon.super";
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        UserRegistry registry = isSwaggerInConfReg ? registryService.getConfigSystemRegistry(tenantId) : registryService.getGovernanceSystemRegistry(tenantId);
        if (registry.resourceExists(resourcePath)) {
            Resource resource = registry.get(resourcePath);
            if (resource.getContent() != null && resource.getContent() instanceof byte[] && ((byte[])resource.getContent()).length > 0) {
                defString = new String((byte[])resource.getContent(), Charset.defaultCharset());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieving swagger definition form registry path : " + resourcePath + " with definition: " + defString));
            }
        }
        return defString;
    }
}

