/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.api.API;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.integrator.core.json.utils.GSONUtils;
import org.wso2.carbon.mediation.commons.rest.api.swagger.OpenAPIProcessor;
import org.wso2.carbon.mediation.commons.rest.api.swagger.ServerConfig;
import org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format.CarbonServerConfig;
import org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format.SwaggerGenerator;
import org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format.utils.SwaggerUtils;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.yaml.snakeyaml.Yaml;

public class SwaggerYamlProcessor
extends SwaggerGenerator
implements HttpGetRequestProcessor {
    private static final Log log = LogFactory.getLog(SwaggerYamlProcessor.class);

    public void process(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configurationContext) throws AxisFault {
        API api = this.getAPIFromSynapseConfig(request);
        String responseString = null;
        if (api != null) {
            responseString = this.processAPI(request, api);
        } else if (request.getContextPath().contains("/services")) {
            responseString = SwaggerUtils.getDataServiceSwagger(request.getRequestURI(), configurationContext, false);
        } else {
            this.handleException(request.getRequestURI());
        }
        if (responseString != null && !responseString.isEmpty()) {
            this.updateResponse(response, responseString, "application/x-yaml");
        } else {
            this.handleException(request.getRequestURI());
        }
    }

    private String processAPI(CarbonHttpRequest request, API api) throws AxisFault {
        String responseString;
        try {
            Yaml yamlDefinition = new Yaml();
            String defFromRegistry = this.retrieveAPISwaggerFromRegistry(api, request.getRequestURI());
            if (defFromRegistry != null) {
                JsonParser jsonParser = new JsonParser();
                responseString = yamlDefinition.dumpAsMap((Object)GSONUtils.gsonJsonObjectToMap((JsonElement)jsonParser.parse(defFromRegistry)));
            } else {
                CarbonServerConfig serverConfig = new CarbonServerConfig();
                OpenAPIProcessor openAPIProcessor = new OpenAPIProcessor(api, (ServerConfig)serverConfig);
                responseString = openAPIProcessor.getOpenAPISpecification(false);
            }
        }
        catch (RegistryException e) {
            throw new AxisFault("Error occurred while retrieving swagger definition from registry", (Throwable)e);
        }
        return responseString;
    }
}

