/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.api.API;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.mediation.commons.rest.api.swagger.OpenAPIProcessor;
import org.wso2.carbon.mediation.commons.rest.api.swagger.ServerConfig;
import org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format.CarbonServerConfig;
import org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format.SwaggerGenerator;
import org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format.utils.SwaggerUtils;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class SwaggerJsonProcessor
extends SwaggerGenerator
implements HttpGetRequestProcessor {
    Log log = LogFactory.getLog(SwaggerJsonProcessor.class);

    public void process(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configurationContext) throws AxisFault {
        API api = this.getAPIFromSynapseConfig(request);
        String responseString = null;
        if (api != null) {
            responseString = this.processAPI(api, request);
        } else if (request.getContextPath().contains("/services")) {
            responseString = SwaggerUtils.getDataServiceSwagger(request.getRequestURI(), configurationContext, true);
        } else {
            this.handleException(request.getRequestURI());
        }
        if (responseString != null && !responseString.isEmpty()) {
            this.updateResponse(response, responseString, "application/json");
        } else {
            this.handleException(request.getRequestURI());
        }
    }

    private String processAPI(API api, CarbonHttpRequest request) throws AxisFault {
        CarbonServerConfig serverConfig = new CarbonServerConfig();
        try {
            String responseString = this.retrieveAPISwaggerFromRegistry(api, request.getRequestURI());
            if (responseString == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Generating swagger definition for: " + api.getName()));
                }
                OpenAPIProcessor openAPIProcessor = new OpenAPIProcessor(api, (ServerConfig)serverConfig);
                responseString = openAPIProcessor.getOpenAPISpecification(true);
            }
            return responseString;
        }
        catch (RegistryException e) {
            throw new AxisFault("Error occurred while retrieving swagger definition from registry", (Throwable)e);
        }
    }
}

