/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.axiom.ext.io.StreamCopyException;
import org.apache.axiom.util.blob.BlobOutputStream;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.api.API;
import org.apache.synapse.api.version.DefaultStrategy;
import org.apache.synapse.config.SynapseConfigUtils;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.mediation.commons.rest.api.swagger.SwaggerConstants;
import org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.format.utils.SwaggerUtils;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class SwaggerGenerator {
    private static final Log log = LogFactory.getLog(SwaggerGenerator.class);

    protected void updateResponse(CarbonHttpResponse response, String responseString, String contentType) throws AxisFault {
        try {
            ((BlobOutputStream)response.getOutputStream()).getBlob().readFrom((InputStream)new ByteArrayInputStream(responseString.getBytes("UTF-8")), (long)responseString.length());
        }
        catch (StreamCopyException streamCopyException) {
            this.handleException("Error in generating Swagger definition : failed to copy data to response ", (Exception)((Object)streamCopyException));
        }
        catch (UnsupportedEncodingException encodingException) {
            this.handleException("Error in generating Swagger definition : exception in encoding ", encodingException);
        }
        response.setStatus(200);
        response.getHeaders().put("Content-Type", contentType);
    }

    protected API getAPIFromSynapseConfig(CarbonHttpRequest request) {
        String tenantDomain = MultitenantUtils.getTenantDomainFromRequestURL((String)request.getRequestURI());
        String apiName = this.getApiNameFromRequestUri(request.getRequestURI());
        return SynapseConfigUtils.getSynapseConfiguration((String)(tenantDomain != null ? tenantDomain : "carbon.super")).getAPI(apiName);
    }

    protected String getApiNameFromRequestUri(String requestUri) {
        String tenantDomain = "carbon.super";
        String pathSeparator = "/";
        String apiName = null;
        if (requestUri.contains(pathSeparator + "t" + pathSeparator)) {
            String[] paths = requestUri.split(pathSeparator);
            boolean foundTenantDelimiter = false;
            boolean foundNewTenant = false;
            for (String pathString : paths) {
                if (!foundTenantDelimiter && "t".equals(pathString)) {
                    foundTenantDelimiter = true;
                    continue;
                }
                if (foundTenantDelimiter && "carbon.super".equals(tenantDomain)) {
                    tenantDomain = pathString;
                    foundNewTenant = true;
                    continue;
                }
                if (!foundNewTenant) continue;
                apiName = pathString;
                break;
            }
        } else {
            apiName = requestUri.substring(1);
        }
        return apiName;
    }

    protected String retrieveAPISwaggerFromRegistry(API api, String requestURI) throws RegistryException {
        String resourcePath = api.getSwaggerResourcePath();
        if (resourcePath == null) {
            StringBuilder resourcePathBuilder = new StringBuilder();
            resourcePathBuilder.append(SwaggerConstants.DEFAULT_SWAGGER_REGISTRY_PATH).append(api.getAPIName());
            if (!(api.getVersionStrategy() instanceof DefaultStrategy)) {
                resourcePathBuilder.append(":v").append(api.getVersion());
            }
            resourcePathBuilder.append("/swagger.json");
            resourcePath = "conf:" + resourcePathBuilder.toString();
        }
        return SwaggerUtils.fetchSwaggerFromRegistry(requestURI, resourcePath);
    }

    private void handleException(String errorMsg, Exception exception) throws AxisFault {
        log.error((Object)errorMsg);
        throw new AxisFault(errorMsg, (Throwable)exception);
    }

    protected void handleException(String errorMsg) throws AxisFault {
        log.error((Object)errorMsg);
        throw new AxisFault(errorMsg);
    }
}

