/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.api.API;
import org.apache.synapse.api.Resource;
import org.apache.synapse.api.dispatch.DispatcherHelper;
import org.apache.synapse.api.dispatch.URLMappingBasedDispatcher;
import org.wso2.carbon.mediation.transport.handlers.requestprocessors.swagger.SwaggerConstants;

@Deprecated
public class GenericApiObjectDefinition {
    private static final Log log = LogFactory.getLog(GenericApiObjectDefinition.class);
    private API api;

    public GenericApiObjectDefinition(API api) {
        this.api = api;
    }

    public Map<String, Object> getDefinitionMap() {
        LinkedHashMap<String, Object> apiMap = new LinkedHashMap<String, Object>();
        apiMap.put("swagger", "2.0");
        apiMap.put("info", this.getInfoMap());
        if (this.api.getHost() != null) {
            apiMap.put("host", this.api.getHost());
        }
        apiMap.put("basePath", this.api.getContext());
        apiMap.put("schemes", this.getSchemes());
        if (this.getPathMap() != null && !this.getPathMap().isEmpty()) {
            apiMap.put("paths", this.getPathMap());
        }
        return apiMap;
    }

    private Map<String, Object> getResponsesMap() {
        LinkedHashMap<String, Object> responsesMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> responseDetailsMap = new LinkedHashMap<String, String>();
        responseDetailsMap.put("description", "Default Response");
        responsesMap.put("default", responseDetailsMap);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response map created with size " + responsesMap.size()));
        }
        return responsesMap;
    }

    private Map<String, Object> getInfoMap() {
        LinkedHashMap<String, Object> infoMap = new LinkedHashMap<String, Object>();
        infoMap.put("description", "API Definition of " + this.api.getAPIName());
        infoMap.put("title", this.api.getName());
        infoMap.put("version", this.api.getVersion() != null && !this.api.getVersion().equals("") ? this.api.getVersion() : "1.0.0");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Info map created with size " + infoMap.size()));
        }
        return infoMap;
    }

    private Map<String, Object> getPathMap() {
        LinkedHashMap<String, Object> pathsMap = new LinkedHashMap<String, Object>();
        for (Resource resource : this.api.getResources()) {
            LinkedHashMap methodMap = new LinkedHashMap();
            DispatcherHelper resourceDispatcherHelper = resource.getDispatcherHelper();
            for (String method : resource.getMethods()) {
                Object[] parameters;
                if (method == null) continue;
                LinkedHashMap<String, Object> methodInfoMap = new LinkedHashMap<String, Object>();
                methodInfoMap.put("responses", this.getResponsesMap());
                if (resourceDispatcherHelper != null && (parameters = this.getResourceParameters(resource)).length > 0) {
                    methodInfoMap.put("parameters", parameters);
                }
                methodMap.put(method.toLowerCase(), methodInfoMap);
            }
            pathsMap.put(this.getPathFromUrl(resourceDispatcherHelper == null ? "/" : resourceDispatcherHelper.getString()), methodMap);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Paths map created with size " + pathsMap.size()));
        }
        return pathsMap;
    }

    private String[] getSchemes() {
        String[] protocols;
        switch (this.api.getProtocol()) {
            case 1: {
                protocols = new String[]{"http"};
                break;
            }
            case 2: {
                protocols = new String[]{"https"};
                break;
            }
            default: {
                protocols = new String[]{"http", "https"};
            }
        }
        return protocols;
    }

    private Object[] getResourceParameters(Resource resource) {
        ArrayList<Map<String, Object>> parameterList = new ArrayList<Map<String, Object>>();
        String uri = resource.getDispatcherHelper().getString();
        if (resource.getDispatcherHelper() instanceof URLMappingBasedDispatcher) {
            this.generateParameterList(parameterList, uri, false);
        } else {
            this.generateParameterList(parameterList, uri, true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameters processed for the URI + " + uri + " size " + parameterList.size()));
        }
        return parameterList.toArray();
    }

    private void generateParameterList(ArrayList<Map<String, Object>> parameterList, String uriString, boolean generateBothTypes) {
        if (uriString == null) {
            return;
        }
        if (generateBothTypes) {
            String[] params;
            for (String parameter : params = this.getQueryStringFromUrl(uriString).split("&")) {
                int pos;
                if (parameter == null || (pos = parameter.indexOf(61)) <= 0) continue;
                parameterList.add(this.getParametersMap(parameter.substring(0, pos), "query"));
            }
        }
        Matcher matcher = SwaggerConstants.PATH_PARAMETER_PATTERN.matcher(this.getPathFromUrl(uriString));
        while (matcher.find()) {
            parameterList.add(this.getParametersMap(matcher.group(1), "path"));
        }
    }

    private Map<String, Object> getParametersMap(String parameterName, String parameterType) {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        parameterMap.put("description", parameterName);
        parameterMap.put("in", parameterType);
        parameterMap.put("name", parameterName);
        parameterMap.put("required", true);
        parameterMap.put("type", "string");
        return parameterMap;
    }

    private String getPathFromUrl(String uri) {
        int pos = uri.indexOf("?");
        if (pos > 0) {
            return uri.substring(0, pos);
        }
        return uri;
    }

    private String getQueryStringFromUrl(String uri) {
        int pos = uri.indexOf("?");
        if (pos > 0) {
            return uri.substring(pos + 1);
        }
        return "";
    }
}

