/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.transport.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.passthru.HttpGetRequestProcessor;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.SourceHandler;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.w3c.dom.Element;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.mediation.transport.handlers.DataHolder;
import org.wso2.carbon.mediation.transport.handlers.utils.RequestProcessorDispatcherUtil;

public class PassThroughNHttpGetProcessor
implements HttpGetRequestProcessor {
    private Map<String, org.wso2.carbon.core.transports.HttpGetRequestProcessor> getRequestProcessors = new LinkedHashMap<String, org.wso2.carbon.core.transports.HttpGetRequestProcessor>();
    private ConfigurationContext cfgCtx;
    private SourceHandler sourceHandler;
    private static final QName ITEM_QN = new QName("http://wso2.org/projects/carbon/carbon.xml", "Item");
    private static final QName CLASS_QN = new QName("http://wso2.org/projects/carbon/carbon.xml", "Class");
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_HTML = "text/html";
    private static final Log log = LogFactory.getLog(PassThroughNHttpGetProcessor.class);

    private void populateGetRequestProcessors() throws AxisFault {
        try {
            OMElement docEle = XMLUtils.toOM((Element)ServerConfiguration.getInstance().getDocumentElement());
            if (docEle != null) {
                SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
                nsCtx.addNamespace("wsas", "http://wso2.org/projects/carbon/carbon.xml");
                AXIOMXPath xp = new AXIOMXPath("//wsas:HttpGetRequestProcessors/wsas:Processor");
                xp.setNamespaceContext((NamespaceContext)nsCtx);
                List nodeList = xp.selectNodes((Object)docEle);
                for (Object aNodeList : nodeList) {
                    OMElement processorEle = (OMElement)aNodeList;
                    OMElement itemEle = processorEle.getFirstChildWithName(ITEM_QN);
                    if (itemEle == null) {
                        throw new ServletException("Required element, 'Item' not found!");
                    }
                    OMElement classEle = processorEle.getFirstChildWithName(CLASS_QN);
                    if (classEle == null) {
                        throw new ServletException("Required element, 'Class' not found!");
                    }
                    org.wso2.carbon.core.transports.HttpGetRequestProcessor processor = (org.wso2.carbon.core.transports.HttpGetRequestProcessor)Class.forName(classEle.getText().trim()).newInstance();
                    this.getRequestProcessors.put(itemEle.getText().trim(), processor);
                }
            }
        }
        catch (Exception e) {
            this.handleException("Error populating GetRequestProcessors", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWithGetProcessor(HttpRequest request, HttpResponse response, String requestUri, String requestUrl, String queryString, String item, OutputStream outputStream, NHttpServerConnection conn) throws Exception {
        OverflowBlob temporaryData = new OverflowBlob(256, 4048, "_nhttp", ".dat");
        try {
            CarbonHttpRequest carbonHttpRequest = new CarbonHttpRequest("GET", requestUri, requestUrl);
            String uri = request.getRequestLine().getUri();
            int pos = uri.indexOf("?");
            if (pos != -1) {
                StringTokenizer st = new StringTokenizer(uri.substring(pos + 1), "&");
                while (st.hasMoreTokens()) {
                    String param = st.nextToken();
                    pos = param.indexOf("=");
                    if (pos != -1) {
                        carbonHttpRequest.setParameter(param.substring(0, pos), param.substring(pos + 1));
                        continue;
                    }
                    carbonHttpRequest.setParameter(param, null);
                }
            }
            carbonHttpRequest.setContextPath(this.cfgCtx.getServiceContextPath());
            carbonHttpRequest.setQueryString(queryString);
            CarbonHttpResponse carbonHttpResponse = new CarbonHttpResponse((OutputStream)temporaryData.getOutputStream());
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(TenantAxisUtils.getTenantDomain((String)requestUrl), true);
                this.getRequestProcessors.get(item).process(carbonHttpRequest, carbonHttpResponse, this.cfgCtx);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
            Map responseHeaderMap = carbonHttpResponse.getHeaders();
            for (Object key : responseHeaderMap.keySet()) {
                Object value = responseHeaderMap.get(key);
                response.addHeader(key.toString(), value.toString());
            }
            response.setStatusCode(carbonHttpResponse.getStatusCode());
            if (carbonHttpResponse.isError()) {
                if (carbonHttpResponse.getStatusMessage() != null) {
                    response.setStatusLine(response.getProtocolVersion(), carbonHttpResponse.getStatusCode(), carbonHttpResponse.getStatusMessage());
                } else {
                    response.setStatusLine(response.getProtocolVersion(), carbonHttpResponse.getStatusCode());
                }
            }
            if (carbonHttpResponse.isRedirect()) {
                response.addHeader("Location", carbonHttpResponse.getRedirect());
                response.setStatusLine(response.getProtocolVersion(), 302);
            }
            SourceContext.updateState((NHttpConnection)conn, (ProtocolState)ProtocolState.WSDL_RESPONSE_DONE);
            try {
                temporaryData.writeTo(outputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            temporaryData.release();
            this.sourceHandler.commitResponseHideExceptions(conn, response);
        }
    }

    public void init(ConfigurationContext configurationContext, SourceHandler sourceHandler) throws AxisFault {
        this.cfgCtx = configurationContext;
        this.sourceHandler = sourceHandler;
        DataHolder.getInstance().setAxisConfigurationContext(configurationContext);
        if (this.cfgCtx.getProperty("GETRequestProcessorMap") != null) {
            this.getRequestProcessors = (Map)this.cfgCtx.getProperty("GETRequestProcessorMap");
        } else {
            this.populateGetRequestProcessors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpRequest request, HttpResponse response, MessageContext messageContext, NHttpServerConnection conn, OutputStream outputStream, boolean b) {
        boolean isRequestHandled = false;
        String uri = request.getRequestLine().getUri();
        String servicePath = this.cfgCtx.getServiceContextPath();
        if (!servicePath.startsWith("/")) {
            servicePath = "/" + servicePath;
        }
        String serviceName = this.getServiceName(request);
        boolean loadBalancer = Boolean.parseBoolean(System.getProperty("wso2.loadbalancer", "false"));
        if (uri.equals("/favicon.ico")) {
            response.setStatusCode(301);
            response.addHeader("Location", "http://wso2.org/favicon.ico");
            SourceContext.updateState((NHttpConnection)conn, (ProtocolState)ProtocolState.WSDL_RESPONSE_DONE);
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sourceHandler.commitResponseHideExceptions(conn, response);
            isRequestHandled = true;
        } else if (uri.startsWith(servicePath) && (serviceName == null || serviceName.length() == 0)) {
            if (this.isServiceListBlocked(uri)) {
                response.setStatusCode(403);
            } else {
                this.generateServicesList(response, conn, outputStream, servicePath);
                messageContext.setProperty("WSDL_GEN_HANDLED", (Object)true);
            }
            SourceContext.updateState((NHttpConnection)conn, (ProtocolState)ProtocolState.WSDL_RESPONSE_DONE);
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.sourceHandler.commitResponseHideExceptions(conn, response);
            }
            isRequestHandled = true;
        } else {
            int pos = uri.indexOf(63);
            if (pos != -1) {
                String queryString = uri.substring(pos + 1);
                String requestUri = uri.substring(0, pos);
                String requestUrl = uri;
                if (requestUri.indexOf("://") == -1) {
                    HttpInetConnection inetConn = (HttpInetConnection)conn;
                    String hostName = "localhost";
                    ServerConfiguration serverConfig = ServerConfiguration.getInstance();
                    if (serverConfig.getFirstProperty("HostName") != null) {
                        hostName = serverConfig.getFirstProperty("HostName");
                    }
                    requestUrl = "http://" + hostName + ":" + inetConn.getLocalPort() + requestUri;
                }
                String contextPath = this.cfgCtx.getServiceContextPath();
                int beginIndex = -1;
                if (requestUri.indexOf(contextPath) != -1) {
                    beginIndex = requestUri.indexOf(contextPath) + contextPath.length() + 1;
                }
                boolean reverseProxyMode = Boolean.parseBoolean(System.getProperty("reverseProxyMode"));
                AxisService axisService = null;
                if (!reverseProxyMode) {
                    if (beginIndex >= 0 && beginIndex <= requestUri.length()) {
                        serviceName = requestUri.substring(beginIndex);
                        axisService = this.cfgCtx.getAxisConfiguration().getServiceForActivation(serviceName);
                    }
                    if (axisService == null && !loadBalancer && serviceName != null) {
                        try {
                            String tenantDomain = TenantAxisUtils.getTenantDomain((String)uri);
                            PrivilegedCarbonContext.startTenantFlow();
                            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
                            axisService = TenantAxisUtils.getAxisService((String)serviceName, (ConfigurationContext)this.cfgCtx);
                        }
                        catch (AxisFault axisFault) {
                            log.error((Object)("Error while retrieving Axis Service for Service name: " + serviceName), (Throwable)axisFault);
                        }
                        finally {
                            PrivilegedCarbonContext.endTenantFlow();
                        }
                    }
                }
                if (queryString != null) {
                    for (String item : this.getRequestProcessors.keySet()) {
                        if (queryString.indexOf(item) != 0 || !queryString.equals(item) && queryString.indexOf("&") != item.length() && queryString.indexOf("=") != item.length()) continue;
                        if (axisService == null) {
                            try {
                                String tenantDomain = TenantAxisUtils.getTenantDomain((String)uri);
                                PrivilegedCarbonContext.startTenantFlow();
                                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
                                if (!RequestProcessorDispatcherUtil.isDispatchToApiGetProcessor(requestUri, this.cfgCtx)) {
                                    continue;
                                }
                            }
                            finally {
                                PrivilegedCarbonContext.endTenantFlow();
                                continue;
                            }
                        }
                        try {
                            this.processWithGetProcessor(request, response, requestUri, requestUrl, queryString, item, outputStream, conn);
                            messageContext.setProperty("WSDL_GEN_HANDLED", (Object)true);
                        }
                        catch (Exception e) {
                            this.handleBrowserException(response, conn, outputStream, "Error processing request", e);
                        }
                        isRequestHandled = true;
                        break;
                    }
                }
            }
        }
        if (!isRequestHandled) {
            messageContext.setProperty("rest_get_delete_invoke", (Object)true);
        }
    }

    protected void generateServicesList(HttpResponse response, NHttpServerConnection conn, OutputStream os, String servicePath) {
        try {
            byte[] bytes = this.getServicesHTML(servicePath.endsWith("/") ? "" : servicePath + "/").getBytes();
            response.addHeader(CONTENT_TYPE, TEXT_HTML);
            os.write(bytes);
        }
        catch (IOException e) {
            this.handleBrowserException(response, conn, os, "Error generating services list", e);
        }
    }

    protected String getServicesHTML(String prefix) {
        HashMap services = this.cfgCtx.getAxisConfiguration().getServices();
        Hashtable erroneousServices = this.cfgCtx.getAxisConfiguration().getFaultyServices();
        boolean servicesFound = false;
        StringBuffer resultBuf = new StringBuffer();
        resultBuf.append("<html><head><title>Axis2: Services</title></head><body>");
        if (services != null && !services.isEmpty()) {
            servicesFound = true;
            resultBuf.append("<h2>Deployed services</h2>");
            for (Object service : services.values()) {
                boolean isSkippedService;
                AxisService axisService = (AxisService)service;
                Parameter isHiddenService = axisService.getParameter("hiddenService");
                Parameter isAdminService = axisService.getParameter("adminService");
                boolean isClientSide = axisService.isClientSide();
                boolean bl = isSkippedService = isHiddenService != null && JavaUtils.isTrueExplicitly((Object)isHiddenService.getValue()) || isAdminService != null && JavaUtils.isTrueExplicitly((Object)isAdminService.getValue()) || isClientSide;
                if (axisService.getName().startsWith("__") || isSkippedService) continue;
                Iterator iterator = axisService.getOperations();
                resultBuf.append("<h3><a href=\"").append(prefix).append(axisService.getName()).append("?wsdl\">").append(axisService.getName()).append("</a></h3>");
                if (iterator.hasNext()) {
                    resultBuf.append("Available operations <ul>");
                    while (iterator.hasNext()) {
                        AxisOperation axisOperation = (AxisOperation)iterator.next();
                        resultBuf.append("<li>").append(axisOperation.getName().getLocalPart()).append("</li>");
                    }
                    resultBuf.append("</ul>");
                    continue;
                }
                resultBuf.append("No operations specified for this service");
            }
        }
        if (erroneousServices != null && !erroneousServices.isEmpty()) {
            servicesFound = true;
            resultBuf.append("<hr><h2><font color=\"blue\">Faulty Services</font></h2>");
            Enumeration faultyservices = erroneousServices.keys();
            while (faultyservices.hasMoreElements()) {
                String faultyserviceName = (String)faultyservices.nextElement();
                resultBuf.append("<h3><font color=\"blue\">").append(faultyserviceName).append("</font></h3>");
            }
        }
        if (!servicesFound) {
            resultBuf.append("<h2>There are no services deployed</h2>");
        }
        resultBuf.append("</body></html>");
        return resultBuf.toString();
    }

    protected boolean isServiceListBlocked(String incomingURI) {
        String isBlocked = NHttpConfiguration.getInstance().isServiceListBlocked();
        return ("/services".equals(incomingURI) || "/services/".equals(incomingURI)) && Boolean.parseBoolean(isBlocked);
    }

    protected void handleBrowserException(HttpResponse response, NHttpServerConnection conn, OutputStream os, String msg, Exception e) {
        if (e == null) {
            log.error((Object)msg);
        } else {
            log.error((Object)msg, (Throwable)e);
        }
        if (!response.containsHeader("Transfer-Encoding")) {
            response.setStatusCode(500);
            response.setReasonPhrase(msg);
            try {
                os.write(msg.getBytes());
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getServiceName(HttpRequest request) {
        int opnStart;
        String uri = request.getRequestLine().getUri();
        String servicePath = this.cfgCtx.getServiceContextPath();
        if (!servicePath.startsWith("/")) {
            servicePath = "/" + servicePath;
        }
        String serviceName = null;
        if (uri.startsWith(servicePath)) {
            serviceName = uri.substring(servicePath.length());
            if (serviceName.startsWith("/")) {
                serviceName = serviceName.substring(1);
            }
            if (serviceName.indexOf("?") != -1) {
                serviceName = serviceName.substring(0, serviceName.indexOf("?"));
            }
        } else {
            String incomingURI = request.getRequestLine().getUri();
            Map serviceURIMap = (Map)this.cfgCtx.getProperty("service.epr.map");
            if (serviceURIMap != null) {
                Set keySet = serviceURIMap.keySet();
                for (Object key : keySet) {
                    if (!incomingURI.toLowerCase().contains(((String)key).toLowerCase())) continue;
                    return (String)serviceURIMap.get(key);
                }
            }
        }
        if (serviceName != null && (opnStart = serviceName.indexOf("/")) != -1) {
            serviceName = serviceName.substring(0, opnStart);
        }
        return serviceName;
    }

    public void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

