/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.oauth.listener;

import java.sql.Timestamp;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.data.publisher.oauth.OAuthDataPublisherUtils;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.event.AbstractOAuthEventInterceptor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuthRevocationRequestDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuthRevocationResponseDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;

public class TokenRevocationAuditLogger
extends AbstractOAuthEventInterceptor {
    private static final Log AUDIT_LOG = LogFactory.getLog((String)"AUDIT_LOG");
    public static final int MILLIS_TO_SECONDS_FACTOR = 1000;
    private static final Log log = LogFactory.getLog(TokenRevocationAuditLogger.class);

    public void onPostTokenRevocationByClient(OAuthRevocationRequestDTO revokeRequestDTO, OAuthRevocationResponseDTO revokeResponseDTO, AccessTokenDO accessTokenDO, RefreshTokenValidationDataDO refreshTokenDO, Map<String, Object> params) throws IdentityOAuth2Exception {
        String auditResult;
        String authenticatedSubjectIdentifier = "N/A";
        String authenticatedUserStoreDomain = "N/A";
        String authenticatedUserTenantDomain = "N/A";
        String tokenType = "N/A";
        String requestInitiator = "N/A";
        String activeDuration = "N/A";
        Timestamp issuedTime = null;
        Timestamp revokedTime = new Timestamp(System.currentTimeMillis());
        if (StringUtils.isNotEmpty((String)revokeRequestDTO.getToken_type())) {
            tokenType = revokeRequestDTO.getToken_type();
        }
        if (revokeResponseDTO.isError()) {
            auditResult = "Failed";
        } else {
            auditResult = "Success";
            if (refreshTokenDO != null && refreshTokenDO.getAuthorizedUser() != null) {
                authenticatedSubjectIdentifier = refreshTokenDO.getAuthorizedUser().getAuthenticatedSubjectIdentifier();
                authenticatedUserTenantDomain = refreshTokenDO.getAuthorizedUser().getTenantDomain();
                authenticatedUserStoreDomain = refreshTokenDO.getAuthorizedUser().getUserStoreDomain();
                requestInitiator = refreshTokenDO.getAuthorizedUser().toString();
                issuedTime = refreshTokenDO.getIssuedTime();
            } else if (accessTokenDO != null && accessTokenDO.getAuthzUser() != null) {
                authenticatedSubjectIdentifier = accessTokenDO.getAuthzUser().getAuthenticatedSubjectIdentifier();
                authenticatedUserTenantDomain = accessTokenDO.getAuthzUser().getTenantDomain();
                authenticatedUserStoreDomain = accessTokenDO.getAuthzUser().getUserStoreDomain();
                requestInitiator = accessTokenDO.getAuthzUser().toString();
                issuedTime = accessTokenDO.getIssuedTime();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Unknown token in revocation request for client id: " + revokeRequestDTO.getConsumerKey()));
            }
            if (issuedTime != null) {
                long activePeriodInMillis = revokedTime.getTime() - issuedTime.getTime();
                activeDuration = activePeriodInMillis / 1000L + "s";
            }
        }
        String serviceProvider = this.getServiceProvider(revokeRequestDTO);
        String auditData = "\"AuthenticatedUser\" : \"" + authenticatedSubjectIdentifier + "\", \"AuthenticatedUserStoreDomain\" : \"" + authenticatedUserStoreDomain + "\", \"AuthenticatedUserTenantDomain\" : \"" + authenticatedUserTenantDomain + "\", \"ServiceProvider\" : \"" + serviceProvider + "\", \"TokenType\" : \"" + tokenType + "\", \"ActiveDuration\" : \"" + activeDuration + "\", \"RelyingParty\" : \"" + revokeRequestDTO.getConsumerKey() + "\"";
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", requestInitiator, "PostTokenRevocationByClient", "TokenRevocationAuditLogger", auditData, auditResult));
    }

    private String getServiceProvider(OAuthRevocationRequestDTO revokeRequestDTO) throws IdentityOAuth2Exception {
        String serviceProvider;
        block3: {
            serviceProvider = "N/A";
            try {
                OAuthAppDO oAuthAppDO = OAuthDataPublisherUtils.getApplication(revokeRequestDTO.getConsumerKey());
                if (oAuthAppDO != null && oAuthAppDO.getUser() != null) {
                    serviceProvider = oAuthAppDO.getApplicationName();
                }
            }
            catch (InvalidOAuthClientException e) {
                log.error((Object)"Error while retrieving oauth application.");
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)e);
            }
        }
        return serviceProvider;
    }
}

