/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.oauth.listener;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.handler.AbstractIdentityHandler;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.event.AbstractOAuthEventInterceptor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class PasswordGrantAuditLogger
extends AbstractOAuthEventInterceptor {
    private static final Log AUDIT_LOG = LogFactory.getLog((String)"AUDIT_LOG");
    private static final String PASSWORD_GRANT = "password";

    public void onPostTokenIssue(OAuth2AccessTokenReqDTO tokenReqDTO, OAuth2AccessTokenRespDTO tokenRespDTO, OAuthTokenReqMessageContext tokReqMsgCtx, Map<String, Object> params) throws IdentityOAuth2Exception {
        String auditResult;
        if (!this.isPasswordGrant(tokenReqDTO)) {
            return;
        }
        String requestType = "N/A";
        String serviceProvider = "N/A";
        String authenticatedSubjectIdentifier = "N/A";
        String authenticatedUserStoreDomain = "N/A";
        String authenticatedUserTenantDomain = "N/A";
        if (tokReqMsgCtx.getProperty((Object)"OAuthAppDO") instanceof OAuthAppDO) {
            OAuthAppDO oAuthAppDO = (OAuthAppDO)tokReqMsgCtx.getProperty((Object)"OAuthAppDO");
            requestType = this.getRequestType(tokReqMsgCtx);
            serviceProvider = oAuthAppDO.getApplicationName();
        }
        String requestInitiator = this.getResourceOwnerUsername(tokReqMsgCtx);
        if (this.isTokenRequestSuccessful(tokReqMsgCtx)) {
            authenticatedSubjectIdentifier = this.getAuthenticatedSubjectIdentifier(tokReqMsgCtx);
            authenticatedUserStoreDomain = tokReqMsgCtx.getAuthorizedUser().getUserStoreDomain();
            authenticatedUserTenantDomain = tokReqMsgCtx.getAuthorizedUser().getTenantDomain();
            auditResult = "Success";
        } else {
            auditResult = "Failed";
        }
        String auditData = "\"AuthenticatedUser\" : \"" + authenticatedSubjectIdentifier + "\",\"AuthenticatedUserStoreDomain\" : \"" + authenticatedUserStoreDomain + "\",\"AuthenticatedUserTenantDomain\" : \"" + authenticatedUserTenantDomain + "\",\"ServiceProvider\" : \"" + serviceProvider + "\",\"RequestType\" : \"" + requestType + "\",\"RelyingParty\" : \"" + tokenReqDTO.getClientId() + "\"";
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", requestInitiator, "PostTokenIssue", "PasswordGrantAuditLogger", auditData, auditResult));
    }

    private String getResourceOwnerUsername(OAuthTokenReqMessageContext tokReqMsgCtx) {
        return tokReqMsgCtx.getOauth2AccessTokenReqDTO().getResourceOwnerUsername();
    }

    private String getRequestType(OAuthTokenReqMessageContext tokReqMsgCtx) {
        boolean isOpenIdConnect = OAuth2Util.isOIDCAuthzRequest((String[])tokReqMsgCtx.getOauth2AccessTokenReqDTO().getScope());
        return isOpenIdConnect ? "oidc" : "oauth2";
    }

    private String getAuthenticatedSubjectIdentifier(OAuthTokenReqMessageContext tokReqMsgCtx) {
        return tokReqMsgCtx.getAuthorizedUser().getAuthenticatedSubjectIdentifier();
    }

    private boolean isTokenRequestSuccessful(OAuthTokenReqMessageContext tokReqMsgCtx) {
        return tokReqMsgCtx.getAuthorizedUser() != null;
    }

    private boolean isPasswordGrant(OAuth2AccessTokenReqDTO tokenReqDTO) {
        return PASSWORD_GRANT.equals(tokenReqDTO.getGrantType());
    }

    public boolean isEnabled() {
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)AbstractIdentityHandler.class.getName(), (String)((Object)((Object)this)).getClass().getName());
        return identityEventListenerConfig == null || Boolean.parseBoolean(identityEventListenerConfig.getEnable());
    }
}

