/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.oauth.listener;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.data.publisher.oauth.OAuthDataPublisherUtils;
import org.wso2.carbon.identity.data.publisher.oauth.internal.OAuthDataPublisherServiceHolder;
import org.wso2.carbon.identity.data.publisher.oauth.model.TokenData;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.event.AbstractOAuthEventInterceptor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuth2IntrospectionResponseDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.OAuth2TokenValidationMessageContext;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuthTokenValidationDASDataPublisher
extends AbstractOAuthEventInterceptor {
    public static final Log LOG = LogFactory.getLog(OAuthTokenValidationDASDataPublisher.class);

    public void onPostTokenValidation(OAuth2TokenValidationRequestDTO oAuth2TokenValidationRequestDTO, OAuth2TokenValidationResponseDTO oAuth2TokenValidationResponseDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        AccessTokenDO accessTokenDO;
        try {
            accessTokenDO = OAuth2Util.getAccessTokenDOfromTokenIdentifier((String)oAuth2TokenValidationRequestDTO.getAccessToken().getIdentifier());
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"The access token is invalid. Hence failed to publish data through OauthTokenValidationDASDataPublisher");
            return;
        }
        StringBuilder authzScopes = new StringBuilder();
        List<String> grantedScopes = Arrays.asList(oAuth2TokenValidationResponseDTO.getScope());
        TokenData tokenData = new TokenData();
        if (accessTokenDO != null) {
            tokenData.setClientId(accessTokenDO.getConsumerKey());
            tokenData.setIssuedTime(accessTokenDO.getIssuedTime().getTime());
            tokenData.setAccessTokenValidityMillis(accessTokenDO.getValidityPeriodInMillis());
            tokenData.setIssuedTime(accessTokenDO.getIssuedTime().getTime());
        }
        tokenData.setTokenId(oAuth2TokenValidationRequestDTO.getAccessToken().getIdentifier());
        tokenData.setUser(oAuth2TokenValidationResponseDTO.getAuthorizedUser());
        tokenData.setGrantType(oAuth2TokenValidationRequestDTO.getAccessToken().getTokenType());
        for (String scope : grantedScopes) {
            authzScopes.append(scope).append(" ");
        }
        if (IdentityUtil.isNotBlank((String)authzScopes.toString())) {
            tokenData.setAuthzScopes(authzScopes.toString());
        }
        if (StringUtils.isNotBlank((String)tokenData.getUser())) {
            tokenData.setTenantDomain(MultitenantUtils.getTenantDomain((String)tokenData.getUser()));
            tokenData.setUserStoreDomain(IdentityUtil.extractDomainFromName((String)tokenData.getUser()));
        }
        tokenData.setIsActive(oAuth2TokenValidationResponseDTO.isValid());
        this.doPublishOauthTokenValidation(tokenData);
    }

    public void onPostTokenValidation(OAuth2TokenValidationRequestDTO oAuth2TokenValidationRequestDTO, OAuth2IntrospectionResponseDTO oAuth2IntrospectionResponseDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        AccessTokenDO accessTokenDO;
        OAuth2TokenValidationMessageContext tokenValidationMessageContext;
        StringBuilder authzScopes = new StringBuilder();
        String[] publishingTenantDomains = null;
        List<String> grantedScopes = Arrays.asList(oAuth2IntrospectionResponseDTO.getScope());
        TokenData<String, String[]> tokenData = new TokenData<String, String[]>();
        tokenData.setTokenId(oAuth2TokenValidationRequestDTO.getAccessToken().getIdentifier());
        tokenData.setUser(oAuth2IntrospectionResponseDTO.getUsername());
        if (tokenData.getUser() != null) {
            tokenData.setTenantDomain(MultitenantUtils.getTenantDomain((String)tokenData.getUser()));
            tokenData.setUserStoreDomain(IdentityUtil.extractDomainFromName((String)tokenData.getUser()));
        }
        tokenData.setGrantType(oAuth2TokenValidationRequestDTO.getAccessToken().getTokenType());
        for (String scope : grantedScopes) {
            authzScopes.append(scope).append(" ");
        }
        if (params != null && params.get("OAuth2TokenValidationMessageContext") != null && (tokenValidationMessageContext = (OAuth2TokenValidationMessageContext)params.get("OAuth2TokenValidationMessageContext")).getProperty((Object)"AccessTokenDO") != null && (accessTokenDO = (AccessTokenDO)tokenValidationMessageContext.getProperty((Object)"AccessTokenDO")) != null) {
            tokenData.setClientId(accessTokenDO.getConsumerKey());
            try {
                OAuthAppDO oAuthAppDO = OAuthDataPublisherUtils.getApplication(accessTokenDO.getConsumerKey());
                if (oAuthAppDO != null && oAuthAppDO.getUser() != null) {
                    publishingTenantDomains = OAuthDataPublisherUtils.getTenantDomains(oAuthAppDO.getUser().getTenantDomain(), tokenData.getTenantDomain());
                }
            }
            catch (InvalidOAuthClientException e) {
                LOG.debug((Object)"Could not retrieve oauth application information, Hence not publishing application data");
            }
        }
        if (publishingTenantDomains == null) {
            publishingTenantDomains = OAuthDataPublisherUtils.getTenantDomains(null, tokenData.getTenantDomain());
        }
        tokenData.addParameter("TENANT_ID", publishingTenantDomains);
        if (IdentityUtil.isNotBlank((String)authzScopes.toString())) {
            tokenData.setAuthzScopes(authzScopes.toString());
        }
        tokenData.setIssuedTime(oAuth2IntrospectionResponseDTO.getIat());
        if (tokenData.isActive() && tokenData.getClientId() != null && oAuth2IntrospectionResponseDTO.getExp() >= 0L) {
            tokenData.setAccessTokenValidityMillis(System.currentTimeMillis() - oAuth2IntrospectionResponseDTO.getExp());
        }
        tokenData.setIsActive(oAuth2IntrospectionResponseDTO.isActive());
        this.doPublishOauthTokenValidation(tokenData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPublishOauthTokenValidation(TokenData tokenData) {
        Object[] payloadData = new Object[]{tokenData.getTokenId(), tokenData.getClientId(), tokenData.getUser(), tokenData.getTenantDomain(), tokenData.getUserStoreDomain(), tokenData.getGrantType(), tokenData.getAuthzScopes(), tokenData.isActive(), tokenData.getAccessTokenValidityMillis(), tokenData.getIssuedTime()};
        String[] publishingDomains = (String[])tokenData.getParameter("TENANT_ID");
        if (publishingDomains != null && publishingDomains.length > 0) {
            try {
                FrameworkUtils.startTenantFlow((String)"carbon.super");
                for (String publishingDomain : publishingDomains) {
                    Object[] metadataArray = OAuthDataPublisherUtils.getMetaDataArray(publishingDomain);
                    Event event = new Event("org.wso2.is.analytics.stream.OauthTokenValidation:1.0.0", System.currentTimeMillis(), metadataArray, null, payloadData);
                    OAuthDataPublisherServiceHolder.getInstance().getPublisherService().publish(event);
                    if (!LOG.isDebugEnabled() || event == null) continue;
                    LOG.debug((Object)("Sending out event : " + event.toString()));
                }
            }
            finally {
                FrameworkUtils.endTenantFlow();
            }
        }
    }

    public String getName() {
        return "OauthTokenValidationDASDataPublisher";
    }
}

