/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.oauth.listener;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.data.publisher.oauth.OAuthDataPublisherUtils;
import org.wso2.carbon.identity.data.publisher.oauth.internal.OAuthDataPublisherServiceHolder;
import org.wso2.carbon.identity.data.publisher.oauth.model.TokenData;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.dto.OAuthRevocationRequestDTO;
import org.wso2.carbon.identity.oauth.event.AbstractOAuthEventInterceptor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuthRevocationResponseDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class OAuthTokenRevocationDASPublisher
extends AbstractOAuthEventInterceptor {
    public static final Log LOG = LogFactory.getLog(OAuthTokenRevocationDASPublisher.class);

    public void onPostTokenRevocationByClient(org.wso2.carbon.identity.oauth2.dto.OAuthRevocationRequestDTO oAuthRevocationRequestDTO, OAuthRevocationResponseDTO oAuthRevocationResponseDTO, AccessTokenDO accessTokenDO, RefreshTokenValidationDataDO refreshTokenValidationDataDO, Map<String, Object> params) throws IdentityOAuth2Exception {
        TokenData<String, String[]> tokenData = new TokenData<String, String[]>();
        String spTenantDomain = null;
        if (oAuthRevocationResponseDTO.isError()) {
            tokenData.setErrorMsg(oAuthRevocationResponseDTO.getErrorMsg());
            tokenData.setErrorCode(oAuthRevocationResponseDTO.getErrorCode());
            tokenData.setIsSuccess(false);
        } else {
            tokenData.setIsSuccess(true);
        }
        tokenData.setTokenId(oAuthRevocationRequestDTO.getToken());
        tokenData.setClientId(oAuthRevocationRequestDTO.getConsumerKey());
        if (refreshTokenValidationDataDO != null) {
            tokenData.setUser(refreshTokenValidationDataDO.getAuthorizedUser().getUserName());
            tokenData.setTenantDomain(refreshTokenValidationDataDO.getAuthorizedUser().getTenantDomain());
            tokenData.setUserStoreDomain(refreshTokenValidationDataDO.getAuthorizedUser().getUserStoreDomain());
            if (refreshTokenValidationDataDO.getIssuedTime() != null) {
                tokenData.setIssuedTime(refreshTokenValidationDataDO.getIssuedTime().getTime());
            }
            tokenData.setIssuedTime(accessTokenDO.getIssuedTime().getTime());
        }
        if (accessTokenDO != null) {
            tokenData.setGrantType(accessTokenDO.getGrantType());
            tokenData.setAuthzScopes(OAuth2Util.buildScopeString((String[])accessTokenDO.getScope()));
            if (accessTokenDO.getAuthzUser() != null) {
                tokenData.setUser(accessTokenDO.getAuthzUser().getUserName());
                tokenData.setTenantDomain(accessTokenDO.getAuthzUser().getTenantDomain());
                tokenData.setUserStoreDomain(accessTokenDO.getAuthzUser().getUserStoreDomain());
                if (accessTokenDO.getIssuedTime() != null) {
                    tokenData.setIssuedTime(accessTokenDO.getIssuedTime().getTime());
                }
                tokenData.setIssuedTime(accessTokenDO.getIssuedTime().getTime());
            }
        }
        try {
            OAuthAppDO oAuthAppDO = OAuthDataPublisherUtils.getApplication(oAuthRevocationRequestDTO.getConsumerKey());
            if (oAuthAppDO != null && oAuthAppDO.getUser() != null) {
                spTenantDomain = oAuthAppDO.getUser().getTenantDomain();
            }
        }
        catch (InvalidOAuthClientException e) {
            LOG.debug((Object)"Could not retrieve oauth application from given consumer key. Hence no relevant data will be published");
        }
        tokenData.setRevokedTime(System.currentTimeMillis());
        tokenData.addParameter("TENANT_ID", OAuthDataPublisherUtils.getTenantDomains(spTenantDomain, tokenData.getTenantDomain()));
        this.doPublishOauthTokenRevocation(tokenData);
    }

    public void onPostTokenRevocationByResourceOwner(OAuthRevocationRequestDTO oAuthRevocationRequestDTO, org.wso2.carbon.identity.oauth.dto.OAuthRevocationResponseDTO oAuthRevocationResponseDTO, AccessTokenDO accessTokenDO, Map<String, Object> params) throws IdentityOAuth2Exception {
        TokenData<String, String[]> tokenData = new TokenData<String, String[]>();
        String spTenantDomain = null;
        tokenData.setClientId(oAuthRevocationRequestDTO.getConsumerKey());
        if (oAuthRevocationResponseDTO != null && oAuthRevocationResponseDTO.isError()) {
            tokenData.setIsSuccess(false);
            tokenData.setErrorCode(oAuthRevocationResponseDTO.getErrorCode());
            tokenData.setErrorMsg(oAuthRevocationResponseDTO.getErrorMsg());
        } else {
            tokenData.setIsSuccess(true);
        }
        if (accessTokenDO != null) {
            tokenData.setTokenId(accessTokenDO.getTokenId());
            tokenData.setGrantType(accessTokenDO.getGrantType());
            tokenData.setAuthzScopes(OAuth2Util.buildScopeString((String[])accessTokenDO.getScope()));
            tokenData.setIssuedTime(accessTokenDO.getIssuedTime().getTime());
            if (accessTokenDO.getAuthzUser() != null) {
                tokenData.setUser(accessTokenDO.getAuthzUser().getUserName());
                tokenData.setTenantDomain(accessTokenDO.getAuthzUser().getTenantDomain());
                tokenData.setUserStoreDomain(accessTokenDO.getAuthzUser().getUserStoreDomain());
            }
            try {
                OAuthAppDO oAuthAppDO = OAuthDataPublisherUtils.getApplication(accessTokenDO.getConsumerKey());
                if (oAuthAppDO != null && oAuthAppDO.getUser() != null) {
                    spTenantDomain = oAuthAppDO.getUser().getTenantDomain();
                }
            }
            catch (InvalidOAuthClientException e) {
                LOG.debug((Object)"Could not retrieve oauth application from given consumer key. Hence no relevant data will be published");
            }
        }
        tokenData.setRevokedTime(System.currentTimeMillis());
        tokenData.addParameter("TENANT_ID", OAuthDataPublisherUtils.getTenantDomains(spTenantDomain, tokenData.getTenantDomain()));
        this.doPublishOauthTokenRevocation(tokenData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPublishOauthTokenRevocation(TokenData tokenData) {
        Object[] payloadData = new Object[]{tokenData.getTokenId(), tokenData.getClientId(), tokenData.getUser(), tokenData.getTenantDomain(), tokenData.getUserStoreDomain(), tokenData.getGrantType(), tokenData.getAuthzScopes(), tokenData.getRevokedTime(), tokenData.getIssuedTime(), tokenData.isSuccess(), tokenData.getErrorMsg(), tokenData.getErrorCode()};
        String[] publishingDomains = (String[])tokenData.getParameter("TENANT_ID");
        if (publishingDomains != null && publishingDomains.length > 0) {
            try {
                FrameworkUtils.startTenantFlow((String)"carbon.super");
                for (String publishingDomain : publishingDomains) {
                    Object[] metadataArray = OAuthDataPublisherUtils.getMetaDataArray(publishingDomain);
                    Event event = new Event("org.wso2.is.analytics.stream.OauthTokenRevocation:1.0.0", System.currentTimeMillis(), metadataArray, null, payloadData);
                    OAuthDataPublisherServiceHolder.getInstance().getPublisherService().publish(event);
                    if (!LOG.isDebugEnabled() || event == null) continue;
                    LOG.debug((Object)("Sending out event : " + event.toString()));
                }
            }
            finally {
                FrameworkUtils.endTenantFlow();
            }
        }
    }

    public String getName() {
        return "OauthTokenRevocationDASDataPublisher";
    }
}

