/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.oauth.listener;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.oauth.event.AbstractOAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2IntrospectionResponseDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.validators.OAuth2TokenValidationMessageContext;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class OAuthTokenIssuanceLogPublisher
extends AbstractOAuthEventInterceptor
implements OAuthEventInterceptor {
    private static final Log TRANSACTION_LOG = LogFactory.getLog((String)"TRANSACTION_LOGGER");
    private static final Log LOG = LogFactory.getLog(OAuthTokenIssuanceLogPublisher.class);
    private static final String PROP_CLIENT_ID = "client_id";
    private static final String PROP_GRANT_TYPE = "grant_type";
    private static final String PROP_SCOPE = "scope";
    private static final String PROP_USER = "user";
    private static final String PROP_ERROR = "error";
    private static final String PROP_ERROR_DESCRIPTION = "error_description";
    private static final String PROP_ISSUED_TIME = "issued_time";
    private static final String PROP_TIME_TAKEN_IN_MILLIS = "time_taken_in_millis";
    private static final String PROP_EXPIRES_IN_SECONDS = "expires_in_seconds";
    private static final String PROP_SUCCESS = "success";
    private static final String LOG_INFO_TYPE_TOKEN = "OAUTH TOKEN";
    private static final String NOT_AVAILABLE = "N/A";
    private static final String TRANSACTION_LOG_FORMAT = "Type: %s | Info: %s";
    private static final String LOG_INFO_TYPE_INTROSPECTION = "OAUTH INTROSPECTION";
    private static final String PROP_TYPE = "type";
    private static final String TYPE_OAUTH = "oauth";
    private static final String TYPE_INTROSPECTION = "introspection";
    private static final String PROP_LOG_TOKEN = "Log.Token";
    private static final String PROP_TOKEN = "token";
    private static boolean isTokenLoggable;
    private static ThreadLocal<Long> startTime;

    public OAuthTokenIssuanceLogPublisher() {
        super.init(this.initConfig);
        String isTokenLoggableProperty = this.properties.getProperty(PROP_LOG_TOKEN);
        isTokenLoggable = StringUtils.isNotEmpty((String)isTokenLoggableProperty) && Boolean.parseBoolean(isTokenLoggableProperty);
    }

    public void onPreTokenIssue(OAuth2AccessTokenReqDTO tokenReqDTO, OAuthTokenReqMessageContext tokReqMsgCtx, Map<String, Object> params) throws IdentityOAuth2Exception {
        startTime.remove();
        startTime.set(System.currentTimeMillis());
    }

    public void onPreTokenIssue(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, Map<String, Object> params) throws IdentityOAuth2Exception {
        startTime.remove();
        startTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostTokenIssue(OAuth2AccessTokenReqDTO tokenReqDTO, OAuth2AccessTokenRespDTO tokenRespDTO, OAuthTokenReqMessageContext tokReqMsgCtx, Map<String, Object> params) throws IdentityOAuth2Exception {
        try {
            String jsonInfo = this.getJsonInfoForPostTokenIssue(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, params);
            this.logTransactionInfo(jsonInfo, LOG_INFO_TYPE_TOKEN);
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error occurred while logging token information.", e);
            }
        }
        finally {
            startTime.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostTokenIssue(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, AccessTokenDO tokenDO, OAuth2AuthorizeRespDTO respDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        try {
            long expiresIn = respDTO.getValidityPeriod();
            long accessTokenIssuedTime = 0L;
            if (tokenDO.getIssuedTime() != null) {
                accessTokenIssuedTime = tokenDO.getIssuedTime().getTime();
            }
            String clientId = tokenDO.getConsumerKey();
            String grantType = tokenDO.getGrantType();
            Object[] scope = tokenDO.getScope();
            String scopeString = StringUtils.join((Object[])scope, (char)' ');
            AuthenticatedUser authorizedUser = tokenDO.getAuthzUser();
            String user = authorizedUser != null ? authorizedUser.getUsernameAsSubjectIdentifier(true, true) : NOT_AVAILABLE;
            HashMap<String, Object> infoParams = new HashMap<String, Object>();
            Gson gson = new Gson();
            infoParams.put(PROP_TYPE, TYPE_OAUTH);
            this.addStringToMap(PROP_CLIENT_ID, clientId, infoParams);
            this.addStringToMap(PROP_GRANT_TYPE, grantType, infoParams);
            this.addStringToMap(PROP_SCOPE, scopeString, infoParams);
            this.addStringToMap(PROP_USER, user, infoParams);
            if (StringUtils.isNotBlank((String)respDTO.getErrorCode()) || StringUtils.isNotBlank((String)respDTO.getErrorMsg())) {
                infoParams.put(PROP_SUCCESS, false);
                this.addStringToMap(PROP_ERROR, respDTO.getErrorCode(), infoParams);
                this.addStringToMap(PROP_ERROR_DESCRIPTION, respDTO.getErrorMsg(), infoParams);
            } else {
                infoParams.put(PROP_SUCCESS, true);
                infoParams.put(PROP_ISSUED_TIME, accessTokenIssuedTime);
                infoParams.put(PROP_EXPIRES_IN_SECONDS, expiresIn);
                long timeTaken = System.currentTimeMillis() - startTime.get();
                infoParams.put(PROP_TIME_TAKEN_IN_MILLIS, timeTaken);
            }
            this.logTransactionInfo(gson.toJson(infoParams), LOG_INFO_TYPE_TOKEN);
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error occurred while logging token information.", e);
            }
        }
        finally {
            startTime.remove();
        }
    }

    public void onPreTokenRenewal(OAuth2AccessTokenReqDTO tokenReqDTO, OAuthTokenReqMessageContext tokReqMsgCtx, Map<String, Object> params) throws IdentityOAuth2Exception {
        startTime.remove();
        startTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostTokenRenewal(OAuth2AccessTokenReqDTO tokenReqDTO, OAuth2AccessTokenRespDTO tokenRespDTO, OAuthTokenReqMessageContext tokReqMsgCtx, Map<String, Object> params) throws IdentityOAuth2Exception {
        try {
            String jsonInfo = this.getJsonInfoForPostTokenIssue(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, params);
            this.logTransactionInfo(jsonInfo, LOG_INFO_TYPE_TOKEN);
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error occurred while logging token information.", e);
            }
        }
        finally {
            startTime.remove();
        }
    }

    private String getJsonInfoForPostTokenIssue(OAuth2AccessTokenReqDTO tokenReqDTO, OAuth2AccessTokenRespDTO tokenRespDTO, OAuthTokenReqMessageContext tokReqMsgCtx, Map<String, Object> params) {
        String tenantDomain;
        long accessTokenIssuedTime = tokReqMsgCtx.getAccessTokenIssuedTime();
        long expiresIn = tokenRespDTO.getExpiresIn();
        String clientId = tokenReqDTO.getClientId();
        String grantType = tokenReqDTO.getGrantType();
        Object[] scope = tokenReqDTO.getScope();
        String scopeString = StringUtils.join((Object[])scope, (char)' ');
        String resourceOwner = tokenReqDTO.getResourceOwnerUsername();
        AuthenticatedUser authorizedUser = tokReqMsgCtx.getAuthorizedUser();
        String user = authorizedUser != null ? authorizedUser.getUsernameAsSubjectIdentifier(true, true) : (StringUtils.isNotBlank((String)resourceOwner) ? (StringUtils.isNotBlank((String)(tenantDomain = tokenReqDTO.getTenantDomain())) ? UserCoreUtil.addTenantDomainToEntry((String)resourceOwner, (String)tenantDomain) : resourceOwner) : NOT_AVAILABLE);
        HashMap<String, Object> infoParams = new HashMap<String, Object>();
        Gson gson = new Gson();
        infoParams.put(PROP_TYPE, TYPE_OAUTH);
        this.addStringToMap(PROP_CLIENT_ID, clientId, infoParams);
        this.addStringToMap(PROP_GRANT_TYPE, grantType, infoParams);
        this.addStringToMap(PROP_SCOPE, scopeString, infoParams);
        this.addStringToMap(PROP_USER, user, infoParams);
        if (tokenRespDTO.isError()) {
            this.addStringToMap(PROP_ERROR, tokenRespDTO.getErrorCode(), infoParams);
            this.addStringToMap(PROP_ERROR_DESCRIPTION, tokenRespDTO.getErrorMsg(), infoParams);
            infoParams.put(PROP_SUCCESS, false);
        } else {
            infoParams.put(PROP_ISSUED_TIME, accessTokenIssuedTime);
            infoParams.put(PROP_EXPIRES_IN_SECONDS, expiresIn);
            infoParams.put(PROP_SUCCESS, true);
            long timeTaken = System.currentTimeMillis() - startTime.get();
            infoParams.put(PROP_TIME_TAKEN_IN_MILLIS, timeTaken);
        }
        return gson.toJson(infoParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTokenIssueException(Throwable throwable, Map<String, Object> params) throws IdentityOAuth2Exception {
        try {
            params.put(PROP_SUCCESS, false);
            params.put(PROP_TYPE, TYPE_OAUTH);
            Gson gson = new Gson();
            this.logTransactionInfo(gson.toJson(params), LOG_INFO_TYPE_TOKEN);
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error occurred while logging token error information.", e);
            }
        }
        finally {
            startTime.remove();
        }
    }

    private void addStringToMap(String name, String value, Map<String, Object> params) {
        if (StringUtils.isNotBlank((String)value)) {
            params.put(name, value);
        }
    }

    private void logTransactionInfo(String info, String logInfoType) {
        String transactionEntry = String.format(TRANSACTION_LOG_FORMAT, logInfoType, info);
        TRANSACTION_LOG.info((Object)transactionEntry);
    }

    public void onPreTokenValidation(OAuth2TokenValidationRequestDTO validationReqDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        startTime.remove();
        startTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostTokenValidation(OAuth2TokenValidationRequestDTO oAuth2TokenValidationRequestDTO, OAuth2IntrospectionResponseDTO oAuth2IntrospectionResponseDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        try {
            String jsonInfo = this.getJsonInfoForPostTokenValidation(oAuth2TokenValidationRequestDTO, oAuth2IntrospectionResponseDTO, params);
            this.logTransactionInfo(jsonInfo, LOG_INFO_TYPE_INTROSPECTION);
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error occurred while logging token introspection information.", e);
            }
        }
        finally {
            startTime.remove();
        }
    }

    protected String getJsonInfoForPostTokenValidation(OAuth2TokenValidationRequestDTO oAuth2TokenValidationRequestDTO, OAuth2IntrospectionResponseDTO oAuth2IntrospectionResponseDTO, Map<String, Object> params) {
        Gson gson = new Gson();
        HashMap<String, Object> infoParams = new HashMap<String, Object>();
        if (oAuth2IntrospectionResponseDTO.isActive()) {
            long expiresIn = oAuth2IntrospectionResponseDTO.getExp() - System.currentTimeMillis() / 1000L;
            long issuedAt = oAuth2IntrospectionResponseDTO.getIat();
            String scope = oAuth2IntrospectionResponseDTO.getScope();
            String clientId = oAuth2IntrospectionResponseDTO.getClientId();
            String username = oAuth2IntrospectionResponseDTO.getUsername();
            OAuth2TokenValidationMessageContext oAuth2TokenValidationMessageContext = (OAuth2TokenValidationMessageContext)oAuth2IntrospectionResponseDTO.getProperties().get("OAuth2TokenValidationMessageContext");
            AccessTokenDO accessTokenDO = (AccessTokenDO)oAuth2TokenValidationMessageContext.getProperty((Object)"AccessTokenDO");
            String grantType = accessTokenDO.getGrantType();
            infoParams.put(PROP_SUCCESS, true);
            infoParams.put(PROP_EXPIRES_IN_SECONDS, expiresIn);
            infoParams.put(PROP_ISSUED_TIME, issuedAt);
            this.addStringToMap(PROP_SCOPE, scope, infoParams);
            this.addStringToMap(PROP_CLIENT_ID, clientId, infoParams);
            this.addStringToMap(PROP_USER, username, infoParams);
            this.addStringToMap(PROP_GRANT_TYPE, grantType, infoParams);
        } else {
            infoParams.put(PROP_SUCCESS, false);
            this.addStringToMap(PROP_ERROR, oAuth2IntrospectionResponseDTO.getError(), infoParams);
        }
        if (isTokenLoggable) {
            this.addStringToMap(PROP_TOKEN, oAuth2TokenValidationRequestDTO.getAccessToken().getIdentifier(), infoParams);
        }
        infoParams.put(PROP_TYPE, TYPE_INTROSPECTION);
        long timeTaken = System.currentTimeMillis() - startTime.get();
        infoParams.put(PROP_TIME_TAKEN_IN_MILLIS, timeTaken);
        return gson.toJson(infoParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTokenValidationException(OAuth2TokenValidationRequestDTO introspectionRequest, Map<String, Object> params) throws IdentityOAuth2Exception {
        try {
            params.put(PROP_TYPE, TYPE_INTROSPECTION);
            params.put(PROP_SUCCESS, false);
            if (isTokenLoggable && introspectionRequest != null) {
                this.addStringToMap(PROP_TOKEN, introspectionRequest.getAccessToken().getIdentifier(), params);
            }
            if (startTime.get() != null) {
                long timeTaken = System.currentTimeMillis() - startTime.get();
                params.put(PROP_TIME_TAKEN_IN_MILLIS, timeTaken);
            }
            Gson gson = new Gson();
            this.logTransactionInfo(gson.toJson(params), LOG_INFO_TYPE_INTROSPECTION);
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error occurred while logging token introspection error information.", e);
            }
        }
        finally {
            startTime.remove();
        }
    }

    static {
        startTime = new ThreadLocal();
    }
}

