/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.oauth.listener;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.data.publisher.oauth.OAuthDataPublisherUtils;
import org.wso2.carbon.identity.data.publisher.oauth.internal.OAuthDataPublisherServiceHolder;
import org.wso2.carbon.identity.data.publisher.oauth.model.TokenData;
import org.wso2.carbon.identity.oauth.event.AbstractOAuthEventInterceptor;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class OAuthTokenIssuanceDASDataPublisher
extends AbstractOAuthEventInterceptor
implements OAuthEventInterceptor {
    public static final Log LOG = LogFactory.getLog(OAuthTokenIssuanceDASDataPublisher.class);

    public void onPostTokenIssue(OAuth2AccessTokenReqDTO tokenReqDTO, OAuth2AccessTokenRespDTO tokenRespDTO, OAuthTokenReqMessageContext tokReqMsgCtx, Map<String, Object> params) throws IdentityOAuth2Exception {
        TokenData<String, String[]> tokenData = new TokenData<String, String[]>();
        if (tokReqMsgCtx == null) {
            throw new IdentityOAuth2Exception("Empty token request message context");
        }
        AuthenticatedUser authorizedUser = tokReqMsgCtx.getAuthorizedUser();
        String[] publishingTenantDomains = null;
        if (authorizedUser != null) {
            tokenData.setIsSuccess(true);
            tokenData.setUser(authorizedUser.getUserName());
            tokenData.setUserStoreDomain(authorizedUser.getUserStoreDomain());
            tokenData.setTenantDomain(authorizedUser.getTenantDomain());
            publishingTenantDomains = OAuthDataPublisherUtils.getTenantDomains(tokenReqDTO.getTenantDomain(), authorizedUser.getTenantDomain());
        }
        tokenData.setIssuedTime(tokReqMsgCtx.getAccessTokenIssuedTime());
        tokenData.setRefreshTokenValidityMillis(tokReqMsgCtx.getRefreshTokenvalidityPeriod());
        tokenData.setGrantType(tokenReqDTO.getGrantType());
        tokenData.setClientId(tokenReqDTO.getClientId());
        tokenData.setTokenId(tokenRespDTO.getTokenId());
        StringBuilder unauthzScopes = new StringBuilder();
        LinkedList<String> requestedScopes = new LinkedList<String>(Arrays.asList(tokenReqDTO.getScope()));
        List<Object> grantedScopes = tokenRespDTO.getAuthorizedScopes() != null && StringUtils.isNotBlank((String)tokenRespDTO.getAuthorizedScopes()) ? Arrays.asList(tokenRespDTO.getAuthorizedScopes().split(" ")) : Collections.emptyList();
        requestedScopes.removeAll(grantedScopes);
        for (String scope : requestedScopes) {
            unauthzScopes.append(scope).append(" ");
        }
        if (publishingTenantDomains == null) {
            publishingTenantDomains = OAuthDataPublisherUtils.getTenantDomains(tokenReqDTO.getTenantDomain(), null);
        }
        tokenData.setAuthzScopes(tokenRespDTO.getAuthorizedScopes());
        tokenData.setUnAuthzScopes(unauthzScopes.toString());
        tokenData.setAccessTokenValidityMillis(tokenRespDTO.getExpiresInMillis());
        tokenData.addParameter("TENANT_ID", publishingTenantDomains);
        this.publishTokenIssueEvent(tokenData);
    }

    public void onPostTokenIssue(OAuthAuthzReqMessageContext oauthAuthzMsgCtx, AccessTokenDO tokenDO, OAuth2AuthorizeRespDTO respDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        String[] publishingTenantDomains = null;
        StringBuilder unauthzScopes = new StringBuilder();
        AuthenticatedUser user = oauthAuthzMsgCtx.getAuthorizationReqDTO().getUser();
        TokenData<String, String[]> tokenData = new TokenData<String, String[]>();
        if (user == null || tokenDO == null) {
            tokenData.setIsSuccess(false);
            tokenData.setErrorCode("server_error");
            tokenData.setErrorMsg("Error occurred when issuing token");
        }
        if (user != null) {
            tokenData.setUser(user.getUserName());
            tokenData.setUserStoreDomain(user.getUserStoreDomain());
            tokenData.setTenantDomain(user.getTenantDomain());
            publishingTenantDomains = oauthAuthzMsgCtx.getAuthorizationReqDTO() != null ? OAuthDataPublisherUtils.getTenantDomains(oauthAuthzMsgCtx.getAuthorizationReqDTO().getTenantDomain(), user.getTenantDomain()) : OAuthDataPublisherUtils.getTenantDomains(null, user.getTenantDomain());
            tokenData.setIsSuccess(true);
        }
        if (tokenDO != null) {
            tokenData.setTokenId(tokenDO.getTokenId());
            tokenData.setGrantType(tokenDO.getGrantType());
            tokenData.setClientId(tokenDO.getConsumerKey());
            tokenData.setAccessTokenValidityMillis(tokenDO.getValidityPeriodInMillis());
            tokenData.setRefreshTokenValidityMillis(tokenDO.getRefreshTokenValidityPeriodInMillis());
            tokenData.setIssuedTime(tokenDO.getIssuedTime().getTime());
        }
        LinkedList<String> requestedScopes = new LinkedList<String>(Arrays.asList(oauthAuthzMsgCtx.getAuthorizationReqDTO().getScopes()));
        List<String> grantedScopes = Arrays.asList(respDTO.getScope());
        requestedScopes.removeAll(grantedScopes);
        for (String scope : requestedScopes) {
            unauthzScopes.append(scope).append(" ");
        }
        tokenData.setAuthzScopes(OAuth2Util.buildScopeString((String[])respDTO.getScope()));
        tokenData.setUnAuthzScopes(unauthzScopes.toString());
        if (publishingTenantDomains == null && oauthAuthzMsgCtx.getAuthorizationReqDTO() != null) {
            publishingTenantDomains = OAuthDataPublisherUtils.getTenantDomains(oauthAuthzMsgCtx.getAuthorizationReqDTO().getTenantDomain(), null);
        }
        tokenData.addParameter("TENANT_ID", publishingTenantDomains);
        this.publishTokenIssueEvent(tokenData);
    }

    public void onPostTokenRenewal(OAuth2AccessTokenReqDTO tokenReqDTO, OAuth2AccessTokenRespDTO tokenRespDTO, OAuthTokenReqMessageContext tokReqMsgCtx, Map<String, Object> params) throws IdentityOAuth2Exception {
        this.onPostTokenIssue(tokenReqDTO, tokenRespDTO, tokReqMsgCtx, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishTokenIssueEvent(TokenData tokenData) {
        Object[] payloadData = new Object[]{tokenData.getUser(), tokenData.getTenantDomain(), tokenData.getUserStoreDomain(), tokenData.getClientId(), tokenData.getGrantType(), tokenData.getTokenId(), tokenData.getAuthzScopes(), tokenData.getUnAuthzScopes(), tokenData.isSuccess(), tokenData.getErrorCode(), tokenData.getErrorMsg(), tokenData.getAccessTokenValidityMillis(), tokenData.getRefreshTokenValidityMillis(), tokenData.getIssuedTime()};
        String[] publishingDomains = (String[])tokenData.getParameter("TENANT_ID");
        if (publishingDomains != null && publishingDomains.length > 0) {
            try {
                FrameworkUtils.startTenantFlow((String)"carbon.super");
                for (String publishingDomain : publishingDomains) {
                    Object[] metadataArray = OAuthDataPublisherUtils.getMetaDataArray(publishingDomain);
                    Event event = new Event("org.wso2.is.analytics.stream.OauthTokenIssuance:1.0.0", System.currentTimeMillis(), metadataArray, null, payloadData);
                    OAuthDataPublisherServiceHolder.getInstance().getPublisherService().publish(event);
                    if (!LOG.isDebugEnabled() || event == null) continue;
                    LOG.debug((Object)("Sending out event : " + event.toString()));
                }
            }
            finally {
                FrameworkUtils.endTenantFlow();
            }
        }
    }

    public String getName() {
        return "OauthTokenIssuanceDASDataPublisher";
    }
}

