/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.oauth.internal;

import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.identity.core.handler.HandlerComparator;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.data.publisher.oauth.OAuthInterceptorHandlerProxy;
import org.wso2.carbon.identity.data.publisher.oauth.internal.OAuthDataPublisherServiceHolder;
import org.wso2.carbon.identity.data.publisher.oauth.listener.OAuthTokenIssuanceDASDataPublisher;
import org.wso2.carbon.identity.data.publisher.oauth.listener.OAuthTokenIssuanceLogPublisher;
import org.wso2.carbon.identity.data.publisher.oauth.listener.OAuthTokenRevocationDASPublisher;
import org.wso2.carbon.identity.data.publisher.oauth.listener.OAuthTokenValidationDASDataPublisher;
import org.wso2.carbon.identity.data.publisher.oauth.listener.PasswordGrantAuditLogger;
import org.wso2.carbon.identity.data.publisher.oauth.listener.RefreshTokenGrantAuditLogger;
import org.wso2.carbon.identity.data.publisher.oauth.listener.SAML2BearerGrantAuditLogger;
import org.wso2.carbon.identity.data.publisher.oauth.listener.TokenRevocationAuditLogger;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;

@Component(name="org.wso2.carbon.identity.data.publisher.oauth", immediate=true)
public class OAuthDataPublisherServiceComponent {
    private static final Log log = LogFactory.getLog(OAuthDataPublisherServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        BundleContext bundleContext = context.getBundleContext();
        try {
            bundleContext.registerService(OAuthEventInterceptor.class, (Object)new OAuthTokenIssuanceDASDataPublisher(), null);
            bundleContext.registerService(OAuthEventInterceptor.class, (Object)new OAuthTokenIssuanceLogPublisher(), null);
            bundleContext.registerService(OAuthEventInterceptor.class, (Object)new OAuthTokenValidationDASDataPublisher(), null);
            bundleContext.registerService(OAuthEventInterceptor.class, (Object)new OAuthTokenRevocationDASPublisher(), null);
            bundleContext.registerService(OAuthEventInterceptor.class, (Object)new OAuthInterceptorHandlerProxy(), null);
            bundleContext.registerService(OAuthEventInterceptor.class, (Object)new PasswordGrantAuditLogger(), null);
            bundleContext.registerService(OAuthEventInterceptor.class, (Object)new SAML2BearerGrantAuditLogger(), null);
            bundleContext.registerService(OAuthEventInterceptor.class, (Object)new TokenRevocationAuditLogger(), null);
            bundleContext.registerService(OAuthEventInterceptor.class, (Object)new RefreshTokenGrantAuditLogger(), null);
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while activating Oauth data publisher bundle, ", e);
        }
    }

    @Reference(name="org.wso2.carbon.event.stream.core", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService publisherService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registering EventStreamService");
        }
        OAuthDataPublisherServiceHolder.getInstance().setPublisherService(publisherService);
    }

    protected void unsetEventStreamService(EventStreamService publisherService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-registering EventStreamService");
        }
        OAuthDataPublisherServiceHolder.getInstance().setPublisherService(null);
    }

    @Reference(name="org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor", service=OAuthEventInterceptor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetOauthEventInterceptor")
    protected void setAuthEventInterceptor(OAuthEventInterceptor oAuthEventInterceptor) {
        if (oAuthEventInterceptor == null) {
            log.warn((Object)"Null OAuthEventListener received, hence not registering");
            return;
        }
        if ("OauthDataInterceptorHandlerProxy".equalsIgnoreCase(oAuthEventInterceptor.getName())) {
            log.debug((Object)"Oauth intercepter Proxy is getting registered, Hence skipping");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting OAuthEventListener :" + oAuthEventInterceptor.getClass().getName()));
        }
        OAuthDataPublisherServiceHolder.getInstance().addOauthEventListener(oAuthEventInterceptor);
        Collections.sort(OAuthDataPublisherServiceHolder.getInstance().getOAuthEventInterceptors(), new HandlerComparator());
        Collections.reverse(OAuthDataPublisherServiceHolder.getInstance().getOAuthEventInterceptors());
    }

    protected void unsetOauthEventInterceptor(OAuthEventInterceptor oAuthEventInterceptor) {
        if (oAuthEventInterceptor == null) {
            log.warn((Object)"Null Oauth event interceptor received, hence not un-registering");
            return;
        }
        if ("OauthDataInterceptorHandlerProxy".equalsIgnoreCase(oAuthEventInterceptor.getName())) {
            log.debug((Object)"Proxy is un-registering, Hence skipping");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Un-setting oAuthEventInterceptor:" + oAuthEventInterceptor.getClass().getName()));
        }
        OAuthDataPublisherServiceHolder.getInstance().removeOauthEventListener(oAuthEventInterceptor);
    }

    @Reference(name="org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEvent")
    protected void setIdentityCoreInitializedEvent(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEvent(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }
}

