/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.oauth;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.handler.AbstractIdentityHandler;
import org.wso2.carbon.identity.data.publisher.oauth.internal.OAuthDataPublisherServiceHolder;
import org.wso2.carbon.identity.oauth.dto.OAuthRevocationRequestDTO;
import org.wso2.carbon.identity.oauth.event.OAuthEventInterceptor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AuthorizeRespDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2IntrospectionResponseDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuthRevocationResponseDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;

public class OAuthInterceptorHandlerProxy
extends AbstractIdentityHandler
implements OAuthEventInterceptor {
    private List<OAuthEventInterceptor> oAuthEventInterceptors = OAuthDataPublisherServiceHolder.getInstance().getOAuthEventInterceptors();
    private static final Log LOG = LogFactory.getLog(OAuthInterceptorHandlerProxy.class);

    public void onPreTokenIssue(OAuth2AccessTokenReqDTO oAuth2AccessTokenReqDTO, OAuthTokenReqMessageContext oAuthTokenReqMessageContext, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPreTokenIssue(oAuth2AccessTokenReqDTO, oAuthTokenReqMessageContext, params);
        }
    }

    public void onPostTokenIssue(OAuth2AccessTokenReqDTO oAuth2AccessTokenReqDTO, OAuth2AccessTokenRespDTO oAuth2AccessTokenRespDTO, OAuthTokenReqMessageContext oAuthTokenReqMessageContext, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPostTokenIssue(oAuth2AccessTokenReqDTO, oAuth2AccessTokenRespDTO, oAuthTokenReqMessageContext, params);
        }
    }

    public void onPreTokenIssue(OAuthAuthzReqMessageContext oAuthAuthzReqMessageContext, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPreTokenIssue(oAuthAuthzReqMessageContext, params);
        }
    }

    public void onPostTokenIssue(OAuthAuthzReqMessageContext oAuthAuthzReqMessageContext, AccessTokenDO accessTokenDO, OAuth2AuthorizeRespDTO oAuth2AuthorizeRespDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPostTokenIssue(oAuthAuthzReqMessageContext, accessTokenDO, oAuth2AuthorizeRespDTO, params);
        }
    }

    public void onPreTokenRenewal(OAuth2AccessTokenReqDTO oAuth2AccessTokenReqDTO, OAuthTokenReqMessageContext oAuthTokenReqMessageContext, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPreTokenRenewal(oAuth2AccessTokenReqDTO, oAuthTokenReqMessageContext, params);
        }
    }

    public void onPostTokenRenewal(OAuth2AccessTokenReqDTO oAuth2AccessTokenReqDTO, OAuth2AccessTokenRespDTO oAuth2AccessTokenRespDTO, OAuthTokenReqMessageContext oAuthTokenReqMessageContext, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPostTokenRenewal(oAuth2AccessTokenReqDTO, oAuth2AccessTokenRespDTO, oAuthTokenReqMessageContext, params);
        }
    }

    public void onPreTokenRevocationByClient(org.wso2.carbon.identity.oauth2.dto.OAuthRevocationRequestDTO oAuthRevocationRequestDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPreTokenRevocationByClient(oAuthRevocationRequestDTO, params);
        }
    }

    public void onPostTokenRevocationByClient(org.wso2.carbon.identity.oauth2.dto.OAuthRevocationRequestDTO oAuthRevocationRequestDTO, OAuthRevocationResponseDTO oAuthRevocationResponseDTO, AccessTokenDO accessTokenDO, RefreshTokenValidationDataDO refreshTokenValidationDataDO, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPostTokenRevocationByClient(oAuthRevocationRequestDTO, oAuthRevocationResponseDTO, accessTokenDO, refreshTokenValidationDataDO, params);
        }
    }

    public void onPreTokenRevocationByResourceOwner(OAuthRevocationRequestDTO oAuthRevocationRequestDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPreTokenRevocationByResourceOwner(oAuthRevocationRequestDTO, params);
        }
    }

    public void onPostTokenRevocationByResourceOwner(OAuthRevocationRequestDTO oAuthRevocationRequestDTO, org.wso2.carbon.identity.oauth.dto.OAuthRevocationResponseDTO oAuthRevocationResponseDTO, AccessTokenDO accessTokenDO, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPostTokenRevocationByResourceOwner(oAuthRevocationRequestDTO, oAuthRevocationResponseDTO, accessTokenDO, params);
        }
    }

    public void onPreTokenValidation(OAuth2TokenValidationRequestDTO oAuth2TokenValidationRequestDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPreTokenValidation(oAuth2TokenValidationRequestDTO, params);
        }
    }

    public void onPostTokenValidation(OAuth2TokenValidationRequestDTO oAuth2TokenValidationRequestDTO, OAuth2TokenValidationResponseDTO oAuth2TokenValidationResponseDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPostTokenValidation(oAuth2TokenValidationRequestDTO, oAuth2TokenValidationResponseDTO, params);
        }
    }

    public void onPostTokenValidation(OAuth2TokenValidationRequestDTO oAuth2TokenValidationRequestDTO, OAuth2IntrospectionResponseDTO oAuth2IntrospectionResponseDTO, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onPostTokenValidation(oAuth2TokenValidationRequestDTO, oAuth2IntrospectionResponseDTO, params);
        }
    }

    public void onTokenIssueException(Throwable throwable, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            if (!interceptor.isEnabled()) continue;
            interceptor.onTokenIssueException(throwable, params);
        }
    }

    public String getName() {
        return "OauthDataInterceptorHandlerProxy";
    }

    public void onTokenValidationException(OAuth2TokenValidationRequestDTO introspectionRequest, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            boolean isEnabled = interceptor.isEnabled();
            if (isEnabled) {
                interceptor.onTokenValidationException(introspectionRequest, params);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)String.format("Interceptor %s is %s", interceptor.getName(), isEnabled));
        }
    }

    public void onPreTokenRevocationBySystem(AccessTokenDO accessTokenDO, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            boolean isEnabled = interceptor.isEnabled();
            if (isEnabled) {
                interceptor.onPreTokenRevocationBySystem(accessTokenDO, params);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)String.format("Interceptor %s is enabled: %s", interceptor.getName(), isEnabled));
        }
    }

    public void onPostTokenRevocationBySystem(AccessTokenDO accessTokenDO, Map<String, Object> params) throws IdentityOAuth2Exception {
        for (OAuthEventInterceptor interceptor : this.oAuthEventInterceptors) {
            boolean isEnabled = interceptor.isEnabled();
            if (isEnabled) {
                interceptor.onPostTokenRevocationBySystem(accessTokenDO, params);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)String.format("Interceptor %s is enabled: %s", interceptor.getName(), isEnabled));
        }
    }
}

