/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.oauth;

import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.TokenMgtDAO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;

public class OAuthDataPublisherUtils {
    public static String[] getTenantDomains(String spTenantDomain, String userTenantDomain) {
        if (StringUtils.isBlank((String)userTenantDomain) || userTenantDomain.equalsIgnoreCase("NOT_AVAILABLE")) {
            return new String[]{spTenantDomain};
        }
        if (StringUtils.isBlank((String)spTenantDomain) || userTenantDomain.equalsIgnoreCase("NOT_AVAILABLE")) {
            return new String[]{userTenantDomain};
        }
        if (spTenantDomain.equalsIgnoreCase(userTenantDomain)) {
            return new String[]{userTenantDomain};
        }
        return new String[]{userTenantDomain, spTenantDomain};
    }

    public static Object[] getMetaDataArray(String tenantDomain) {
        Object[] metaData = new Object[]{StringUtils.isBlank((String)tenantDomain) ? Integer.valueOf(-1234) : Integer.valueOf(IdentityTenantUtil.getTenantId((String)tenantDomain))};
        return metaData;
    }

    public static OAuthAppDO getApplication(String consumerID) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        OAuthAppDAO oAuthAppDAO = new OAuthAppDAO();
        OAuthAppDO oAuthAppDO = oAuthAppDAO.getAppInformation(consumerID);
        return oAuthAppDO;
    }

    public static AccessTokenDO getTokenData(String token) throws IdentityOAuth2Exception, InvalidOAuthClientException {
        TokenMgtDAO tokenMgtDAO = new TokenMgtDAO();
        return tokenMgtDAO.retrieveAccessToken(token, true);
    }
}

